/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.xmlgraphics.image.codec.tiff.CompressionValue;
import org.apache.xmlgraphics.image.codec.tiff.ImageInfo;
import org.apache.xmlgraphics.image.codec.tiff.ImageType;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageEncoderImpl;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int[] SIZE_OF_TYPE = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    @Override
    public void encode(RenderedImage renderedImage) {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl2;
            int n2 = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n2 = this.encode(renderedImage2, tIFFEncodeParam2, n2, !(bl2 = iterator.hasNext()));
                if (!bl2) continue;
                Object e2 = iterator.next();
                if (e2 instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e2;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e2 instanceof Object[])) continue;
                Object[] objectArray = (Object[])e2;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl2);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    public Object encodeMultiple(Object object, RenderedImage renderedImage) {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        if (tIFFEncodeParam.getExtraImages() != null) {
            throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder11"));
        }
        Context context = (Context)object;
        if (context == null) {
            context = new Context();
            this.writeFileHeader();
        } else {
            context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, false);
        }
        context.nextImage = renderedImage;
        return context;
    }

    public void finishMultiple(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Context context = (Context)object;
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        CompressionValue compressionValue = tIFFEncodeParam.getCompression();
        if (compressionValue == CompressionValue.JPEG_TTN2) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFImageEncoder12"));
        }
        boolean bl3 = tIFFEncodeParam.getWriteTiled();
        int n10 = renderedImage.getMinX();
        int n11 = renderedImage.getMinY();
        int n12 = renderedImage.getWidth();
        int n13 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n14 = nArray[0];
        int n15 = sampleModel.getNumBands();
        int n16 = sampleModel.getDataType();
        this.validateImage(n14, nArray, n15, n16, colorModel);
        boolean bl4 = n16 == 2 || n16 == 1;
        ImageInfo imageInfo = ImageInfo.newInstance(renderedImage, n14, n15, colorModel, tIFFEncodeParam);
        if (imageInfo.getType() == ImageType.UNSUPPORTED) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder8"));
        }
        int n17 = imageInfo.getNumTiles();
        long l2 = imageInfo.getBytesPerTile();
        long l3 = imageInfo.getBytesPerRow();
        int n18 = imageInfo.getTileHeight();
        int n19 = imageInfo.getTileWidth();
        long[] lArray = new long[n17];
        for (int i2 = 0; i2 < n17; ++i2) {
            lArray[i2] = l2;
        }
        if (!bl3) {
            long l4 = n13 - n18 * (n17 - 1);
            lArray[n17 - 1] = l4 * l3;
        }
        long l5 = l2 * (long)(n17 - 1) + lArray[n17 - 1];
        long[] lArray2 = new long[n17];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n12}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n13}));
        char[] cArray = new char[n15];
        for (n9 = 0; n9 < n15; ++n9) {
            cArray[n9] = (char)n14;
        }
        treeSet.add(new TIFFField(258, 3, n15, cArray));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)compressionValue.getValue()}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)imageInfo.getType().getPhotometricInterpretation()}));
        if (!bl3) {
            treeSet.add(new TIFFField(273, 4, n17, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n15}));
        if (!bl3) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n18}));
            treeSet.add(new TIFFField(279, 4, n17, lArray));
        }
        if (imageInfo.getColormap() != null) {
            treeSet.add(new TIFFField(320, 3, imageInfo.getColormapSize(), imageInfo.getColormap()));
        }
        if (bl3) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n19}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n18}));
            treeSet.add(new TIFFField(324, 4, n17, lArray2));
            treeSet.add(new TIFFField(325, 4, n17, lArray));
        }
        if (imageInfo.getNumberOfExtraSamples() > 0) {
            char[] cArray2 = new char[imageInfo.getNumberOfExtraSamples()];
            for (n8 = 0; n8 < imageInfo.getNumberOfExtraSamples(); ++n8) {
                cArray2[n8] = (char)imageInfo.getExtraSamplesType().getValue();
            }
            treeSet.add(new TIFFField(338, 3, imageInfo.getNumberOfExtraSamples(), cArray2));
        }
        if (n16 != 0) {
            char[] cArray3 = new char[n15];
            cArray3[0] = n16 == 4 ? 3 : (n16 == 1 ? 1 : 2);
            for (n8 = 1; n8 < n15; ++n8) {
                cArray3[n8] = cArray3[0];
            }
            treeSet.add(new TIFFField(339, 3, n15, cArray3));
        }
        if (imageInfo.getType() == ImageType.YCBCR) {
            n9 = 1;
            n8 = 1;
            treeSet.add(new TIFFField(530, 3, 2, new char[]{'\u0001', '\u0001'}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{(char)(compressionValue == CompressionValue.JPEG_TTN2 ? 1 : 2)}));
            long[][] object = new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        TIFFField[] tIFFFieldArray = tIFFEncodeParam.getExtraFields();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeSet.size());
        for (TIFFField outputStream : treeSet) {
            arrayList.add(outputStream.getTag());
        }
        for (TIFFField tIFFField : tIFFFieldArray) {
            Integer n20 = tIFFField.getTag();
            if (arrayList.contains(n20)) continue;
            treeSet.add(tIFFField);
            arrayList.add(n20);
        }
        int n21 = this.getDirectorySize(treeSet);
        lArray2[0] = n2 + n21;
        OutputStream outputStream = null;
        byte[] byArray = null;
        Object var37_47 = null;
        int n22 = 0;
        boolean bl5 = false;
        Deflater deflater = null;
        boolean bl6 = false;
        if (compressionValue == CompressionValue.NONE) {
            int n23;
            n7 = 0;
            if (n14 == 16 && lArray2[0] % 2L != 0L) {
                n7 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (n14 == 32 && lArray2[0] % 4L != 0L) {
                n7 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n7;
            }
            for (n23 = 1; n23 < n17; ++n23) {
                lArray2[n23] = lArray2[n23 - 1] + lArray[n23 - 1];
            }
            if (!bl2 && ((n22 = (int)(lArray2[0] + l5)) & 1) != 0) {
                ++n22;
                bl5 = true;
            }
            this.writeDirectory(n2, treeSet, n22);
            if (n7 != 0) {
                for (n23 = 0; n23 < n7; ++n23) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                outputStream = this.output;
                try {
                    File file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (IOException iOException) {
                    this.output = new ByteArrayOutputStream((int)l5);
                }
            }
            n7 = 0;
            switch (compressionValue) {
                case PACKBITS: {
                    n7 = (int)(l2 + (l3 + 127L) / 128L * (long)n18);
                    break;
                }
                case DEFLATE: {
                    n7 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n7 = 0;
                }
            }
            if (n7 != 0) {
                byArray = new byte[n7];
            }
        }
        int[] nArray2 = null;
        float[] fArray = null;
        boolean bl7 = n14 == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n16 == 0 || n14 == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray2 = null;
        if (compressionValue != CompressionValue.JPEG_TTN2) {
            if (n16 == 0) {
                byArray2 = new byte[n18 * n19 * n15];
            } else if (bl4) {
                byArray2 = new byte[2 * n18 * n19 * n15];
            } else if (n16 == 3 || n16 == 4) {
                byArray2 = new byte[4 * n18 * n19 * n15];
            }
        }
        int n24 = n11 + n13;
        int n25 = n10 + n12;
        int n26 = 0;
        for (n6 = n11; n6 < n24; n6 += n18) {
            n5 = bl3 ? n18 : Math.min(n18, n24 - n6);
            n4 = n5 * n19 * n15;
            block25: for (n3 = n10; n3 < n25; n3 += n19) {
                int n27;
                int n28;
                int n29;
                Raster raster = renderedImage.getData(new Rectangle(n3, n6, n19, n5));
                boolean bl8 = false;
                if (compressionValue != CompressionValue.JPEG_TTN2) {
                    if (bl7) {
                        if (n14 == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray3 = componentSampleModel.getBankIndices();
                            int[] nArray4 = componentSampleModel.getBandOffsets();
                            n29 = componentSampleModel.getPixelStride();
                            n28 = componentSampleModel.getScanlineStride();
                            if (n29 != n15 || (long)n28 != l3) {
                                bl8 = false;
                            } else {
                                bl8 = true;
                                for (n27 = 0; bl8 && n27 < n15; ++n27) {
                                    if (nArray3[n27] == 0 && nArray4[n27] == n27) continue;
                                    bl8 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl8 = true;
                            }
                        }
                    }
                    if (!bl8) {
                        if (n16 == 4) {
                            fArray = raster.getPixels(n3, n6, n19, n5, fArray);
                        } else {
                            nArray2 = raster.getPixels(n3, n6, n19, n5, nArray2);
                        }
                    }
                }
                int n30 = 0;
                int n31 = 0;
                switch (n14) {
                    case 1: {
                        int n32;
                        int n33;
                        int n34;
                        if (bl8) {
                            byte[] byArray3 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n27 = multiPixelPackedSampleModel.getScanlineStride();
                            n34 = multiPixelPackedSampleModel.getOffset(n3 - raster.getSampleModelTranslateX(), n6 - raster.getSampleModelTranslateY());
                            if ((long)n27 == l3) {
                                System.arraycopy(byArray3, n34, byArray2, 0, (int)l3 * n5);
                            } else {
                                n33 = 0;
                                for (n32 = 0; n32 < n5; ++n32) {
                                    System.arraycopy(byArray3, n34, byArray2, n33, (int)l3);
                                    n34 += n27;
                                    n33 = (int)((long)n33 + l3);
                                }
                            }
                        } else {
                            int n35 = 0;
                            for (n29 = 0; n29 < n5; ++n29) {
                                for (n28 = 0; n28 < n19 / 8; ++n28) {
                                    n30 = nArray2[n35++] << 7 | nArray2[n35++] << 6 | nArray2[n35++] << 5 | nArray2[n35++] << 4 | nArray2[n35++] << 3 | nArray2[n35++] << 2 | nArray2[n35++] << 1 | nArray2[n35++];
                                    byArray2[n31++] = (byte)n30;
                                }
                                if (n19 % 8 <= 0) continue;
                                n30 = 0;
                                for (n28 = 0; n28 < n19 % 8; ++n28) {
                                    n30 |= nArray2[n35++] << 7 - n28;
                                }
                                byArray2[n31++] = (byte)n30;
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n5 * ((n19 + 7) / 8));
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            int n36 = TIFFImageEncoder.compressPackBits(byArray2, n5, l3, byArray);
                            lArray[n26++] = n36;
                            this.output.write(byArray, 0, n36);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        int n37 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n26++] = n37;
                        this.output.write(byArray, 0, n37);
                        continue block25;
                    }
                    case 4: {
                        int n38 = 0;
                        for (n29 = 0; n29 < n5; ++n29) {
                            for (n28 = 0; n28 < n19 / 2; ++n28) {
                                n30 = nArray2[n38++] << 4 | nArray2[n38++];
                                byArray2[n31++] = (byte)n30;
                            }
                            if ((n19 & 1) != 1) continue;
                            n30 = nArray2[n38++] << 4;
                            byArray2[n31++] = (byte)n30;
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n5 * ((n19 + 1) / 2));
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n29 = TIFFImageEncoder.compressPackBits(byArray2, n5, l3, byArray);
                            lArray[n26++] = n29;
                            this.output.write(byArray, 0, n29);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n29 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n26++] = n29;
                        this.output.write(byArray, 0, n29);
                        continue block25;
                    }
                    case 8: {
                        int n32;
                        int n33;
                        int n34;
                        if (compressionValue != CompressionValue.JPEG_TTN2) {
                            if (bl8) {
                                byte[] byArray4 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n27 = componentSampleModel.getOffset(n3 - raster.getSampleModelTranslateX(), n6 - raster.getSampleModelTranslateY());
                                n34 = componentSampleModel.getScanlineStride();
                                if ((long)n34 == l3) {
                                    System.arraycopy(byArray4, n27, byArray2, 0, (int)l3 * n5);
                                } else {
                                    n33 = 0;
                                    for (n32 = 0; n32 < n5; ++n32) {
                                        System.arraycopy(byArray4, n27, byArray2, n33, (int)l3);
                                        n27 += n34;
                                        n33 = (int)((long)n33 + l3);
                                    }
                                }
                            } else {
                                for (n29 = 0; n29 < n4; ++n29) {
                                    byArray2[n29] = (byte)nArray2[n29];
                                }
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n4);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n29 = TIFFImageEncoder.compressPackBits(byArray2, n5, l3, byArray);
                            lArray[n26++] = n29;
                            this.output.write(byArray, 0, n29);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n29 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n26++] = n29;
                        this.output.write(byArray, 0, n29);
                        continue block25;
                    }
                    case 16: {
                        n29 = 0;
                        for (n28 = 0; n28 < n4; ++n28) {
                            n27 = nArray2[n28];
                            byArray2[n29++] = (byte)((n27 & 0xFF00) >> 8);
                            byArray2[n29++] = (byte)(n27 & 0xFF);
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n4 * 2);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n28 = TIFFImageEncoder.compressPackBits(byArray2, n5, l3, byArray);
                            lArray[n26++] = n28;
                            this.output.write(byArray, 0, n28);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n28 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n26++] = n28;
                        this.output.write(byArray, 0, n28);
                        continue block25;
                    }
                    case 32: {
                        int n34;
                        if (n16 == 3) {
                            n28 = 0;
                            for (n27 = 0; n27 < n4; ++n27) {
                                n34 = nArray2[n27];
                                byArray2[n28++] = (byte)((n34 & 0xFF000000) >>> 24);
                                byArray2[n28++] = (byte)((n34 & 0xFF0000) >>> 16);
                                byArray2[n28++] = (byte)((n34 & 0xFF00) >>> 8);
                                byArray2[n28++] = (byte)(n34 & 0xFF);
                            }
                        } else {
                            n28 = 0;
                            for (n27 = 0; n27 < n4; ++n27) {
                                n34 = Float.floatToIntBits(fArray[n27]);
                                byArray2[n28++] = (byte)((n34 & 0xFF000000) >>> 24);
                                byArray2[n28++] = (byte)((n34 & 0xFF0000) >>> 16);
                                byArray2[n28++] = (byte)((n34 & 0xFF00) >>> 8);
                                byArray2[n28++] = (byte)(n34 & 0xFF);
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n4 * 4);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n28 = TIFFImageEncoder.compressPackBits(byArray2, n5, l3, byArray);
                            lArray[n26++] = n28;
                            this.output.write(byArray, 0, n28);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n28 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n26++] = n28;
                        this.output.write(byArray, 0, n28);
                        continue block25;
                    }
                }
            }
        }
        if (compressionValue == CompressionValue.NONE) {
            if (bl5) {
                this.output.write(0);
            }
        } else {
            void var37_49;
            n6 = 0;
            for (n5 = 1; n5 < n17; ++n5) {
                n4 = (int)lArray[n5 - 1];
                n6 += n4;
                lArray2[n5] = lArray2[n5 - 1] + (long)n4;
            }
            int n39 = n22 = bl2 ? 0 : n2 + n21 + (n6 += (int)lArray[n17 - 1]);
            if ((n22 & 1) != 0) {
                ++n22;
                bl5 = true;
            }
            if (outputStream == null) {
                if (bl5) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l4 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n2);
                this.writeDirectory(n2, treeSet, n22);
                seekableOutputStream.seek(l4);
            } else if (var37_49 != null) {
                FileInputStream fileInputStream = new FileInputStream((File)var37_49);
                try {
                    int n40;
                    this.output.close();
                    this.output = outputStream;
                    this.writeDirectory(n2, treeSet, n22);
                    byte[] byArray5 = new byte[8192];
                    for (n3 = 0; n3 < n6; n3 += n40) {
                        n40 = fileInputStream.read(byArray5);
                        if (n40 == -1) {
                            break;
                        }
                        this.output.write(byArray5, 0, n40);
                    }
                }
                finally {
                    fileInputStream.close();
                }
                boolean bl9 = var37_49.delete();
                assert (bl9);
                if (bl5) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = outputStream;
                this.writeDirectory(n2, treeSet, n22);
                byteArrayOutputStream.writeTo(this.output);
                if (bl5) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder13"));
            }
        }
        return n22;
    }

    private void validateImage(int n2, int[] nArray, int n3, int n4, ColorModel colorModel) {
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] == n2) continue;
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder0"));
        }
        if ((n2 == 1 || n2 == 4) && n3 != 1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder1"));
        }
        switch (n4) {
            case 0: {
                if (n2 != 4) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (n2 == 16) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (n2 == 32) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder5"));
            }
        }
        if (colorModel instanceof IndexColorModel && n4 != 0) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder6"));
        }
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n2 = sortedSet.size();
        int n3 = 2 + n2 * 12 + 4;
        for (Object e2 : sortedSet) {
            TIFFField tIFFField = (TIFFField)e2;
            int n4 = tIFFField.getCount() * SIZE_OF_TYPE[tIFFField.getType()];
            if (n4 <= 4) continue;
            n3 += n4;
        }
        return n3;
    }

    private void writeFileHeader() {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n2, SortedSet sortedSet, int n3) {
        int n4 = sortedSet.size();
        long l2 = n2 + 12 * n4 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n4);
        for (Object e2 : sortedSet) {
            TIFFField tIFFField = (TIFFField)e2;
            int n5 = tIFFField.getTag();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getType();
            this.writeUnsignedShort(n6);
            int n7 = tIFFField.getCount();
            int n8 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n6 == 2 ? (long)n8 : (long)n7);
            if (n8 > 4) {
                this.writeLong(l2);
                l2 += (long)n8;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n3);
        for (Object e2 : arrayList) {
            this.writeValues((TIFFField)e2);
        }
    }

    private static int getValueSize(TIFFField tIFFField) {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        int n4 = 0;
        if (n2 == 2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte[] byArray = tIFFField.getAsString(i2).getBytes("UTF-8");
                n4 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n4;
            }
        } else {
            n4 = n3 * SIZE_OF_TYPE[n2];
        }
        return n4;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        switch (n2) {
            case 1: {
                int n4;
                byte[] byArray = tIFFField.getAsBytes();
                if (n3 > 4) {
                    n3 = 4;
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    this.output.write(byArray[n4]);
                }
                for (n4 = 0; n4 < 4 - n3; ++n4) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n5;
                char[] cArray = tIFFField.getAsChars();
                if (n3 > 2) {
                    n3 = 2;
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    this.writeUnsignedShort(cArray[n5]);
                }
                for (n5 = 0; n5 < 2 - n3; ++n5) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.writeLong(lArray[i2]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) {
        int n2 = tIFFField.getType();
        int n3 = tIFFField.getCount();
        switch (n2) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.output.write(byArray[i2]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.writeUnsignedShort(cArray[i3]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i4 = 0; i4 < n3; ++i4) {
                    this.writeUnsignedShort(sArray[i4]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i5 = 0; i5 < n3; ++i5) {
                    this.writeLong(lArray[i5]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i6 = 0; i6 < n3; ++i6) {
                    int n4 = Float.floatToIntBits(fArray[i6]);
                    this.writeLong(n4);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i7 = 0; i7 < n3; ++i7) {
                    long l2 = Double.doubleToLongBits(dArray[i7]);
                    this.writeLong(l2 >>> 32);
                    this.writeLong(l2 & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i8 = 0; i8 < n3; ++i8) {
                    this.writeLong(lArray[i8][0]);
                    this.writeLong(lArray[i8][1]);
                }
                break;
            }
            case 2: {
                for (int i9 = 0; i9 < n3; ++i9) {
                    byte[] byArray = tIFFField.getAsString(i9).getBytes("UTF-8");
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n2) {
        this.output.write((n2 & 0xFF00) >>> 8);
        this.output.write(n2 & 0xFF);
    }

    private void writeLong(long l2) {
        this.output.write((int)((l2 & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l2 & 0xFF0000L) >>> 16));
        this.output.write((int)((l2 & 0xFF00L) >>> 8));
        this.output.write((int)(l2 & 0xFFL));
    }

    private static int compressPackBits(byte[] byArray, int n2, long l2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, (int)l2, byArray2, n4);
            n3 = (int)((long)n3 + l2);
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = n2 + n3 - 1;
        int n6 = n5 - 1;
        while (n2 <= n5) {
            int n7;
            byte by2 = byArray[n2];
            for (n7 = 1; n7 < 127 && n2 < n5 && byArray[n2] == byArray[n2 + 1]; ++n7, ++n2) {
            }
            if (n7 > 1) {
                ++n2;
                byArray2[n4++] = (byte)(-(n7 - 1));
                byArray2[n4++] = by2;
            }
            int n8 = n4;
            for (n7 = 0; n7 < 128 && (n2 < n5 && byArray[n2] != byArray[n2 + 1] || n2 < n6 && byArray[n2] != byArray[n2 + 2]); ++n7) {
                byArray2[++n4] = byArray[n2++];
            }
            if (n7 > 0) {
                byArray2[n8] = (byte)(n7 - 1);
                ++n4;
            }
            if (n2 != n5) continue;
            if (n7 > 0 && n7 < 128) {
                int n9 = n8;
                byArray2[n9] = (byte)(byArray2[n9] + 1);
                byArray2[n4++] = byArray[n2++];
                continue;
            }
            byArray2[n4++] = 0;
            byArray2[n4++] = byArray[n2++];
        }
        return n4;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n2 = deflater.deflate(byArray2);
        deflater.reset();
        return n2;
    }

    private static class Context {
        private RenderedImage nextImage;
        private int ifdOffset = 8;

        private Context() {
        }
    }
}

