/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDecodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDirectory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFFaxDecoder;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.tiff.TIFFLZWDecoder;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;
import org.apache.xmlgraphics.image.rendered.AbstractRed;
import org.apache.xmlgraphics.image.rendered.CachableRed;

public class TIFFImage
extends AbstractRed {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    Inflater inflater;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero;
    int dataType;
    boolean decodePaletteAsShorts;
    boolean tiled;
    private TIFFFaxDecoder decoder;
    private TIFFLZWDecoder lzwDecoder;

    private void inflate(byte[] byArray, byte[] byArray2) {
        this.inflater.setInput(byArray);
        try {
            this.inflater.inflate(byArray2);
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage17") + ": " + dataFormatException.getMessage());
        }
        this.inflater.reset();
    }

    private static SampleModel createPixelInterleavedSampleModel(int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n5];
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = i2;
        }
        return new PixelInterleavedSampleModel(n2, n3, n4, n5, n3 * n5, nArray);
    }

    private long[] getFieldAsLongs(TIFFField tIFFField) {
        long[] lArray = null;
        if (tIFFField.getType() == 3) {
            char[] cArray = tIFFField.getAsChars();
            lArray = new long[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                lArray[i2] = cArray[i2] & 0xFFFF;
            }
        } else if (tIFFField.getType() == 4) {
            lArray = tIFFField.getAsLongs();
        } else {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage18") + ": " + tIFFField.getType());
        }
        return lArray;
    }

    public TIFFImage(SeekableStream seekableStream, TIFFDecodeParam tIFFDecodeParam, int n2) {
        Object object;
        Object object2;
        TIFFField tIFFField;
        int n3;
        int n4;
        int n5;
        int n6;
        char[] cArray;
        char[] cArray2;
        this.stream = seekableStream;
        if (tIFFDecodeParam == null) {
            tIFFDecodeParam = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = tIFFDecodeParam.getDecodePaletteAsShorts();
        TIFFDirectory tIFFDirectory = tIFFDecodeParam.getIFDOffset() == null ? new TIFFDirectory(seekableStream, n2) : new TIFFDirectory(seekableStream, tIFFDecodeParam.getIFDOffset(), n2);
        TIFFField tIFFField2 = tIFFDirectory.getField(277);
        int n7 = tIFFField2 == null ? 1 : (int)tIFFField2.getAsLong(0);
        TIFFField tIFFField3 = tIFFDirectory.getField(284);
        if (tIFFField3 == null) {
            char[] cArray3 = new char[1];
            cArray2 = cArray3;
            cArray3[0] = '\u0001';
        } else {
            cArray2 = cArray = tIFFField3.getAsChars();
        }
        if (cArray[0] != '\u0001' && n7 != 1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage0"));
        }
        TIFFField tIFFField4 = tIFFDirectory.getField(258);
        char[] cArray4 = null;
        if (tIFFField4 != null) {
            cArray4 = tIFFField4.getAsChars();
        } else {
            cArray4 = new char[]{'\u0001'};
            for (int i2 = 1; i2 < cArray4.length; ++i2) {
                if (cArray4[i2] == cArray4[0]) continue;
                throw new RuntimeException(PropertyUtil.getString("TIFFImage1"));
            }
        }
        this.sampleSize = cArray4[0];
        TIFFField tIFFField5 = tIFFDirectory.getField(339);
        char[] cArray5 = null;
        if (tIFFField5 != null) {
            cArray5 = tIFFField5.getAsChars();
            for (n6 = 1; n6 < cArray5.length; ++n6) {
                if (cArray5[n6] == cArray5[0]) continue;
                throw new RuntimeException(PropertyUtil.getString("TIFFImage2"));
            }
        } else {
            cArray5 = new char[]{'\u0001'};
        }
        n6 = 0;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = 0;
                n6 = 1;
                break;
            }
            case 16: {
                if (cArray5[0] == '\u0003') break;
                this.dataType = cArray5[0] == '\u0002' ? 2 : 1;
                n6 = 1;
                break;
            }
            case 32: {
                if (cArray5[0] == '\u0003') {
                    n6 = 0;
                    break;
                }
                this.dataType = 3;
                n6 = 1;
            }
        }
        if (n6 == 0) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage3"));
        }
        TIFFField tIFFField6 = tIFFDirectory.getField(259);
        this.compression = tIFFField6 == null ? 1 : tIFFField6.getAsInt(0);
        TIFFField tIFFField7 = tIFFDirectory.getField(262);
        int n8 = tIFFField7 == null ? 0 : tIFFField7.getAsInt(0);
        this.imageType = -1;
        switch (n8) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && n7 == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && n7 == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (n7 == 1) {
                    this.imageType = 2;
                    break;
                }
                if (n7 == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (n7 == 3) {
                    this.imageType = 5;
                    break;
                }
                if (n7 == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (n7 != true || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || n7 != true) break;
                this.imageType = 0;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage4") + ": " + this.imageType);
        }
        Rectangle rectangle = new Rectangle(0, 0, (int)tIFFDirectory.getFieldAsLong(256), (int)tIFFDirectory.getFieldAsLong(257));
        this.numBands = n7;
        TIFFField tIFFField8 = tIFFDirectory.getField(338);
        int n9 = n5 = tIFFField8 == null ? 0 : (int)tIFFField8.getAsLong(0);
        if (tIFFDirectory.getField(324) != null) {
            this.tiled = true;
            n4 = (int)tIFFDirectory.getFieldAsLong(322);
            n3 = (int)tIFFDirectory.getFieldAsLong(323);
            this.tileOffsets = tIFFDirectory.getField(324).getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(tIFFDirectory.getField(325));
        } else {
            this.tiled = false;
            n4 = tIFFDirectory.getField(322) != null ? (int)tIFFDirectory.getFieldAsLong(322) : rectangle.width;
            tIFFField = tIFFDirectory.getField(278);
            if (tIFFField == null) {
                n3 = tIFFDirectory.getField(323) != null ? (int)tIFFDirectory.getFieldAsLong(323) : rectangle.height;
            } else {
                long l2 = tIFFField.getAsLong(0);
                long l3 = 1L;
                n3 = l2 == (l3 = (l3 << 32) - 1L) ? rectangle.height : (int)l2;
            }
            object2 = tIFFDirectory.getField(273);
            if (object2 == null) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage5"));
            }
            this.tileOffsets = this.getFieldAsLongs((TIFFField)object2);
            object = tIFFDirectory.getField(279);
            if (object == null) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage6"));
            }
            this.tileByteCounts = this.getFieldAsLongs((TIFFField)object);
        }
        this.tilesX = (rectangle.width + n4 - 1) / n4;
        this.tilesY = (rectangle.height + n3 - 1) / n3;
        this.tileSize = n4 * n3 * this.numBands;
        this.isBigEndian = tIFFDirectory.isBigEndian();
        tIFFField = tIFFDirectory.getField(266);
        this.fillOrder = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage7"));
                }
                if (this.compression == 3) {
                    object2 = tIFFDirectory.getField(292);
                    this.tiffT4Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    object2 = tIFFDirectory.getField(293);
                    this.tiffT6Options = object2 != null ? ((TIFFField)object2).getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, n4, n3);
                break;
            }
            case 5: {
                object2 = tIFFDirectory.getField(317);
                if (object2 == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = ((TIFFField)object2).getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage8"));
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage9"));
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(n4, this.predictor, n7);
                break;
            }
            case 6: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage15"));
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage10") + ": " + this.compression);
            }
        }
        object2 = null;
        object = null;
        switch (this.imageType) {
            case 0: 
            case 1: {
                object = new MultiPixelPackedSampleModel(this.dataType, n4, n3, this.sampleSize);
                if (this.imageType == 0) {
                    byte[] byArray = new byte[]{(byte)(this.isWhiteZero ? 255 : 0), (byte)(this.isWhiteZero ? 0 : 255)};
                    object2 = new IndexColorModel(1, 2, byArray, byArray, byArray);
                    break;
                }
                byte[] byArray = new byte[16];
                if (this.isWhiteZero) {
                    for (int i3 = 0; i3 < byArray.length; ++i3) {
                        byArray[i3] = (byte)(255 - 16 * i3);
                    }
                } else {
                    for (int i4 = 0; i4 < byArray.length; ++i4) {
                        byArray[i4] = (byte)(16 * i4);
                    }
                }
                object2 = new IndexColorModel(4, 16, byArray, byArray, byArray);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                int n10;
                int[] nArray = new int[this.numBands];
                for (n10 = 0; n10 < this.numBands; ++n10) {
                    nArray[n10] = this.numBands - 1 - n10;
                }
                object = new PixelInterleavedSampleModel(this.dataType, n4, n3, this.numBands, this.numBands * n4, nArray);
                if (this.imageType == 2) {
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                if (this.imageType == 5) {
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{this.sampleSize, this.sampleSize, this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                n10 = 1;
                if (n5 == 1) {
                    n10 = 3;
                } else if (n5 == 2) {
                    n10 = 2;
                }
                object2 = this.createAlphaComponentColorModel(this.dataType, this.numBands, n5 == 1, n10);
                break;
            }
            case 7: 
            case 8: {
                int[] nArray = new int[this.numBands];
                for (int i5 = 0; i5 < this.numBands; ++i5) {
                    nArray[i5] = i5;
                }
                object = new PixelInterleavedSampleModel(this.dataType, n4, n3, this.numBands, this.numBands * n4, nArray);
                object2 = null;
                break;
            }
            case 4: {
                TIFFField tIFFField9 = tIFFDirectory.getField(320);
                if (tIFFField9 == null) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage11"));
                }
                this.colormap = tIFFField9.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    object = TIFFImage.createPixelInterleavedSampleModel(this.dataType, n4, n3, this.numBands);
                    object2 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{16, 16, 16}, false, false, 1, this.dataType);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    object = new MultiPixelPackedSampleModel(0, n4, n3, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    object = TIFFImage.createPixelInterleavedSampleModel(0, n4, n3, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    object = TIFFImage.createPixelInterleavedSampleModel(1, n4, n3, this.numBands);
                }
                int n11 = this.colormap.length / 3;
                byte[] byArray = new byte[n11];
                byte[] byArray2 = new byte[n11];
                byte[] byArray3 = new byte[n11];
                int n12 = n11;
                int n13 = n11 * 2;
                if (this.dataType == 2) {
                    for (int i6 = 0; i6 < n11; ++i6) {
                        byArray[i6] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[i6]);
                        byArray2[i6] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n12 + i6]);
                        byArray3[i6] = tIFFDecodeParam.decodeSigned16BitsTo8Bits((short)this.colormap[n13 + i6]);
                    }
                } else {
                    for (int i7 = 0; i7 < n11; ++i7) {
                        byArray[i7] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[i7] & 0xFFFF);
                        byArray2[i7] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n12 + i7] & 0xFFFF);
                        byArray3[i7] = tIFFDecodeParam.decode16BitsTo8Bits(this.colormap[n13 + i7] & 0xFFFF);
                    }
                }
                object2 = new IndexColorModel(this.sampleSize, n11, byArray, byArray2, byArray3);
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage4") + ": " + this.imageType);
            }
        }
        HashMap<String, TIFFDirectory> hashMap = new HashMap<String, TIFFDirectory>();
        hashMap.put("tiff_directory", tIFFDirectory);
        this.init((CachableRed)null, rectangle, (ColorModel)object2, (SampleModel)object, 0, 0, hashMap);
    }

    public TIFFDirectory getPrivateIFD(long l2) {
        return new TIFFDirectory(this.stream, l2, 0);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Raster getTile(int n2, int n3) {
        byte[] byArray;
        if (n2 < 0 || n2 >= this.tilesX || n3 < 0 || n3 >= this.tilesY) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFImage12"));
        }
        byte[] byArray2 = null;
        short[] sArray = null;
        int[] nArray = null;
        SampleModel sampleModel = this.getSampleModel();
        WritableRaster writableRaster = this.makeTile(n2, n3);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n4 = sampleModel.getDataType();
        if (n4 == 0) {
            byArray2 = ((DataBufferByte)dataBuffer).getData();
        } else if (n4 == 1) {
            sArray = ((DataBufferUShort)dataBuffer).getData();
        } else if (n4 == 2) {
            sArray = ((DataBufferShort)dataBuffer).getData();
        } else if (n4 == 3) {
            nArray = ((DataBufferInt)dataBuffer).getData();
        }
        long l2 = 0L;
        try {
            l2 = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[n3 * this.tilesX + n2]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        int n5 = (int)this.tileByteCounts[n3 * this.tilesX + n2];
        Rectangle rectangle = !this.tiled ? writableRaster.getBounds() : new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), this.tileWidth, this.tileHeight);
        int n6 = rectangle.width * rectangle.height * this.numBands;
        Object object = byArray = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[n5] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n7 = rectangle.width % 8 == 0 ? rectangle.width / 8 * rectangle.height : (rectangle.width / 8 + 1) * rectangle.height;
                    this.decodePackbits(byArray, n7, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 2) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decode1D(byArray2, byArray, 0, rectangle.height);
                } else if (this.compression == 3) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decode2D(byArray2, byArray, 0, rectangle.height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decoder.decodeT6(byArray2, byArray, 0, rectangle.height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
            }
        }
        if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] sArray2 = null;
                    int n8 = n6 / 3;
                    int n9 = n8 * 2;
                    try {
                        byte[] byArray3;
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.decodePackbits(byArray, n9, byArray3);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.lzwDecoder.decode(byArray, byArray3, rectangle.height);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray3 = new byte[n9];
                            this.inflate(byArray, byArray3);
                            sArray2 = new short[n8];
                            this.interpretBytesAsShorts(byArray3, sArray2, n8);
                        } else if (this.compression == 1) {
                            sArray2 = new short[n5 / 2];
                            this.readShorts(n5 / 2, sArray2);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                    }
                    if (n4 == 1) {
                        int n10 = 0;
                        int n11 = this.colormap.length / 3;
                        int n12 = n11 * 2;
                        for (int i2 = 0; i2 < n8; ++i2) {
                            int n13 = sArray2[i2] & 0xFFFF;
                            char c2 = this.colormap[n13 + n12];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            c2 = this.colormap[n13 + n11];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                            c2 = this.colormap[n13];
                            sArray[n10++] = (short)(c2 & 0xFFFF);
                        }
                        return writableRaster;
                    } else {
                        if (n4 != 2) return writableRaster;
                        int n14 = 0;
                        int n15 = this.colormap.length / 3;
                        int n16 = n15 * 2;
                        for (int i3 = 0; i3 < n8; ++i3) {
                            int n17 = sArray2[i3] & 0xFFFF;
                            char c3 = this.colormap[n17 + n16];
                            sArray[n14++] = (short)c3;
                            c3 = this.colormap[n17 + n15];
                            sArray[n14++] = (short)c3;
                            c3 = this.colormap[n17];
                            sArray[n14++] = (short)c3;
                        }
                    }
                    return writableRaster;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        int n18 = n6 * 2;
                        byte[] byArray4 = new byte[n18];
                        this.decodePackbits(byArray, n18, byArray4);
                        this.interpretBytesAsShorts(byArray4, sArray, n6);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray5 = new byte[n6 * 2];
                        this.lzwDecoder.decode(byArray, byArray5, rectangle.height);
                        this.interpretBytesAsShorts(byArray5, sArray, n6);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        byte[] byArray6 = new byte[n6 * 2];
                        this.inflate(byArray, byArray6);
                        this.interpretBytesAsShorts(byArray6, sArray, n6);
                    } else if (this.compression == 1) {
                        this.readShorts(n5 / 2, sArray);
                    }
                    this.stream.seek(l2);
                    return writableRaster;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                }
            }
            if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    byte[] byArray7 = null;
                    int n19 = n6 / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n19];
                            this.decodePackbits(byArray, n19, byArray7);
                        } else if (this.compression == 5) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n19];
                            this.lzwDecoder.decode(byArray, byArray7, rectangle.height);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(byArray, 0, n5);
                            byArray7 = new byte[n19];
                            this.inflate(byArray, byArray7);
                        } else {
                            if (this.compression != 1) throw new RuntimeException(PropertyUtil.getString("IFFImage10") + ": " + this.compression);
                            byArray7 = new byte[n5];
                            this.stream.readFully(byArray7, 0, n5);
                        }
                        this.stream.seek(l2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                    }
                    int n20 = 0;
                    int n21 = this.colormap.length / 3;
                    int n22 = n21 * 2;
                    for (int i4 = 0; i4 < n19; ++i4) {
                        int n23 = byArray7[i4] & 0xFF;
                        char c4 = this.colormap[n23 + n22];
                        sArray[n20++] = (short)(c4 & 0xFFFF);
                        c4 = this.colormap[n23 + n21];
                        sArray[n20++] = (short)(c4 & 0xFFFF);
                        c4 = this.colormap[n23];
                        sArray[n20++] = (short)(c4 & 0xFFFF);
                    }
                    return writableRaster;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(byArray, 0, n5);
                        this.decodePackbits(byArray, n6, byArray2);
                    } else if (this.compression == 5) {
                        this.stream.readFully(byArray, 0, n5);
                        this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(byArray, 0, n5);
                        this.inflate(byArray, byArray2);
                    } else {
                        if (this.compression != 1) throw new RuntimeException(PropertyUtil.getString("TIFFImage10") + ": " + this.compression);
                        this.stream.readFully(byArray2, 0, n5);
                    }
                    this.stream.seek(l2);
                    return writableRaster;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                }
            }
            if (this.sampleSize != 4) return writableRaster;
            int n24 = rectangle.width % 2 == 0 ? 0 : 1;
            int n25 = (rectangle.width / 2 + n24) * rectangle.height;
            if (this.decodePaletteAsShorts) {
                int n26;
                int n27;
                byte[] byArray8 = null;
                try {
                    this.stream.readFully(byArray, 0, n5);
                    this.stream.seek(l2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
                }
                if (this.compression == 32773) {
                    byArray8 = new byte[n25];
                    this.decodePackbits(byArray, n25, byArray8);
                } else if (this.compression == 5) {
                    byArray8 = new byte[n25];
                    this.lzwDecoder.decode(byArray, byArray8, rectangle.height);
                } else if (this.compression == 32946) {
                    byArray8 = new byte[n25];
                    this.inflate(byArray, byArray8);
                } else if (this.compression == 1) {
                    byArray8 = byArray;
                }
                int n28 = n6 / 3;
                byArray = new byte[n28];
                int n29 = 0;
                int n30 = 0;
                for (n27 = 0; n27 < rectangle.height; ++n27) {
                    for (n26 = 0; n26 < rectangle.width / 2; ++n26) {
                        byArray[n30++] = (byte)((byArray8[n29] & 0xF0) >> 4);
                        byArray[n30++] = (byte)(byArray8[n29++] & 0xF);
                    }
                    if (n24 != 1) continue;
                    byArray[n30++] = (byte)((byArray8[n29++] & 0xF0) >> 4);
                }
                n27 = this.colormap.length / 3;
                n26 = n27 * 2;
                int n31 = 0;
                for (int i5 = 0; i5 < n28; ++i5) {
                    int n32 = byArray[i5] & 0xFF;
                    char c5 = this.colormap[n32 + n26];
                    sArray[n31++] = (short)(c5 & 0xFFFF);
                    c5 = this.colormap[n32 + n27];
                    sArray[n31++] = (short)(c5 & 0xFFFF);
                    c5 = this.colormap[n32];
                    sArray[n31++] = (short)(c5 & 0xFFFF);
                }
                return writableRaster;
            }
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decodePackbits(byArray, n25, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
            }
        }
        if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n33 = rectangle.width % 8 == 0 ? rectangle.width / 2 * rectangle.height : (rectangle.width / 2 + 1) * rectangle.height;
                    this.decodePackbits(byArray, n33, byArray2);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                } else {
                    this.stream.readFully(byArray2, 0, n5);
                }
                this.stream.seek(l2);
                return writableRaster;
            }
            catch (IOException iOException) {
                throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
            }
        }
        try {
            byte[] byArray9;
            if (this.sampleSize == 8) {
                if (this.compression == 1) {
                    this.stream.readFully(byArray2, 0, n5);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    this.lzwDecoder.decode(byArray, byArray2, rectangle.height);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    this.decodePackbits(byArray, n6, byArray2);
                } else {
                    if (this.compression != 32946) throw new RuntimeException(PropertyUtil.getString("TIFFImage10") + ": " + this.compression);
                    this.stream.readFully(byArray, 0, n5);
                    this.inflate(byArray, byArray2);
                }
            } else if (this.sampleSize == 16) {
                if (this.compression == 1) {
                    this.readShorts(n5 / 2, sArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray10 = new byte[n6 * 2];
                    this.lzwDecoder.decode(byArray, byArray10, rectangle.height);
                    this.interpretBytesAsShorts(byArray10, sArray, n6);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n34 = n6 * 2;
                    byArray9 = new byte[n34];
                    this.decodePackbits(byArray, n34, byArray9);
                    this.interpretBytesAsShorts(byArray9, sArray, n6);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray11 = new byte[n6 * 2];
                    this.inflate(byArray, byArray11);
                    this.interpretBytesAsShorts(byArray11, sArray, n6);
                }
            } else if (this.sampleSize == 32 && n4 == 3) {
                if (this.compression == 1) {
                    this.readInts(n5 / 4, nArray);
                } else if (this.compression == 5) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray12 = new byte[n6 * 4];
                    this.lzwDecoder.decode(byArray, byArray12, rectangle.height);
                    this.interpretBytesAsInts(byArray12, nArray, n6);
                } else if (this.compression == 32773) {
                    this.stream.readFully(byArray, 0, n5);
                    int n35 = n6 * 4;
                    byArray9 = new byte[n35];
                    this.decodePackbits(byArray, n35, byArray9);
                    this.interpretBytesAsInts(byArray9, nArray, n6);
                } else if (this.compression == 32946) {
                    this.stream.readFully(byArray, 0, n5);
                    byte[] byArray13 = new byte[n6 * 4];
                    this.inflate(byArray, byArray13);
                    this.interpretBytesAsInts(byArray13, nArray, n6);
                }
            }
            this.stream.seek(l2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        switch (this.imageType) {
            case 2: 
            case 3: {
                if (!this.isWhiteZero) return writableRaster;
                if (n4 == 0 && !(this.getColorModel() instanceof IndexColorModel)) {
                    for (int i6 = 0; i6 < byArray2.length; i6 += this.numBands) {
                        byArray2[i6] = (byte)(255 - byArray2[i6]);
                    }
                    return writableRaster;
                } else if (n4 == 1) {
                    int n36 = 65535;
                    for (int i7 = 0; i7 < sArray.length; i7 += this.numBands) {
                        sArray[i7] = (short)(n36 - sArray[i7]);
                    }
                    return writableRaster;
                } else if (n4 == 2) {
                    for (int i8 = 0; i8 < sArray.length; i8 += this.numBands) {
                        sArray[i8] = ~sArray[i8];
                    }
                    return writableRaster;
                } else {
                    if (n4 != 3) return writableRaster;
                    long l3 = 0xFFFFFFFFL;
                    for (int i9 = 0; i9 < nArray.length; i9 += this.numBands) {
                        nArray[i9] = (int)(l3 - (long)nArray[i9]);
                    }
                }
                return writableRaster;
            }
            case 5: {
                if (this.sampleSize == 8 && this.compression != 7) {
                    for (int i10 = 0; i10 < n6; i10 += 3) {
                        byte by2 = byArray2[i10];
                        byArray2[i10] = byArray2[i10 + 2];
                        byArray2[i10 + 2] = by2;
                    }
                    return writableRaster;
                } else if (this.sampleSize == 16) {
                    for (int i11 = 0; i11 < n6; i11 += 3) {
                        short s2 = sArray[i11];
                        sArray[i11] = sArray[i11 + 2];
                        sArray[i11 + 2] = s2;
                    }
                    return writableRaster;
                } else {
                    if (this.sampleSize != 32 || n4 != 3) return writableRaster;
                    for (int i12 = 0; i12 < n6; i12 += 3) {
                        int n37 = nArray[i12];
                        nArray[i12] = nArray[i12 + 2];
                        nArray[i12 + 2] = n37;
                    }
                }
                return writableRaster;
            }
            case 6: {
                if (this.sampleSize == 8) {
                    for (int i13 = 0; i13 < n6; i13 += 4) {
                        byte by3 = byArray2[i13];
                        byArray2[i13] = byArray2[i13 + 3];
                        byArray2[i13 + 3] = by3;
                        by3 = byArray2[i13 + 1];
                        byArray2[i13 + 1] = byArray2[i13 + 2];
                        byArray2[i13 + 2] = by3;
                    }
                    return writableRaster;
                } else if (this.sampleSize == 16) {
                    for (int i14 = 0; i14 < n6; i14 += 4) {
                        short s3 = sArray[i14];
                        sArray[i14] = sArray[i14 + 3];
                        sArray[i14 + 3] = s3;
                        s3 = sArray[i14 + 1];
                        sArray[i14 + 1] = sArray[i14 + 2];
                        sArray[i14 + 2] = s3;
                    }
                    return writableRaster;
                } else {
                    if (this.sampleSize != 32 || n4 != 3) return writableRaster;
                    for (int i15 = 0; i15 < n6; i15 += 4) {
                        int n38 = nArray[i15];
                        nArray[i15] = nArray[i15 + 3];
                        nArray[i15 + 3] = n38;
                        n38 = nArray[i15 + 1];
                        nArray[i15 + 1] = nArray[i15 + 2];
                        nArray[i15 + 2] = n38;
                    }
                }
                return writableRaster;
            }
            case 7: {
                int n39 = this.chromaSubH * this.chromaSubV;
                int n40 = rectangle.width / this.chromaSubH;
                int n41 = rectangle.height / this.chromaSubV;
                byte[] byArray14 = new byte[n40 * n41 * (n39 + 2)];
                System.arraycopy(byArray2, 0, byArray14, 0, byArray14.length);
                int n42 = n39 * 3;
                int[] nArray2 = new int[n42];
                int n43 = 0;
                int n44 = n39;
                int n45 = n44 + 1;
                int n46 = rectangle.y;
                for (int i16 = 0; i16 < n41; ++i16) {
                    int n47 = rectangle.x;
                    for (int i17 = 0; i17 < n40; ++i17) {
                        int n48 = byArray14[n43 + n44];
                        int n49 = byArray14[n43 + n45];
                        int n50 = 0;
                        while (n50 < n42) {
                            nArray2[n50++] = byArray14[n43++];
                            nArray2[n50++] = n48;
                            nArray2[n50++] = n49;
                        }
                        n43 += 2;
                        writableRaster.setPixels(n47, n46, this.chromaSubH, this.chromaSubV, nArray2);
                        n47 += this.chromaSubH;
                    }
                    n46 += this.chromaSubV;
                }
                return writableRaster;
            }
        }
        return writableRaster;
    }

    private void readShorts(int n2, short[] sArray) {
        int n3 = 2 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        this.interpretBytesAsShorts(byArray, sArray, n2);
    }

    private void readInts(int n2, int[] nArray) {
        int n3 = 4 * n2;
        byte[] byArray = new byte[n3];
        try {
            this.stream.readFully(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage13") + ": " + iOException.getMessage());
        }
        this.interpretBytesAsInts(byArray, nArray, n2);
    }

    private void interpretBytesAsShorts(byte[] byArray, short[] sArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = byArray[n3++] & 0xFF;
                int n5 = byArray[n3++] & 0xFF;
                sArray[i2] = (short)((n4 << 8) + n5);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = byArray[n3++] & 0xFF;
                int n7 = byArray[n3++] & 0xFF;
                sArray[i3] = (short)((n7 << 8) + n6);
            }
        }
    }

    private void interpretBytesAsInts(byte[] byArray, int[] nArray, int n2) {
        int n3 = 0;
        if (this.isBigEndian) {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private byte[] decodePackbits(byte[] byArray, int n2, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[n2];
        }
        int n3 = 0;
        int n4 = 0;
        try {
            block2: while (n4 < n2) {
                int n5;
                byte by2;
                if ((by2 = byArray[n3++]) >= 0 && by2 <= 127) {
                    n5 = 0;
                    while (true) {
                        if (n5 >= by2 + 1) continue block2;
                        byArray2[n4++] = byArray[n3++];
                        ++n5;
                    }
                }
                if (by2 <= -1 && by2 >= -127) {
                    byte by3 = byArray[n3++];
                    n5 = 0;
                    while (true) {
                        if (n5 >= -by2 + 1) continue block2;
                        byArray2[n4++] = by3;
                        ++n5;
                    }
                }
                ++n3;
            }
            return byArray2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImage14") + ": " + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    private ComponentColorModel createAlphaComponentColorModel(int n2, int n3, boolean bl2, int n4) {
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        ColorSpace colorSpace = null;
        switch (n3) {
            case 2: {
                colorSpace = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                colorSpace = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException(PropertyUtil.getString("TIFFImage19") + ": " + n3);
            }
        }
        int n5 = 0;
        switch (n2) {
            case 0: {
                n5 = 8;
                break;
            }
            case 1: 
            case 2: {
                n5 = 16;
                break;
            }
            case 3: {
                n5 = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException(PropertyUtil.getString("TIFFImage20") + ": " + n2);
            }
        }
        nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = n5;
        }
        componentColorModel = new ComponentColorModel(colorSpace, nArray, true, bl2, n4, n2);
        return componentColorModel;
    }
}

