/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.util.Iterator;
import org.apache.xmlgraphics.image.codec.tiff.CompressionValue;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;

public class TIFFEncodeParam
implements ImageEncodeParam {
    private static final long serialVersionUID = 2471949735040024055L;
    private CompressionValue compression = CompressionValue.NONE;
    private boolean writeTiled;
    private int tileWidth;
    private int tileHeight;
    private Iterator extraImages;
    private TIFFField[] extraFields;
    private boolean convertJPEGRGBToYCbCr = true;
    private int deflateLevel = -1;

    public CompressionValue getCompression() {
        return this.compression;
    }

    public void setCompression(CompressionValue compressionValue) {
        switch (compressionValue) {
            case NONE: 
            case PACKBITS: 
            case DEFLATE: {
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFEncodeParam0"));
            }
        }
        this.compression = compressionValue;
    }

    public boolean getWriteTiled() {
        return this.writeTiled;
    }

    public void setWriteTiled(boolean bl2) {
        this.writeTiled = bl2;
    }

    public void setTileSize(int n2, int n3) {
        this.tileWidth = n2;
        this.tileHeight = n3;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public synchronized void setExtraImages(Iterator iterator) {
        this.extraImages = iterator;
    }

    public synchronized Iterator getExtraImages() {
        return this.extraImages;
    }

    public void setDeflateLevel(int n2) {
        if (n2 != -1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFEncodeParam1"));
        }
        this.deflateLevel = n2;
    }

    public int getDeflateLevel() {
        return this.deflateLevel;
    }

    public void setJPEGCompressRGBToYCbCr(boolean bl2) {
        this.convertJPEGRGBToYCbCr = bl2;
    }

    public boolean getJPEGCompressRGBToYCbCr() {
        return this.convertJPEGRGBToYCbCr;
    }

    public void setExtraFields(TIFFField[] tIFFFieldArray) {
        this.extraFields = tIFFFieldArray;
    }

    public TIFFField[] getExtraFields() {
        if (this.extraFields == null) {
            return new TIFFField[0];
        }
        return this.extraFields;
    }
}

