/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import org.apache.xmlgraphics.image.codec.tiff.ExtraSamplesType;
import org.apache.xmlgraphics.image.codec.tiff.ImageType;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;

final class ImageInfo {
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private final int numExtraSamples;
    private final ExtraSamplesType extraSampleType;
    private final ImageType imageType;
    private final int colormapSize;
    private final char[] colormap;
    private final int tileWidth;
    private final int tileHeight;
    private final int numTiles;
    private final long bytesPerRow;
    private final long bytesPerTile;

    private ImageInfo(ImageInfoBuilder imageInfoBuilder) {
        this.numExtraSamples = imageInfoBuilder.numExtraSamples;
        this.extraSampleType = imageInfoBuilder.extraSampleType;
        this.imageType = imageInfoBuilder.imageType;
        this.colormapSize = imageInfoBuilder.colormapSize;
        this.colormap = ImageInfo.copyColormap(imageInfoBuilder.colormap);
        this.tileWidth = imageInfoBuilder.tileWidth;
        this.tileHeight = imageInfoBuilder.tileHeight;
        this.numTiles = imageInfoBuilder.numTiles;
        this.bytesPerRow = imageInfoBuilder.bytesPerRow;
        this.bytesPerTile = imageInfoBuilder.bytesPerTile;
    }

    private static char[] copyColormap(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    private static int getNumberOfExtraSamplesForColorSpace(ColorSpace colorSpace, ImageType imageType, int n2) {
        if (imageType == ImageType.GENERIC) {
            return n2 - 1;
        }
        if (n2 > 1) {
            return n2 - colorSpace.getNumComponents();
        }
        return 0;
    }

    private static char[] createColormap(int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n3 = 0;
        int n4 = n2;
        int n5 = 2 * n2;
        char[] cArray = new char[n2 * 3];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[n3++] = ImageInfo.convertColorToColormapChar(0xFF & byArray[i2]);
            cArray[n4++] = ImageInfo.convertColorToColormapChar(0xFF & byArray2[i2]);
            cArray[n5++] = ImageInfo.convertColorToColormapChar(0xFF & byArray3[i2]);
        }
        return cArray;
    }

    private static char convertColorToColormapChar(int n2) {
        return (char)(n2 << 8 | n2);
    }

    int getNumberOfExtraSamples() {
        return this.numExtraSamples;
    }

    ExtraSamplesType getExtraSamplesType() {
        return this.extraSampleType;
    }

    ImageType getType() {
        return this.imageType;
    }

    int getColormapSize() {
        return this.colormapSize;
    }

    char[] getColormap() {
        return ImageInfo.copyColormap(this.colormap);
    }

    int getTileWidth() {
        return this.tileWidth;
    }

    int getTileHeight() {
        return this.tileHeight;
    }

    int getNumTiles() {
        return this.numTiles;
    }

    long getBytesPerRow() {
        return this.bytesPerRow;
    }

    long getBytesPerTile() {
        return this.bytesPerTile;
    }

    static ImageInfo newInstance(RenderedImage renderedImage, int n2, int n3, ColorModel colorModel, TIFFEncodeParam tIFFEncodeParam) {
        int n4;
        Object object;
        ImageInfoBuilder imageInfoBuilder = new ImageInfoBuilder();
        if (colorModel instanceof IndexColorModel) {
            object = (IndexColorModel)colorModel;
            n4 = ((IndexColorModel)object).getMapSize();
            byte[] byArray = new byte[n4];
            ((IndexColorModel)object).getReds(byArray);
            byte[] byArray2 = new byte[n4];
            ((IndexColorModel)object).getGreens(byArray2);
            byte[] byArray3 = new byte[n4];
            ((IndexColorModel)object).getBlues(byArray3);
            imageInfoBuilder.imageType = ImageType.getTypeFromRGB(n4, byArray, byArray2, byArray3, n2, n3);
            if (imageInfoBuilder.imageType == ImageType.PALETTE) {
                ImageInfoBuilder.access$402(imageInfoBuilder, ImageInfo.createColormap(n4, byArray, byArray2, byArray3));
                imageInfoBuilder.colormapSize = n4 * 3;
            }
        } else if (colorModel == null) {
            if (n2 == 1 && n3 == 1) {
                imageInfoBuilder.imageType = ImageType.BILEVEL_BLACK_IS_ZERO;
            } else {
                imageInfoBuilder.imageType = ImageType.GENERIC;
                imageInfoBuilder.numExtraSamples = n3 > 1 ? n3 - 1 : 0;
            }
        } else {
            object = colorModel.getColorSpace();
            imageInfoBuilder.imageType = ImageType.getTypeFromColorSpace((ColorSpace)object, tIFFEncodeParam);
            imageInfoBuilder.numExtraSamples = ImageInfo.getNumberOfExtraSamplesForColorSpace((ColorSpace)object, imageInfoBuilder.imageType, n3);
            imageInfoBuilder.extraSampleType = ExtraSamplesType.getValue(colorModel, imageInfoBuilder.numExtraSamples);
        }
        int n5 = renderedImage.getWidth();
        n4 = renderedImage.getHeight();
        if (tIFFEncodeParam.getWriteTiled()) {
            imageInfoBuilder.tileWidth = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : n5;
            imageInfoBuilder.tileHeight = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : n4;
            imageInfoBuilder.numTiles = (n5 + imageInfoBuilder.tileWidth - 1) / imageInfoBuilder.tileWidth * ((n4 + imageInfoBuilder.tileHeight - 1) / imageInfoBuilder.tileHeight);
        } else {
            imageInfoBuilder.tileWidth = n5;
            imageInfoBuilder.tileHeight = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
            imageInfoBuilder.numTiles = (int)Math.ceil((double)n4 / (double)imageInfoBuilder.tileHeight);
        }
        imageInfoBuilder.setBytesPerRow(n2, n3).setBytesPerTile();
        return imageInfoBuilder.build();
    }

    private static final class ImageInfoBuilder {
        private ImageType imageType = ImageType.UNSUPPORTED;
        private int numExtraSamples;
        private char[] colormap;
        private int colormapSize;
        private ExtraSamplesType extraSampleType = ExtraSamplesType.UNSPECIFIED;
        private int tileWidth;
        private int tileHeight;
        private int numTiles;
        private long bytesPerRow;
        private long bytesPerTile;

        private ImageInfoBuilder() {
        }

        private ImageInfoBuilder setBytesPerRow(int n2, int n3) {
            this.bytesPerRow = (long)Math.ceil((double)n2 / 8.0 * (double)this.tileWidth * (double)n3);
            return this;
        }

        private ImageInfoBuilder setBytesPerTile() {
            this.bytesPerTile = this.bytesPerRow * (long)this.tileHeight;
            return this;
        }

        private ImageInfo build() {
            return new ImageInfo(this);
        }

        static /* synthetic */ char[] access$402(ImageInfoBuilder imageInfoBuilder, char[] cArray) {
            imageInfoBuilder.colormap = cArray;
            return cArray;
        }
    }
}

