/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.xmlgraphics.image.codec.png.ChunkStream;
import org.apache.xmlgraphics.image.codec.png.IDATOutputStream;
import org.apache.xmlgraphics.image.codec.png.PNGEncodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageEncoderImpl;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;

public class PNGImageEncoder
extends ImageEncoderImpl {
    private static final int PNG_COLOR_GRAY = 0;
    private static final int PNG_COLOR_RGB = 2;
    private static final int PNG_COLOR_PALETTE = 3;
    private static final int PNG_COLOR_GRAY_ALPHA = 4;
    private static final int PNG_COLOR_RGB_ALPHA = 6;
    private static final byte[] MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private PNGEncodeParam param;
    private RenderedImage image;
    private int width;
    private int height;
    private int bitDepth;
    private int bitShift;
    private int numBands;
    private int colorType;
    private int bpp;
    private boolean skipAlpha;
    private boolean compressGray;
    private boolean interlace;
    private byte[] redPalette;
    private byte[] greenPalette;
    private byte[] bluePalette;
    private byte[] alphaPalette;
    private DataOutputStream dataOutput;
    private byte[] prevRow;
    private byte[] currRow;
    private byte[][] filteredRows;
    private static final float[] SRGB_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};

    public PNGImageEncoder(OutputStream outputStream, PNGEncodeParam pNGEncodeParam) {
        super(outputStream, pNGEncodeParam);
        if (pNGEncodeParam != null) {
            this.param = pNGEncodeParam;
        }
        this.dataOutput = new DataOutputStream(outputStream);
    }

    private void writeMagic() {
        this.dataOutput.write(MAGIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIHDR() {
        ChunkStream chunkStream = new ChunkStream("IHDR");
        try {
            chunkStream.writeInt(this.width);
            chunkStream.writeInt(this.height);
            chunkStream.writeByte((byte)this.bitDepth);
            chunkStream.writeByte((byte)this.colorType);
            chunkStream.writeByte(0);
            chunkStream.writeByte(0);
            chunkStream.writeByte(this.interlace ? 1 : 0);
            chunkStream.writeToStream(this.dataOutput);
        }
        finally {
            chunkStream.close();
        }
    }

    private static int clamp(int n2, int n3) {
        return n2 > n3 ? n3 : n2;
    }

    private void encodePass(OutputStream outputStream, Raster raster, int n2, int n3, int n4, int n5) {
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = raster.getWidth();
        int n9 = raster.getHeight();
        int n10 = 8 / this.bitDepth;
        int n11 = n8 * this.numBands;
        int[] nArray = new int[n11];
        int n12 = (n11 - (n2 *= this.numBands) + (n4 *= this.numBands) - 1) / n4;
        int n13 = n12 * this.numBands;
        if (this.bitDepth < 8) {
            n13 = (n13 + n10 - 1) / n10;
        } else if (this.bitDepth == 16) {
            n13 *= 2;
        }
        if (n13 == 0) {
            return;
        }
        this.currRow = new byte[n13 + this.bpp];
        this.prevRow = new byte[n13 + this.bpp];
        this.filteredRows = new byte[5][n13 + this.bpp];
        int n14 = (1 << this.bitDepth) - 1;
        for (int i2 = n7 + n3; i2 < n7 + n9; i2 += n5) {
            int n15;
            int n16;
            int n17;
            raster.getPixels(n6, i2, n8, 1, nArray);
            if (this.compressGray) {
                n17 = 8 - this.bitDepth;
                n16 = 0;
                while (n16 < n8) {
                    int n18 = n16++;
                    nArray[n18] = nArray[n18] >> n17;
                }
            }
            n17 = this.bpp;
            n16 = 0;
            int n19 = 0;
            switch (this.bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int n20;
                    n15 = n10 - 1;
                    for (int i3 = n2; i3 < n11; i3 += n4) {
                        n20 = PNGImageEncoder.clamp(nArray[i3] >> this.bitShift, n14);
                        n19 = n19 << this.bitDepth | n20;
                        if (n16++ != n15) continue;
                        this.currRow[n17++] = (byte)n19;
                        n19 = 0;
                        n16 = 0;
                    }
                    if (n16 == 0) break;
                    this.currRow[n17++] = (byte)(n19 <<= (n10 - n16) * this.bitDepth);
                    break;
                }
                case 8: {
                    int n20;
                    for (int i4 = n2; i4 < n11; i4 += n4) {
                        for (n20 = 0; n20 < this.numBands; ++n20) {
                            this.currRow[n17++] = (byte)PNGImageEncoder.clamp(nArray[i4 + n20] >> this.bitShift, n14);
                        }
                    }
                    break;
                }
                case 16: {
                    int n20;
                    for (int i5 = n2; i5 < n11; i5 += n4) {
                        for (n20 = 0; n20 < this.numBands; ++n20) {
                            int n21 = PNGImageEncoder.clamp(nArray[i5 + n20] >> this.bitShift, n14);
                            this.currRow[n17++] = (byte)(n21 >> 8);
                            this.currRow[n17++] = (byte)(n21 & 0xFF);
                        }
                    }
                    break;
                }
            }
            n15 = this.param.filterRow(this.currRow, this.prevRow, this.filteredRows, n13, this.bpp);
            outputStream.write(n15);
            outputStream.write(this.filteredRows[n15], this.bpp, n13);
            byte[] byArray = this.currRow;
            this.currRow = this.prevRow;
            this.prevRow = byArray;
        }
    }

    private void writeIDAT() {
        IDATOutputStream iDATOutputStream = new IDATOutputStream(this.dataOutput, 8192);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)iDATOutputStream, new Deflater(9));
        Raster raster = this.image.getData(new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight()));
        if (this.skipAlpha) {
            int n2 = raster.getNumBands() - 1;
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = i2;
            }
            raster = raster.createChild(0, 0, raster.getWidth(), raster.getHeight(), 0, 0, nArray);
        }
        if (this.interlace) {
            this.encodePass(deflaterOutputStream, raster, 0, 0, 8, 8);
            this.encodePass(deflaterOutputStream, raster, 4, 0, 8, 8);
            this.encodePass(deflaterOutputStream, raster, 0, 4, 4, 8);
            this.encodePass(deflaterOutputStream, raster, 2, 0, 4, 4);
            this.encodePass(deflaterOutputStream, raster, 0, 2, 2, 4);
            this.encodePass(deflaterOutputStream, raster, 1, 0, 2, 2);
            this.encodePass(deflaterOutputStream, raster, 0, 1, 1, 2);
        } else {
            this.encodePass(deflaterOutputStream, raster, 0, 0, 1, 1);
        }
        deflaterOutputStream.finish();
        deflaterOutputStream.close();
        iDATOutputStream.flush();
        iDATOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIEND() {
        ChunkStream chunkStream = new ChunkStream("IEND");
        try {
            chunkStream.writeToStream(this.dataOutput);
        }
        finally {
            chunkStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCHRM() {
        if (this.param.isChromaticitySet() || this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("cHRM");
            try {
                float[] fArray = !this.param.isSRGBIntentSet() ? this.param.getChromaticity() : SRGB_CHROMA;
                for (int i2 = 0; i2 < 8; ++i2) {
                    chunkStream.writeInt((int)(fArray[i2] * 100000.0f));
                }
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGAMA() {
        if (this.param.isGammaSet() || this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("gAMA");
            try {
                float f2 = !this.param.isSRGBIntentSet() ? this.param.getGamma() : 0.45454544f;
                chunkStream.writeInt((int)(f2 * 100000.0f));
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeICCP() {
        if (this.param.isICCProfileDataSet()) {
            ChunkStream chunkStream = new ChunkStream("iCCP");
            try {
                byte[] byArray = this.param.getICCProfileData();
                chunkStream.write(byArray);
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSBIT() {
        if (this.param.isSignificantBitsSet()) {
            ChunkStream chunkStream = new ChunkStream("sBIT");
            try {
                int[] nArray;
                for (int n2 : nArray = this.param.getSignificantBits()) {
                    chunkStream.writeByte(n2);
                }
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSRGB() {
        if (this.param.isSRGBIntentSet()) {
            ChunkStream chunkStream = new ChunkStream("sRGB");
            try {
                int n2 = this.param.getSRGBIntent();
                chunkStream.write(n2);
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePLTE() {
        if (this.redPalette == null) {
            return;
        }
        ChunkStream chunkStream = new ChunkStream("PLTE");
        try {
            for (int i2 = 0; i2 < this.redPalette.length; ++i2) {
                chunkStream.writeByte(this.redPalette[i2]);
                chunkStream.writeByte(this.greenPalette[i2]);
                chunkStream.writeByte(this.bluePalette[i2]);
            }
            chunkStream.writeToStream(this.dataOutput);
        }
        finally {
            chunkStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBKGD() {
        if (this.param.isBackgroundSet()) {
            ChunkStream chunkStream = new ChunkStream("bKGD");
            try {
                switch (this.colorType) {
                    case 0: 
                    case 4: {
                        int n2 = ((PNGEncodeParam.Gray)this.param).getBackgroundGray();
                        chunkStream.writeShort(n2);
                        break;
                    }
                    case 3: {
                        int n3 = ((PNGEncodeParam.Palette)this.param).getBackgroundPaletteIndex();
                        chunkStream.writeByte(n3);
                        break;
                    }
                    case 2: 
                    case 6: {
                        int[] nArray = ((PNGEncodeParam.RGB)this.param).getBackgroundRGB();
                        chunkStream.writeShort(nArray[0]);
                        chunkStream.writeShort(nArray[1]);
                        chunkStream.writeShort(nArray[2]);
                    }
                }
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHIST() {
        if (this.param.isPaletteHistogramSet()) {
            ChunkStream chunkStream = new ChunkStream("hIST");
            try {
                int[] nArray;
                for (int n2 : nArray = this.param.getPaletteHistogram()) {
                    chunkStream.writeShort(n2);
                }
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTRNS() {
        if (this.param.isTransparencySet() && this.colorType != 4 && this.colorType != 6) {
            ChunkStream chunkStream = new ChunkStream("tRNS");
            try {
                if (this.param instanceof PNGEncodeParam.Palette) {
                    byte[] byArray;
                    for (byte by2 : byArray = ((PNGEncodeParam.Palette)this.param).getPaletteTransparency()) {
                        chunkStream.writeByte(by2);
                    }
                } else if (this.param instanceof PNGEncodeParam.Gray) {
                    int n2 = ((PNGEncodeParam.Gray)this.param).getTransparentGray();
                    chunkStream.writeShort(n2);
                } else if (this.param instanceof PNGEncodeParam.RGB) {
                    int[] nArray = ((PNGEncodeParam.RGB)this.param).getTransparentRGB();
                    chunkStream.writeShort(nArray[0]);
                    chunkStream.writeShort(nArray[1]);
                    chunkStream.writeShort(nArray[2]);
                }
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
        if (this.colorType == 3) {
            int n3;
            int n4;
            for (n4 = n3 = Math.min(255, this.alphaPalette.length - 1); n4 >= 0 && this.alphaPalette[n4] == -1; --n4) {
            }
            if (n4 >= 0) {
                ChunkStream chunkStream = new ChunkStream("tRNS");
                try {
                    for (int i2 = 0; i2 <= n4; ++i2) {
                        chunkStream.writeByte(this.alphaPalette[i2]);
                    }
                    chunkStream.writeToStream(this.dataOutput);
                }
                finally {
                    chunkStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePHYS() {
        if (this.param.isPhysicalDimensionSet()) {
            ChunkStream chunkStream = new ChunkStream("pHYs");
            try {
                int[] nArray = this.param.getPhysicalDimension();
                chunkStream.writeInt(nArray[0]);
                chunkStream.writeInt(nArray[1]);
                chunkStream.writeByte((byte)nArray[2]);
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSPLT() {
        if (this.param.isSuggestedPaletteSet()) {
            ChunkStream chunkStream = new ChunkStream("sPLT");
            try {
                System.out.println("sPLT not supported yet.");
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTIME() {
        if (this.param.isModificationTimeSet()) {
            ChunkStream chunkStream = new ChunkStream("tIME");
            try {
                Date date = this.param.getModificationTime();
                TimeZone timeZone = TimeZone.getTimeZone("GMT");
                GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
                gregorianCalendar.setTime(date);
                int n2 = gregorianCalendar.get(1);
                int n3 = gregorianCalendar.get(2);
                int n4 = gregorianCalendar.get(5);
                int n5 = gregorianCalendar.get(11);
                int n6 = gregorianCalendar.get(12);
                int n7 = gregorianCalendar.get(13);
                chunkStream.writeShort(n2);
                chunkStream.writeByte(n3 + 1);
                chunkStream.writeByte(n4);
                chunkStream.writeByte(n5);
                chunkStream.writeByte(n6);
                chunkStream.writeByte(n7);
                chunkStream.writeToStream(this.dataOutput);
            }
            finally {
                chunkStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTEXT() {
        if (this.param.isTextSet()) {
            String[] stringArray = this.param.getText();
            for (int i2 = 0; i2 < stringArray.length / 2; ++i2) {
                byte[] byArray = stringArray[2 * i2].getBytes("UTF-8");
                byte[] byArray2 = stringArray[2 * i2 + 1].getBytes("UTF-8");
                ChunkStream chunkStream = new ChunkStream("tEXt");
                try {
                    chunkStream.write(byArray, 0, Math.min(byArray.length, 79));
                    chunkStream.write(0);
                    chunkStream.write(byArray2);
                    chunkStream.writeToStream(this.dataOutput);
                    continue;
                }
                finally {
                    chunkStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZTXT() {
        if (this.param.isCompressedTextSet()) {
            String[] stringArray = this.param.getCompressedText();
            for (int i2 = 0; i2 < stringArray.length / 2; ++i2) {
                byte[] byArray = stringArray[2 * i2].getBytes("UTF-8");
                byte[] byArray2 = stringArray[2 * i2 + 1].getBytes("UTF-8");
                ChunkStream chunkStream = new ChunkStream("zTXt");
                try {
                    chunkStream.write(byArray, 0, Math.min(byArray.length, 79));
                    chunkStream.write(0);
                    chunkStream.write(0);
                    DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(chunkStream);
                    try {
                        deflaterOutputStream.write(byArray2);
                        deflaterOutputStream.finish();
                    }
                    finally {
                        deflaterOutputStream.close();
                    }
                    chunkStream.writeToStream(this.dataOutput);
                    continue;
                }
                finally {
                    chunkStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePrivateChunks() {
        int n2 = this.param.getNumPrivateChunks();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.param.getPrivateChunkType(i2);
            byte[] byArray = this.param.getPrivateChunkData(i2);
            ChunkStream chunkStream = new ChunkStream(string);
            try {
                chunkStream.write(byArray);
                chunkStream.writeToStream(this.dataOutput);
                continue;
            }
            finally {
                chunkStream.close();
            }
        }
    }

    private PNGEncodeParam.Gray createGrayParam(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        PNGEncodeParam.Gray gray = new PNGEncodeParam.Gray();
        int n2 = 0;
        int n3 = 255 / ((1 << this.bitDepth) - 1);
        int n4 = 1 << this.bitDepth;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by2 = byArray[i2];
            if (by2 != i2 * n3 || by2 != byArray2[i2] || by2 != byArray3[i2]) {
                return null;
            }
            byte by3 = byArray4[i2];
            if (by3 == 0) {
                gray.setTransparentGray(i2);
                if (++n2 <= 1) continue;
                return null;
            }
            if (by3 == -1) continue;
            return null;
        }
        return gray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encode(RenderedImage renderedImage) {
        Object object;
        this.image = renderedImage;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        SampleModel sampleModel = this.image.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        this.bitDepth = -1;
        this.bitShift = 0;
        if (this.param instanceof PNGEncodeParam.Gray) {
            object = (PNGEncodeParam.Gray)this.param;
            if (((PNGEncodeParam.Gray)object).isBitDepthSet()) {
                this.bitDepth = ((PNGEncodeParam)object).getBitDepth();
            }
            if (((PNGEncodeParam.Gray)object).isBitShiftSet()) {
                this.bitShift = ((PNGEncodeParam.Gray)object).getBitShift();
            }
        }
        if (this.bitDepth == -1) {
            this.bitDepth = nArray[0];
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                if (nArray[i2] == this.bitDepth) continue;
                throw new RuntimeException(PropertyUtil.getString("PNGImageEncoder0"));
            }
            if (this.bitDepth > 2 && this.bitDepth < 4) {
                this.bitDepth = 4;
            } else if (this.bitDepth > 4 && this.bitDepth < 8) {
                this.bitDepth = 8;
            } else if (this.bitDepth > 8 && this.bitDepth < 16) {
                this.bitDepth = 16;
            } else if (this.bitDepth > 16) {
                throw new RuntimeException(PropertyUtil.getString("PNGImageEncoder1"));
            }
        }
        this.numBands = sampleModel.getNumBands();
        this.bpp = this.numBands * (this.bitDepth == 16 ? 2 : 1);
        object = this.image.getColorModel();
        if (object instanceof IndexColorModel) {
            if (this.bitDepth < 1 || this.bitDepth > 8) {
                throw new RuntimeException(PropertyUtil.getString("PNGImageEncoder2"));
            }
            if (sampleModel.getNumBands() != 1) {
                throw new RuntimeException(PropertyUtil.getString("PNGImageEncoder3"));
            }
            IndexColorModel indexColorModel = (IndexColorModel)object;
            int n2 = indexColorModel.getMapSize();
            this.redPalette = new byte[n2];
            this.greenPalette = new byte[n2];
            this.bluePalette = new byte[n2];
            this.alphaPalette = new byte[n2];
            indexColorModel.getReds(this.redPalette);
            indexColorModel.getGreens(this.greenPalette);
            indexColorModel.getBlues(this.bluePalette);
            indexColorModel.getAlphas(this.alphaPalette);
            this.bpp = 1;
            if (this.param == null) {
                this.param = this.createGrayParam(this.redPalette, this.greenPalette, this.bluePalette, this.alphaPalette);
            }
            if (this.param == null) {
                this.param = new PNGEncodeParam.Palette();
            }
            if (this.param instanceof PNGEncodeParam.Palette) {
                PNGEncodeParam.Palette palette = (PNGEncodeParam.Palette)this.param;
                if (palette.isPaletteSet()) {
                    int[] nArray2 = palette.getPalette();
                    n2 = nArray2.length / 3;
                    int n3 = 0;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        this.redPalette[i3] = (byte)nArray2[n3++];
                        this.greenPalette[i3] = (byte)nArray2[n3++];
                        this.bluePalette[i3] = (byte)nArray2[n3++];
                        this.alphaPalette[i3] = -1;
                    }
                }
                this.colorType = 3;
            } else {
                if (!(this.param instanceof PNGEncodeParam.Gray)) throw new RuntimeException(PropertyUtil.getString("PNGImageEncoder4"));
                this.alphaPalette = null;
                this.bluePalette = null;
                this.greenPalette = null;
                this.redPalette = null;
                this.colorType = 0;
            }
        } else if (this.numBands == 1) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.Gray();
            }
            this.colorType = 0;
        } else if (this.numBands == 2) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.Gray();
            }
            if (this.param.isTransparencySet()) {
                this.skipAlpha = true;
                this.numBands = 1;
                if (nArray[0] == 8 && this.bitDepth < 8) {
                    this.compressGray = true;
                }
                this.bpp = this.bitDepth == 16 ? 2 : 1;
                this.colorType = 0;
            } else {
                if (this.bitDepth < 8) {
                    this.bitDepth = 8;
                }
                this.colorType = 4;
            }
        } else if (this.numBands == 3) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.RGB();
            }
            this.colorType = 2;
        } else if (this.numBands == 4) {
            if (this.param == null) {
                this.param = new PNGEncodeParam.RGB();
            }
            if (this.param.isTransparencySet()) {
                this.skipAlpha = true;
                this.numBands = 3;
                this.bpp = this.bitDepth == 16 ? 6 : 3;
                this.colorType = 2;
            } else {
                this.colorType = 6;
            }
        }
        this.interlace = this.param.getInterlacing();
        this.writeMagic();
        this.writeIHDR();
        this.writeCHRM();
        this.writeGAMA();
        this.writeICCP();
        this.writeSBIT();
        this.writeSRGB();
        this.writePLTE();
        this.writeHIST();
        this.writeTRNS();
        this.writeBKGD();
        this.writePHYS();
        this.writeSPLT();
        this.writeTIME();
        this.writeTEXT();
        this.writeZTXT();
        this.writePrivateChunks();
        this.writeIDAT();
        this.writeIEND();
        this.dataOutput.flush();
        this.dataOutput.close();
    }
}

