/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.xmlgraphics.image.codec.png.PNGDecodeParam;
import org.apache.xmlgraphics.image.codec.png.PNGImage;
import org.apache.xmlgraphics.image.codec.util.ImageDecodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageDecoderImpl;
import org.apache.xmlgraphics.image.codec.util.ImageInputStreamSeekableStreamAdapter;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.loader.ImageSize;

public class PNGImageDecoder
extends ImageDecoderImpl {
    public PNGImageDecoder(InputStream inputStream, PNGDecodeParam pNGDecodeParam) {
        super(inputStream, (ImageDecodeParam)pNGDecodeParam);
    }

    @Override
    public RenderedImage decodeAsRenderedImage(int n2) {
        if (n2 != 0) {
            throw new IOException(PropertyUtil.getString("PNGImageDecoder19"));
        }
        return new PNGImage(this.input, (PNGDecodeParam)this.param);
    }

    public static void readPNGHeader(ImageInputStream imageInputStream, ImageSize imageSize) {
        ImageInputStreamSeekableStreamAdapter imageInputStreamSeekableStreamAdapter = new ImageInputStreamSeekableStreamAdapter(imageInputStream){

            @Override
            public void close() {
            }
        };
        PNGImage pNGImage = new PNGImage(imageInputStreamSeekableStreamAdapter);
        imageSize.setSizeInPixels(pNGImage.getWidth(), pNGImage.getHeight());
        double d2 = imageSize.getDpiHorizontal();
        double d3 = imageSize.getDpiVertical();
        if (pNGImage.unitSpecifier == 1) {
            if (pNGImage.xPixelsPerUnit != 0) {
                d2 = (double)pNGImage.xPixelsPerUnit * 0.0254;
            }
            if (pNGImage.yPixelsPerUnit != 0) {
                d3 = (double)pNGImage.yPixelsPerUnit * 0.0254;
            }
        }
        imageSize.setResolution(d2, d3);
        imageSize.calcSizeFromPixels();
    }
}

