/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.xmlgraphics.image.codec.png.PNGSuggestedPaletteEntry;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;

public abstract class PNGEncodeParam
implements ImageEncodeParam {
    private static final long serialVersionUID = -7851509538552141263L;
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    protected int bitDepth;
    protected boolean bitDepthSet;
    private boolean useInterlacing;
    private float[] chromaticity;
    private boolean chromaticitySet;
    private float gamma;
    private boolean gammaSet;
    private int[] paletteHistogram;
    private boolean paletteHistogramSet;
    private byte[] iccProfileData;
    private boolean iccProfileDataSet;
    private int[] physicalDimension;
    private boolean physicalDimensionSet;
    private PNGSuggestedPaletteEntry[] suggestedPalette;
    private boolean suggestedPaletteSet;
    private int[] significantBits;
    private boolean significantBitsSet;
    private int srgbIntent;
    private boolean srgbIntentSet;
    private String[] text;
    private boolean textSet;
    private Date modificationTime;
    private boolean modificationTimeSet;
    boolean transparencySet;
    private String[] zText;
    private boolean zTextSet;
    List chunkType = new ArrayList();
    List chunkData = new ArrayList();

    public static PNGEncodeParam getDefaultEncodeParam(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return new Palette();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getNumBands();
        if (n2 == 1 || n2 == 2) {
            return new Gray();
        }
        return new RGB();
    }

    public abstract void setBitDepth(int var1);

    public int getBitDepth() {
        if (!this.bitDepthSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam11"));
        }
        return this.bitDepth;
    }

    public void unsetBitDepth() {
        this.bitDepthSet = false;
    }

    public void setInterlacing(boolean bl2) {
        this.useInterlacing = bl2;
    }

    public boolean getInterlacing() {
        return this.useInterlacing;
    }

    public void unsetBackground() {
        throw new RuntimeException(PropertyUtil.getString("PNGEncodeParam23"));
    }

    public boolean isBackgroundSet() {
        throw new RuntimeException(PropertyUtil.getString("PNGEncodeParam24"));
    }

    public void setChromaticity(float[] fArray) {
        if (fArray.length != 8) {
            throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam28"));
        }
        this.chromaticity = (float[])fArray.clone();
        this.chromaticitySet = true;
    }

    public void setChromaticity(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[] fArray = new float[]{f2, f3, f4, f5, f6, f7, f8, f9};
        this.setChromaticity(fArray);
    }

    public float[] getChromaticity() {
        if (!this.chromaticitySet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam12"));
        }
        return (float[])this.chromaticity.clone();
    }

    public void unsetChromaticity() {
        this.chromaticity = null;
        this.chromaticitySet = false;
    }

    public boolean isChromaticitySet() {
        return this.chromaticitySet;
    }

    public void setGamma(float f2) {
        this.gamma = f2;
        this.gammaSet = true;
    }

    public float getGamma() {
        if (!this.gammaSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam13"));
        }
        return this.gamma;
    }

    public void unsetGamma() {
        this.gammaSet = false;
    }

    public boolean isGammaSet() {
        return this.gammaSet;
    }

    public void setPaletteHistogram(int[] nArray) {
        this.paletteHistogram = (int[])nArray.clone();
        this.paletteHistogramSet = true;
    }

    public int[] getPaletteHistogram() {
        if (!this.paletteHistogramSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam14"));
        }
        return this.paletteHistogram;
    }

    public void unsetPaletteHistogram() {
        this.paletteHistogram = null;
        this.paletteHistogramSet = false;
    }

    public boolean isPaletteHistogramSet() {
        return this.paletteHistogramSet;
    }

    public void setICCProfileData(byte[] byArray) {
        this.iccProfileData = (byte[])byArray.clone();
        this.iccProfileDataSet = true;
    }

    public byte[] getICCProfileData() {
        if (!this.iccProfileDataSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam15"));
        }
        return (byte[])this.iccProfileData.clone();
    }

    public void unsetICCProfileData() {
        this.iccProfileData = null;
        this.iccProfileDataSet = false;
    }

    public boolean isICCProfileDataSet() {
        return this.iccProfileDataSet;
    }

    public void setPhysicalDimension(int[] nArray) {
        this.physicalDimension = (int[])nArray.clone();
        this.physicalDimensionSet = true;
    }

    public void setPhysicalDimension(int n2, int n3, int n4) {
        int[] nArray = new int[]{n2, n3, n4};
        this.setPhysicalDimension(nArray);
    }

    public int[] getPhysicalDimension() {
        if (!this.physicalDimensionSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam16"));
        }
        return (int[])this.physicalDimension.clone();
    }

    public void unsetPhysicalDimension() {
        this.physicalDimension = null;
        this.physicalDimensionSet = false;
    }

    public boolean isPhysicalDimensionSet() {
        return this.physicalDimensionSet;
    }

    public void setSuggestedPalette(PNGSuggestedPaletteEntry[] pNGSuggestedPaletteEntryArray) {
        this.suggestedPalette = (PNGSuggestedPaletteEntry[])pNGSuggestedPaletteEntryArray.clone();
        this.suggestedPaletteSet = true;
    }

    public PNGSuggestedPaletteEntry[] getSuggestedPalette() {
        if (!this.suggestedPaletteSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam17"));
        }
        return (PNGSuggestedPaletteEntry[])this.suggestedPalette.clone();
    }

    public void unsetSuggestedPalette() {
        this.suggestedPalette = null;
        this.suggestedPaletteSet = false;
    }

    public boolean isSuggestedPaletteSet() {
        return this.suggestedPaletteSet;
    }

    public void setSignificantBits(int[] nArray) {
        this.significantBits = (int[])nArray.clone();
        this.significantBitsSet = true;
    }

    public int[] getSignificantBits() {
        if (!this.significantBitsSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam18"));
        }
        return (int[])this.significantBits.clone();
    }

    public void unsetSignificantBits() {
        this.significantBits = null;
        this.significantBitsSet = false;
    }

    public boolean isSignificantBitsSet() {
        return this.significantBitsSet;
    }

    public void setSRGBIntent(int n2) {
        this.srgbIntent = n2;
        this.srgbIntentSet = true;
    }

    public int getSRGBIntent() {
        if (!this.srgbIntentSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam19"));
        }
        return this.srgbIntent;
    }

    public void unsetSRGBIntent() {
        this.srgbIntentSet = false;
    }

    public boolean isSRGBIntentSet() {
        return this.srgbIntentSet;
    }

    public void setText(String[] stringArray) {
        this.text = stringArray;
        this.textSet = true;
    }

    public String[] getText() {
        if (!this.textSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam20"));
        }
        return this.text;
    }

    public void unsetText() {
        this.text = null;
        this.textSet = false;
    }

    public boolean isTextSet() {
        return this.textSet;
    }

    public void setModificationTime(Date date) {
        this.modificationTime = date;
        this.modificationTimeSet = true;
    }

    public Date getModificationTime() {
        if (!this.modificationTimeSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam21"));
        }
        return this.modificationTime;
    }

    public void unsetModificationTime() {
        this.modificationTime = null;
        this.modificationTimeSet = false;
    }

    public boolean isModificationTimeSet() {
        return this.modificationTimeSet;
    }

    public void unsetTransparency() {
        this.transparencySet = false;
    }

    public boolean isTransparencySet() {
        return this.transparencySet;
    }

    public void setCompressedText(String[] stringArray) {
        this.zText = stringArray;
        this.zTextSet = true;
    }

    public String[] getCompressedText() {
        if (!this.zTextSet) {
            throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam22"));
        }
        return this.zText;
    }

    public void unsetCompressedText() {
        this.zText = null;
        this.zTextSet = false;
    }

    public boolean isCompressedTextSet() {
        return this.zTextSet;
    }

    public synchronized void addPrivateChunk(String string, byte[] byArray) {
        this.chunkType.add(string);
        this.chunkData.add(byArray.clone());
    }

    public synchronized int getNumPrivateChunks() {
        return this.chunkType.size();
    }

    public synchronized String getPrivateChunkType(int n2) {
        return (String)this.chunkType.get(n2);
    }

    public synchronized byte[] getPrivateChunkData(int n2) {
        return (byte[])this.chunkData.get(n2);
    }

    public synchronized void removeUnsafeToCopyPrivateChunks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        int n2 = this.getNumPrivateChunks();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getPrivateChunkType(i2);
            char c2 = string.charAt(3);
            if (c2 < 'a' || c2 > 'z') continue;
            arrayList.add(string);
            arrayList2.add(this.getPrivateChunkData(i2));
        }
        this.chunkType = arrayList;
        this.chunkData = arrayList2;
    }

    public synchronized void removeAllPrivateChunks() {
        this.chunkType = new ArrayList();
        this.chunkData = new ArrayList();
    }

    private static int abs(int n2) {
        return n2 < 0 ? -n2 : n2;
    }

    public static int paethPredictor(int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4;
        int n6 = PNGEncodeParam.abs(n5 - n2);
        int n7 = PNGEncodeParam.abs(n5 - n3);
        int n8 = PNGEncodeParam.abs(n5 - n4);
        if (n6 <= n7 && n6 <= n8) {
            return n2;
        }
        if (n7 <= n8) {
            return n3;
        }
        return n4;
    }

    public int filterRow(byte[] byArray, byte[] byArray2, byte[][] byArray3, int n2, int n3) {
        int n4;
        int[] nArray = new int[]{0, 0, 0, 0, 0};
        for (n4 = n3; n4 < n2 + n3; ++n4) {
            int n5;
            int n6 = byArray[n4] & 0xFF;
            int n7 = byArray[n4 - n3] & 0xFF;
            int n8 = byArray2[n4] & 0xFF;
            int n9 = byArray2[n4 - n3] & 0xFF;
            nArray[0] = nArray[0] + n6;
            int n10 = n6 - n7;
            byArray3[1][n4] = (byte)n10;
            nArray[1] = nArray[1] + (n10 > 0 ? n10 : -n10);
            n10 = n6 - n8;
            byArray3[2][n4] = (byte)n10;
            nArray[2] = nArray[2] + (n10 >= 0 ? n10 : -n10);
            n10 = n6 - (n7 + n8 >> 1);
            byArray3[3][n4] = (byte)n10;
            nArray[3] = nArray[3] + (n10 >= 0 ? n10 : -n10);
            int n11 = n8 - n9;
            int n12 = n7 - n9;
            if (n11 < 0) {
                if (n12 < 0) {
                    n10 = n11 >= n12 ? n6 - n7 : n6 - n8;
                } else {
                    n5 = n11 + n12;
                    n10 = (n11 = -n11) <= n12 ? (n11 <= n5 ? n6 - n7 : n6 - n9) : (n12 <= -n5 ? n6 - n8 : n6 - n9);
                }
            } else {
                n10 = n12 < 0 ? (n11 <= (n12 = -n12) ? (n11 <= (n5 = n12 - n11) ? n6 - n7 : (n12 == n5 ? n6 - n8 : n6 - n9)) : (n12 <= (n5 = n11 - n12) ? n6 - n8 : n6 - n9)) : (n11 <= n12 ? n6 - n7 : n6 - n8);
            }
            byArray3[4][n4] = (byte)n10;
            nArray[4] = nArray[4] + (n10 >= 0 ? n10 : -n10);
        }
        n4 = 0;
        int n13 = nArray[0];
        for (int i2 = 1; i2 < 5; ++i2) {
            if (nArray[i2] >= n13) continue;
            n13 = nArray[i2];
            n4 = i2;
        }
        if (n4 == 0) {
            System.arraycopy(byArray, n3, byArray3[0], n3, n2);
        }
        return n4;
    }

    public static class RGB
    extends PNGEncodeParam {
        private static final long serialVersionUID = -8918762026006670891L;
        private boolean backgroundSet;
        private int[] backgroundRGB;
        private int[] transparency;

        @Override
        public void unsetBackground() {
            this.backgroundSet = false;
        }

        @Override
        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        @Override
        public void setBitDepth(int n2) {
            if (n2 != 8 && n2 != 16) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam26"));
            }
            this.bitDepth = n2;
            this.bitDepthSet = true;
        }

        public void setBackgroundRGB(int[] nArray) {
            if (nArray.length != 3) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam27"));
            }
            this.backgroundRGB = nArray;
            this.backgroundSet = true;
        }

        public int[] getBackgroundRGB() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam9"));
            }
            return this.backgroundRGB;
        }

        public void setTransparentRGB(int[] nArray) {
            this.transparency = (int[])nArray.clone();
            this.transparencySet = true;
        }

        public int[] getTransparentRGB() {
            if (!this.transparencySet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam10"));
            }
            return (int[])this.transparency.clone();
        }
    }

    public static class Gray
    extends PNGEncodeParam {
        private static final long serialVersionUID = -2055439792025795274L;
        private boolean backgroundSet;
        private int backgroundPaletteGray;
        private int[] transparency;
        private int bitShift;
        private boolean bitShiftSet;

        @Override
        public void unsetBackground() {
            this.backgroundSet = false;
        }

        @Override
        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        @Override
        public void setBitDepth(int n2) {
            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam2"));
            }
            this.bitDepth = n2;
            this.bitDepthSet = true;
        }

        public void setBackgroundGray(int n2) {
            this.backgroundPaletteGray = n2;
            this.backgroundSet = true;
        }

        public int getBackgroundGray() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam6"));
            }
            return this.backgroundPaletteGray;
        }

        public void setTransparentGray(int n2) {
            this.transparency = new int[1];
            this.transparency[0] = n2;
            this.transparencySet = true;
        }

        public int getTransparentGray() {
            if (!this.transparencySet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam7"));
            }
            int n2 = this.transparency[0];
            return n2;
        }

        public void setBitShift(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam25"));
            }
            this.bitShift = n2;
            this.bitShiftSet = true;
        }

        public int getBitShift() {
            if (!this.bitShiftSet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam8"));
            }
            return this.bitShift;
        }

        public void unsetBitShift() {
            this.bitShiftSet = false;
        }

        public boolean isBitShiftSet() {
            return this.bitShiftSet;
        }

        public boolean isBitDepthSet() {
            return this.bitDepthSet;
        }
    }

    public static class Palette
    extends PNGEncodeParam {
        private static final long serialVersionUID = -5181545170427733891L;
        private boolean backgroundSet;
        private int[] palette;
        private boolean paletteSet;
        private int backgroundPaletteIndex;
        private int[] transparency;

        @Override
        public void unsetBackground() {
            this.backgroundSet = false;
        }

        @Override
        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        @Override
        public void setBitDepth(int n2) {
            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam2"));
            }
            this.bitDepth = n2;
            this.bitDepthSet = true;
        }

        public void setPalette(int[] nArray) {
            if (nArray.length < 3 || nArray.length > 768) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam0"));
            }
            if (nArray.length % 3 != 0) {
                throw new IllegalArgumentException(PropertyUtil.getString("PNGEncodeParam1"));
            }
            this.palette = (int[])nArray.clone();
            this.paletteSet = true;
        }

        public int[] getPalette() {
            if (!this.paletteSet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam3"));
            }
            return (int[])this.palette.clone();
        }

        public void unsetPalette() {
            this.palette = null;
            this.paletteSet = false;
        }

        public boolean isPaletteSet() {
            return this.paletteSet;
        }

        public void setBackgroundPaletteIndex(int n2) {
            this.backgroundPaletteIndex = n2;
            this.backgroundSet = true;
        }

        public int getBackgroundPaletteIndex() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam4"));
            }
            return this.backgroundPaletteIndex;
        }

        public void setPaletteTransparency(byte[] byArray) {
            this.transparency = new int[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                this.transparency[i2] = byArray[i2] & 0xFF;
            }
            this.transparencySet = true;
        }

        public byte[] getPaletteTransparency() {
            if (!this.transparencySet) {
                throw new IllegalStateException(PropertyUtil.getString("PNGEncodeParam5"));
            }
            byte[] byArray = new byte[this.transparency.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = (byte)this.transparency[i2];
            }
            return byArray;
        }
    }
}

