/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.io.DataInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PNGChunk {
    int length;
    int type;
    byte[] data;
    int crc;
    String typeString;
    protected static final Log log = LogFactory.getLog(PNGChunk.class);

    public PNGChunk(int n2, int n3, byte[] byArray, int n4) {
        this.length = n2;
        this.type = n3;
        this.data = byArray;
        this.crc = n4;
        this.typeString = PNGChunk.typeIntToString(this.type);
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte getByte(int n2) {
        return this.data[n2];
    }

    public int getInt1(int n2) {
        return this.data[n2] & 0xFF;
    }

    public int getInt2(int n2) {
        return (this.data[n2] & 0xFF) << 8 | this.data[n2 + 1] & 0xFF;
    }

    public int getInt4(int n2) {
        return (this.data[n2] & 0xFF) << 24 | (this.data[n2 + 1] & 0xFF) << 16 | (this.data[n2 + 2] & 0xFF) << 8 | this.data[n2 + 3] & 0xFF;
    }

    public String getString4(int n2) {
        return "" + (char)this.data[n2] + (char)this.data[n2 + 1] + (char)this.data[n2 + 2] + (char)this.data[n2 + 3];
    }

    public boolean isType(String string) {
        return this.typeString.equals(string);
    }

    public static PNGChunk readChunk(DataInputStream dataInputStream) {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            int n4 = dataInputStream.readInt();
            return new PNGChunk(n2, n3, byArray, n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getChunkType(DataInputStream dataInputStream) {
        try {
            dataInputStream.mark(8);
            dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            dataInputStream.reset();
            return PNGChunk.typeIntToString(n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String typeIntToString(int n2) {
        String string = "";
        string = string + (char)(n2 >> 24);
        string = string + (char)(n2 >> 16 & 0xFF);
        string = string + (char)(n2 >> 8 & 0xFF);
        string = string + (char)(n2 & 0xFF);
        return string;
    }

    public static boolean skipChunk(DataInputStream dataInputStream) {
        try {
            int n2 = dataInputStream.readInt();
            dataInputStream.readInt();
            int n3 = dataInputStream.skipBytes(n2);
            dataInputStream.readInt();
            if (n3 != n2) {
                log.warn("Incorrect number of bytes skipped.");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            log.warn(exception.getMessage());
            return false;
        }
    }

    public static enum ChunkType {
        IHDR,
        PLTE,
        IDAT,
        IEND,
        bKGD,
        cHRM,
        gAMA,
        hIST,
        iCCP,
        iTXt,
        pHYs,
        sBIT,
        sPLT,
        sRGB,
        sTER,
        tEXt,
        tIME,
        tRNS,
        zTXt;

    }
}

