/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.png;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.codec.png.CRC;

class IDATOutputStream
extends FilterOutputStream {
    private static final byte[] TYPE_SIGNATURE = new byte[]{73, 68, 65, 84};
    private int bytesWritten;
    private int segmentLength;
    private byte[] buffer;

    public IDATOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        this.segmentLength = n2;
        this.buffer = new byte[n2];
    }

    @Override
    public void close() {
        this.flush();
    }

    private void writeInt(int n2) {
        this.out.write(n2 >> 24);
        this.out.write(n2 >> 16 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
    }

    @Override
    public void flush() {
        if (this.bytesWritten == 0) {
            return;
        }
        this.writeInt(this.bytesWritten);
        this.out.write(TYPE_SIGNATURE);
        this.out.write(this.buffer, 0, this.bytesWritten);
        int n2 = -1;
        n2 = CRC.updateCRC(n2, TYPE_SIGNATURE, 0, 4);
        n2 = CRC.updateCRC(n2, this.buffer, 0, this.bytesWritten);
        this.writeInt(~n2);
        this.bytesWritten = 0;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = Math.min(this.segmentLength - this.bytesWritten, n3);
            System.arraycopy(byArray, n2, this.buffer, this.bytesWritten, n4);
            n2 += n4;
            n3 -= n4;
            this.bytesWritten += n4;
            if (this.bytesWritten != this.segmentLength) continue;
            this.flush();
        }
    }

    @Override
    public void write(int n2) {
        this.buffer[this.bytesWritten++] = (byte)n2;
        if (this.bytesWritten == this.segmentLength) {
            this.flush();
        }
    }
}

