/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.xmlgraphics.image.rendered.Any2LsRGBRed;
import org.apache.xmlgraphics.image.rendered.Any2sRGBRed;
import org.apache.xmlgraphics.image.rendered.BufferedImageCachableRed;
import org.apache.xmlgraphics.image.rendered.CachableRed;
import org.apache.xmlgraphics.image.rendered.RenderedImageCachableRed;

public final class GraphicsUtil {
    public static final AffineTransform IDENTITY = new AffineTransform();
    public static final ColorModel Linear_sRGB = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel Linear_sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel Linear_sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    public static final ColorModel sRGB = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);

    private GraphicsUtil() {
    }

    public static ColorModel makeLinear_sRGBCM(boolean bl2) {
        return bl2 ? Linear_sRGB_Pre : Linear_sRGB_Unpre;
    }

    public static BufferedImage makeLinearBufferedImage(int n2, int n3, boolean bl2) {
        ColorModel colorModel = GraphicsUtil.makeLinear_sRGBCM(bl2);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        return new BufferedImage(colorModel, writableRaster, bl2, null);
    }

    public static CachableRed convertToLsRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1004)) {
            return cachableRed;
        }
        return new Any2LsRGBRed(cachableRed);
    }

    public static CachableRed convertTosRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1000)) {
            return cachableRed;
        }
        return new Any2sRGBRed(cachableRed);
    }

    public static CachableRed wrap(RenderedImage renderedImage) {
        if (renderedImage instanceof CachableRed) {
            return (CachableRed)renderedImage;
        }
        if (renderedImage instanceof BufferedImage) {
            return new BufferedImageCachableRed((BufferedImage)renderedImage);
        }
        return new RenderedImageCachableRed(renderedImage);
    }

    public static void copyData_INT_PACK(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        int n4;
        int n5 = writableRaster.getMinX();
        if (n5 < raster.getMinX()) {
            n5 = raster.getMinX();
        }
        if ((n4 = writableRaster.getMinY()) < raster.getMinY()) {
            n4 = raster.getMinY();
        }
        if ((n3 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n3 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n2 = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n2 = raster.getMinY() + raster.getHeight() - 1;
        }
        int n6 = n3 - n5 + 1;
        int n7 = n2 - n4 + 1;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n8 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n5 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n10 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int n11 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n5 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
        if (n8 == n10 && n8 == n6) {
            System.arraycopy(nArray, n9, nArray2, n11, n6 * n7);
        } else if (n6 > 128) {
            int n12 = n9;
            int n13 = n11;
            for (int i2 = 0; i2 < n7; ++i2) {
                System.arraycopy(nArray, n12, nArray2, n13, n6);
                n12 += n8;
                n13 += n10;
            }
        } else {
            for (int i3 = 0; i3 < n7; ++i3) {
                int n14 = n9 + i3 * n8;
                int n15 = n11 + i3 * n10;
                for (int i4 = 0; i4 < n6; ++i4) {
                    nArray2[n15++] = nArray[n14++];
                }
            }
        }
    }

    public static void copyData_FALLBACK(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        int n4;
        int n5 = writableRaster.getMinX();
        if (n5 < raster.getMinX()) {
            n5 = raster.getMinX();
        }
        if ((n4 = writableRaster.getMinY()) < raster.getMinY()) {
            n4 = raster.getMinY();
        }
        if ((n3 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n3 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n2 = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n2 = raster.getMinY() + raster.getHeight() - 1;
        }
        int n6 = n3 - n5 + 1;
        int[] nArray = null;
        for (int i2 = n4; i2 <= n2; ++i2) {
            nArray = raster.getPixels(n5, i2, n6, 1, nArray);
            writableRaster.setPixels(n5, i2, n6, 1, nArray);
        }
    }

    public static void copyData(Raster raster, WritableRaster writableRaster) {
        if (GraphicsUtil.is_INT_PACK_Data(raster.getSampleModel(), false) && GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
            GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
            return;
        }
        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
    }

    public static WritableRaster copyRaster(Raster raster) {
        return GraphicsUtil.copyRaster(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster copyRaster(Raster raster, int n2, int n3) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n2, n3, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster.getDataBuffer();
        if (dataBuffer.getDataType() != dataBuffer2.getDataType()) {
            throw new IllegalArgumentException("New DataBuffer doesn't match original");
        }
        int n4 = dataBuffer.getSize();
        int n5 = dataBuffer.getNumBanks();
        int[] nArray = dataBuffer.getOffsets();
        block6: for (int i2 = 0; i2 < n5; ++i2) {
            switch (dataBuffer.getDataType()) {
                case 0: {
                    DataBuffer dataBuffer3 = (DataBufferByte)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferByte)dataBuffer2;
                    System.arraycopy(((DataBufferByte)dataBuffer3).getData(i2), nArray[i2], ((DataBufferByte)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                case 3: {
                    DataBuffer dataBuffer3 = (DataBufferInt)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferInt)dataBuffer2;
                    System.arraycopy(((DataBufferInt)dataBuffer3).getData(i2), nArray[i2], ((DataBufferInt)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                case 2: {
                    DataBuffer dataBuffer3 = (DataBufferShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferShort)dataBuffer2;
                    System.arraycopy(((DataBufferShort)dataBuffer3).getData(i2), nArray[i2], ((DataBufferShort)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                case 1: {
                    DataBuffer dataBuffer3 = (DataBufferUShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferUShort)dataBuffer2;
                    System.arraycopy(((DataBufferUShort)dataBuffer3).getData(i2), nArray[i2], ((DataBufferUShort)dataBuffer4).getData(i2), nArray[i2], n4);
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported data type: " + dataBuffer.getDataType());
                }
            }
        }
        return writableRaster;
    }

    public static WritableRaster makeRasterWritable(Raster raster) {
        return GraphicsUtil.makeRasterWritable(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster makeRasterWritable(Raster raster, int n2, int n3) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n2, n3, null);
        return writableRaster;
    }

    public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl2) {
        if (colorModel.isAlphaPremultiplied() == bl2) {
            return colorModel;
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
        return colorModel.coerceData(writableRaster, bl2);
    }

    public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl2) {
        if (!colorModel.hasAlpha()) {
            return colorModel;
        }
        if (colorModel.isAlphaPremultiplied() == bl2) {
            return colorModel;
        }
        if (bl2) {
            GraphicsUtil.multiplyAlpha(writableRaster);
        } else {
            GraphicsUtil.divideAlpha(writableRaster);
        }
        return GraphicsUtil.coerceColorModel(colorModel, bl2);
    }

    public static void multiplyAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.mult_INT_PACK_Data(writableRaster);
        } else {
            int[] nArray = null;
            int n2 = writableRaster.getNumBands();
            float f2 = 0.003921569f;
            int n3 = writableRaster.getMinX();
            int n4 = n3 + writableRaster.getWidth();
            int n5 = writableRaster.getMinY();
            int n6 = n5 + writableRaster.getHeight();
            for (int i2 = n5; i2 < n6; ++i2) {
                for (int i3 = n3; i3 < n4; ++i3) {
                    int n7 = (nArray = writableRaster.getPixel(i3, i2, nArray))[n2 - 1];
                    if (n7 < 0 || n7 >= 255) continue;
                    float f3 = (float)n7 * f2;
                    for (int i4 = 0; i4 < n2 - 1; ++i4) {
                        nArray[i4] = (int)((float)nArray[i4] * f3 + 0.5f);
                    }
                    writableRaster.setPixel(i3, i2, nArray);
                }
            }
        }
    }

    public static void divideAlpha(WritableRaster writableRaster) {
        if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(writableRaster);
        } else {
            int n2 = writableRaster.getNumBands();
            int[] nArray = null;
            int n3 = writableRaster.getMinX();
            int n4 = n3 + writableRaster.getWidth();
            int n5 = writableRaster.getMinY();
            int n6 = n5 + writableRaster.getHeight();
            for (int i2 = n5; i2 < n6; ++i2) {
                for (int i3 = n3; i3 < n4; ++i3) {
                    int n7 = (nArray = writableRaster.getPixel(i3, i2, nArray))[n2 - 1];
                    if (n7 <= 0 || n7 >= 255) continue;
                    float f2 = 255.0f / (float)n7;
                    for (int i4 = 0; i4 < n2 - 1; ++i4) {
                        nArray[i4] = (int)((float)nArray[i4] * f2 + 0.5f);
                    }
                    writableRaster.setPixel(i3, i2, nArray);
                }
            }
        }
    }

    public static void copyData(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        GraphicsUtil.copyData(bufferedImage, rectangle, bufferedImage2, new Point(0, 0));
    }

    public static void copyData(BufferedImage bufferedImage, Rectangle rectangle, BufferedImage bufferedImage2, Point point) {
        boolean bl2;
        boolean bl3 = bufferedImage.getColorModel().hasAlpha();
        if (!(bl3 != (bl2 = bufferedImage2.getColorModel().hasAlpha()) || bl3 && bufferedImage.isAlphaPremultiplied() != bufferedImage2.isAlphaPremultiplied())) {
            GraphicsUtil.copyData(bufferedImage.getRaster(), bufferedImage2.getRaster());
            return;
        }
        int[] nArray = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n2 = writableRaster2.getNumBands();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = n7 + rectangle.height - 1;
        if (!bl3) {
            int n9;
            int[] nArray2 = new int[n2 * n5];
            for (n9 = n5 * n2 - 1; n9 >= 0; n9 -= n2) {
                nArray2[n9] = 255;
            }
            for (int i2 = n7; i2 <= n8; ++i2) {
                nArray = writableRaster.getPixels(n6, i2, n5, 1, nArray);
                int n10 = n5 * (n2 - 1) - 1;
                n9 = n5 * n2 - 2;
                switch (n2) {
                    case 4: {
                        while (n10 >= 0) {
                            nArray2[n9--] = nArray[n10--];
                            nArray2[n9--] = nArray[n10--];
                            nArray2[n9--] = nArray[n10--];
                            --n9;
                        }
                        break;
                    }
                    default: {
                        while (n10 >= 0) {
                            for (int i3 = 0; i3 < n2 - 1; ++i3) {
                                nArray2[n9--] = nArray[n10--];
                            }
                            --n9;
                        }
                        break block0;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i2 + n4, n5, 1, nArray2);
            }
        } else if (bl2 && bufferedImage2.isAlphaPremultiplied()) {
            int n11 = 65793;
            int n12 = 0x800000;
            for (int i4 = n7; i4 <= n8; ++i4) {
                nArray = writableRaster.getPixels(n6, i4, n5, 1, nArray);
                int n13 = n2 * n5 - 1;
                switch (n2) {
                    case 4: {
                        int n14;
                        int n15;
                        while (n13 >= 0) {
                            n15 = nArray[n13];
                            if (n15 == 255) {
                                n13 -= 4;
                                continue;
                            }
                            n14 = n11 * n15;
                            nArray[--n13] = nArray[n13] * n14 + n12 >>> 24;
                            nArray[--n13] = nArray[n13] * n14 + n12 >>> 24;
                            nArray[--n13] = nArray[n13] * n14 + n12 >>> 24;
                            --n13;
                        }
                        break;
                    }
                    default: {
                        int n14;
                        int n15;
                        while (n13 >= 0) {
                            n15 = nArray[n13];
                            if (n15 == 255) {
                                n13 -= n2;
                                continue;
                            }
                            --n13;
                            n14 = n11 * n15;
                            for (int i5 = 0; i5 < n2 - 1; ++i5) {
                                nArray[n13] = nArray[n13] * n14 + n12 >>> 24;
                                --n13;
                            }
                        }
                        break block3;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i4 + n4, n5, 1, nArray);
            }
        } else if (bl2 && !bufferedImage2.isAlphaPremultiplied()) {
            int n16 = 0xFF0000;
            int n17 = 32768;
            for (int i6 = n7; i6 <= n8; ++i6) {
                nArray = writableRaster.getPixels(n6, i6, n5, 1, nArray);
                int n18 = n2 * n5 - 1;
                switch (n2) {
                    case 4: {
                        int n19;
                        int n20;
                        while (n18 >= 0) {
                            n20 = nArray[n18];
                            if (n20 <= 0 || n20 >= 255) {
                                n18 -= 4;
                                continue;
                            }
                            n19 = n16 / n20;
                            nArray[--n18] = nArray[n18] * n19 + n17 >>> 16;
                            nArray[--n18] = nArray[n18] * n19 + n17 >>> 16;
                            nArray[--n18] = nArray[n18] * n19 + n17 >>> 16;
                            --n18;
                        }
                        break;
                    }
                    default: {
                        int n19;
                        int n20;
                        while (n18 >= 0) {
                            n20 = nArray[n18];
                            if (n20 <= 0 || n20 >= 255) {
                                n18 -= n2;
                                continue;
                            }
                            --n18;
                            n19 = n16 / n20;
                            for (int i7 = 0; i7 < n2 - 1; ++i7) {
                                nArray[n18] = nArray[n18] * n19 + n17 >>> 16;
                                --n18;
                            }
                        }
                        break block6;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i6 + n4, n5, 1, nArray);
            }
        } else if (bufferedImage.isAlphaPremultiplied()) {
            int[] nArray3 = new int[n2 * n5];
            int n21 = 0xFF0000;
            int n22 = 32768;
            for (int i8 = n7; i8 <= n8; ++i8) {
                nArray = writableRaster.getPixels(n6, i8, n5, 1, nArray);
                int n23 = (n2 + 1) * n5 - 1;
                int n24 = n2 * n5 - 1;
                while (n23 >= 0) {
                    int n25;
                    int n26 = nArray[n23];
                    --n23;
                    if (n26 > 0) {
                        if (n26 < 255) {
                            int n27 = n21 / n26;
                            for (n25 = 0; n25 < n2; ++n25) {
                                nArray3[n24--] = nArray[n23--] * n27 + n22 >>> 16;
                            }
                            continue;
                        }
                        for (n25 = 0; n25 < n2; ++n25) {
                            nArray3[n24--] = nArray[n23--];
                        }
                        continue;
                    }
                    n23 -= n2;
                    for (n25 = 0; n25 < n2; ++n25) {
                        nArray3[n24--] = 255;
                    }
                }
                writableRaster2.setPixels(n6 + n3, i8 + n4, n5, 1, nArray3);
            }
        } else {
            Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            for (int i9 = 0; i9 < n2; ++i9) {
                GraphicsUtil.copyBand(writableRaster, rectangle, i9, writableRaster2, rectangle2, i9);
            }
        }
    }

    public static void copyBand(Raster raster, int n2, WritableRaster writableRaster, int n3) {
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        GraphicsUtil.copyBand(raster, rectangle3, n2, writableRaster, rectangle3, n3);
    }

    public static void copyBand(Raster raster, Rectangle rectangle, int n2, WritableRaster writableRaster, Rectangle rectangle2, int n3) {
        int n4 = rectangle2.y - rectangle.y;
        int n5 = rectangle2.x - rectangle.x;
        rectangle = rectangle.intersection(raster.getBounds());
        rectangle2 = rectangle2.intersection(writableRaster.getBounds());
        int n6 = rectangle2.width < rectangle.width ? rectangle2.width : rectangle.width;
        int n7 = rectangle2.height < rectangle.height ? rectangle2.height : rectangle.height;
        int n8 = rectangle.x + n5;
        int[] nArray = null;
        for (int i2 = rectangle.y; i2 < rectangle.y + n7; ++i2) {
            nArray = raster.getSamples(rectangle.x, i2, n6, 1, n2, nArray);
            writableRaster.setSamples(n8, i2 + n4, n6, 1, n3, nArray);
        }
    }

    public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl2) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length == 3 ? bl2 : nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n5;
            int n6 = n5 + n2;
            for (n5 = n4 + i2 * n3; n5 < n6; ++n5) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                if (n8 <= 0) {
                    nArray[n5] = 0xFFFFFF;
                    continue;
                }
                if (n8 >= 255) continue;
                int n9 = 0xFF0000 / n8;
                nArray[n5] = n8 << 24 | ((n7 & 0xFF0000) >> 16) * n9 & 0xFF0000 | (((n7 & 0xFF00) >> 8) * n9 & 0xFF0000) >> 8 | ((n7 & 0xFF) * n9 & 0xFF0000) >> 16;
            }
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n5;
            int n6 = n5 + n2;
            for (n5 = n4 + i2 * n3; n5 < n6; ++n5) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                if (n8 < 0 || n8 >= 255) continue;
                nArray[n5] = n8 << 24 | (n7 & 0xFF0000) * n8 >> 8 & 0xFF0000 | (n7 & 0xFF00) * n8 >> 8 & 0xFF00 | (n7 & 0xFF) * n8 >> 8 & 0xFF;
            }
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n8;
            int n9 = n8 + n2 * n4;
            for (n8 = n5 + i2 * n3; n8 < n9; n8 += n4) {
                int n10;
                int n11 = byArray[n8 + n6] & 0xFF;
                if (n11 == 0) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        byArray[n8 + nArray[n10]] = -1;
                    }
                    continue;
                }
                if (n11 >= 255) continue;
                n10 = 0xFF0000 / n11;
                for (int i3 = 0; i3 < n7; ++i3) {
                    int n12 = n8 + nArray[i3];
                    byArray[n12] = (byte)((byArray[n12] & 0xFF) * n10 >>> 16);
                }
            }
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = componentSampleModel.getScanlineStride();
        int n4 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n8;
            int n9 = n8 + n2 * n4;
            for (n8 = n5 + i2 * n3; n8 < n9; n8 += n4) {
                int n10 = byArray[n8 + n6] & 0xFF;
                if (n10 == 255) continue;
                for (int i3 = 0; i3 < n7; ++i3) {
                    int n11 = n8 + nArray[i3];
                    byArray[n11] = (byte)((byArray[n11] & 0xFF) * n10 >> 8);
                }
            }
        }
    }

    public static Raster getAlphaRaster(RenderedImage renderedImage) {
        WritableRaster writableRaster;
        ColorModel colorModel = renderedImage.getColorModel();
        if (!colorModel.hasAlpha() || colorModel.getTransparency() != 3) {
            throw new IllegalStateException("Image doesn't have an alpha channel");
        }
        if (renderedImage instanceof BufferedImage) {
            writableRaster = ((BufferedImage)renderedImage).getAlphaRaster();
        } else {
            WritableRaster writableRaster2 = GraphicsUtil.makeRasterWritable(renderedImage.getData());
            writableRaster = renderedImage.getColorModel().getAlphaRaster(writableRaster2);
        }
        return writableRaster;
    }
}

