/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.ObjectFactory;
import org.apache.xml.utils.WrappedRuntimeException;

public class ObjectPool
implements Serializable {
    static final long serialVersionUID = -8519013691660936643L;
    private final Class objectType;
    private final ArrayList freeStack;

    public ObjectPool(Class clazz) {
        this.objectType = clazz;
        this.freeStack = new ArrayList();
    }

    public ObjectPool(String string) {
        try {
            this.objectType = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
        this.freeStack = new ArrayList();
    }

    public ObjectPool(Class clazz, int n2) {
        this.objectType = clazz;
        this.freeStack = new ArrayList(n2);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new ArrayList();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object e2 = this.freeStack.remove(this.freeStack.size() - 1);
            return e2;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_EXCEPTION_CREATING_POOL", null));
        }
        Object e2 = this.freeStack.remove(this.freeStack.size() - 1);
        return e2;
    }

    public synchronized void freeInstance(Object object) {
        this.freeStack.add(object);
    }
}

