/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xml.utils.SecuritySupport;

final class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xalan.properties";
    private static final String SERVICES_PATH = "META-INF/services/";
    private static final boolean DEBUG = false;
    private static Properties fXalanProperties = null;
    private static long fLastModified = -1L;
    static Class class$org$apache$xml$utils$ObjectFactory;

    ObjectFactory() {
    }

    static Object createObject(String string, String string2) {
        return ObjectFactory.createObject(string, null, string2);
    }

    static Object createObject(String string, String string2, String string3) {
        Class clazz = ObjectFactory.lookUpFactoryClass(string, string2, string3);
        if (clazz == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        try {
            Object t2 = clazz.newInstance();
            ObjectFactory.debugPrintln("created new instance of factory " + string);
            return t2;
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider for factory " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Class lookUpFactoryClass(String string) {
        return ObjectFactory.lookUpFactoryClass(string, null, null);
    }

    static Class lookUpFactoryClass(String string, String string2, String string3) {
        String string4 = ObjectFactory.lookUpFactoryClassName(string, string2, string3);
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        if (string4 == null) {
            string4 = string3;
        }
        try {
            Class clazz = ObjectFactory.findProviderClass(string4, classLoader, true);
            ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string4 + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string4 + " could not be instantiated: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String lookUpFactoryClassName(String string, String string2, String string3) {
        String string4;
        try {
            string4 = SecuritySupport.getSystemProperty(string);
            if (string4 != null) {
                ObjectFactory.debugPrintln("found system property, value=" + string4);
                return string4;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string4 = null;
        if (string2 == null) {
            Object object;
            File file = null;
            boolean bl2 = false;
            try {
                object = SecuritySupport.getSystemProperty("java.home");
                string2 = (String)object + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                file = new File(string2);
                bl2 = SecuritySupport.getFileExists(file);
            }
            catch (SecurityException securityException) {
                fLastModified = -1L;
                fXalanProperties = null;
            }
            object = class$org$apache$xml$utils$ObjectFactory == null ? (class$org$apache$xml$utils$ObjectFactory = ObjectFactory.class$("org.apache.xml.utils.ObjectFactory")) : class$org$apache$xml$utils$ObjectFactory;
            synchronized (object) {
                boolean bl3 = false;
                FileInputStream fileInputStream = null;
                try {
                    if (fLastModified >= 0L) {
                        if (bl2 && fLastModified < (fLastModified = SecuritySupport.getLastModified(file))) {
                            bl3 = true;
                        } else if (!bl2) {
                            fLastModified = -1L;
                            fXalanProperties = null;
                        }
                    } else if (bl2) {
                        bl3 = true;
                        fLastModified = SecuritySupport.getLastModified(file);
                    }
                    if (bl3) {
                        fXalanProperties = new Properties();
                        fileInputStream = SecuritySupport.getFileInputStream(file);
                        fXalanProperties.load(fileInputStream);
                    }
                }
                catch (Exception exception) {
                    fXalanProperties = null;
                    fLastModified = -1L;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (fXalanProperties != null) {
                string4 = fXalanProperties.getProperty(string);
            }
        } else {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = SecuritySupport.getFileInputStream(new File(string2));
                Properties properties = new Properties();
                properties.load(fileInputStream);
                string4 = properties.getProperty(string);
            }
            catch (Exception exception) {
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (string4 != null) {
            ObjectFactory.debugPrintln("found in " + string2 + ", value=" + string4);
            return string4;
        }
        return ObjectFactory.findJarServiceProviderName(string);
    }

    private static void debugPrintln(String string) {
    }

    static ClassLoader findClassLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = SecuritySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = SecuritySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                ClassLoader classLoader4 = (class$org$apache$xml$utils$ObjectFactory == null ? (class$org$apache$xml$utils$ObjectFactory = ObjectFactory.class$("org.apache.xml.utils.ObjectFactory")) : class$org$apache$xml$utils$ObjectFactory).getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl2) {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl2);
            Object t2 = clazz.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return t2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Class findProviderClass(String string, ClassLoader classLoader, boolean bl2) {
        Class<?> clazz;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n2 = string.lastIndexOf(46);
            String string2 = string;
            if (n2 != -1) {
                string2 = string.substring(0, n2);
            }
            securityManager.checkPackageAccess(string2);
        }
        if (classLoader == null) {
            clazz = Class.forName(string);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl2) {
                    ClassLoader classLoader2 = (class$org$apache$xml$utils$ObjectFactory == null ? (class$org$apache$xml$utils$ObjectFactory = ObjectFactory.class$("org.apache.xml.utils.ObjectFactory")) : class$org$apache$xml$utils$ObjectFactory).getClassLoader();
                    if (classLoader2 == null) {
                        clazz = Class.forName(string);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findJarServiceProviderName(String string) {
        Object object;
        String string2 = SERVICES_PATH + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null && classLoader != (object = (class$org$apache$xml$utils$ObjectFactory == null ? (class$org$apache$xml$utils$ObjectFactory = ObjectFactory.class$("org.apache.xml.utils.ObjectFactory")) : class$org$apache$xml$utils$ObjectFactory).getClassLoader())) {
            classLoader = object;
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            String string4 = null;
            return string4;
        }
        finally {
            try {
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
        }
        if (string3 != null && !"".equals(string3)) {
            ObjectFactory.debugPrintln("found in resource, value=" + string3);
            return string3;
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ConfigurationError
    extends Error {
        static final long serialVersionUID = 2036619216663421552L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

