/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;

public class NodeVector
implements Serializable,
Cloneable {
    static final long serialVersionUID = -713473092200731870L;
    private int m_blocksize;
    private int[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = 0;
    }

    public Object clone() {
        NodeVector nodeVector = (NodeVector)super.clone();
        if (null != this.m_map && this.m_map == nodeVector.m_map) {
            nodeVector.m_map = new int[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeVector.m_map, 0, this.m_map.length);
        }
        return nodeVector;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void addElement(int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[this.m_firstFree] = n2;
        ++this.m_firstFree;
    }

    public final void push(int n2) {
        int n3 = this.m_firstFree;
        if (n3 + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, n3 + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[n3] = n2;
        this.m_firstFree = ++n3;
    }

    public final int pop() {
        --this.m_firstFree;
        int n2 = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = -1;
        return n2;
    }

    public final int popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
        return this.m_firstFree == 0 ? -1 : this.m_map[this.m_firstFree - 1];
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
    }

    public final int peepOrNull() {
        return null != this.m_map && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : -1;
    }

    public final void pushPair(int n2, int n3) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n2;
        this.m_map[this.m_firstFree + 1] = n3;
        this.m_firstFree += 2;
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = -1;
        this.m_map[this.m_firstFree + 1] = -1;
    }

    public final void setTail(int n2) {
        this.m_map[this.m_firstFree - 1] = n2;
    }

    public final void setTailSub1(int n2) {
        this.m_map[this.m_firstFree - 2] = n2;
    }

    public final int peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final int peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public void insertInOrder(int n2) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (n2 >= this.m_map[i2]) continue;
            this.insertElementAt(n2, i2);
            return;
        }
        this.addElement(n2);
    }

    public void insertElementAt(int n2, int n3) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n3 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n3, this.m_map, n3 + 1, this.m_firstFree - n3);
        }
        this.m_map[n3] = n2;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodeVector) {
        int n2 = nodeVector.size();
        if (null == this.m_map) {
            this.m_mapSize = n2 + this.m_blocksize;
            this.m_map = new int[this.m_mapSize];
        } else if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += n2 + this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + n2);
            this.m_map = nArray;
        }
        System.arraycopy(nodeVector.m_map, 0, this.m_map, this.m_firstFree, n2);
        this.m_firstFree += n2;
    }

    public void removeAllElements() {
        if (null == this.m_map) {
            return;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            this.m_map[i2] = -1;
        }
        this.m_firstFree = 0;
    }

    public void RemoveAllNoClear() {
        if (null == this.m_map) {
            return;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(int n2) {
        if (null == this.m_map) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            int n3 = this.m_map[i2];
            if (n3 != n2) continue;
            if (i2 > this.m_firstFree) {
                System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
            } else {
                this.m_map[i2] = -1;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public void removeElementAt(int n2) {
        if (null == this.m_map) {
            return;
        }
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2 - 1, this.m_firstFree - n2);
        } else {
            this.m_map[n2] = -1;
        }
    }

    public void setElementAt(int n2, int n3) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        if (n3 == -1) {
            this.addElement(n2);
        }
        this.m_map[n3] = n2;
    }

    public int elementAt(int n2) {
        if (null == this.m_map) {
            return -1;
        }
        return this.m_map[n2];
    }

    public boolean contains(int n2) {
        if (null == this.m_map) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            int n3 = this.m_map[i2];
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int n2, int n3) {
        if (null == this.m_map) {
            return -1;
        }
        for (int i2 = n3; i2 < this.m_firstFree; ++i2) {
            int n4 = this.m_map[i2];
            if (n4 != n2) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(int n2) {
        if (null == this.m_map) {
            return -1;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            int n3 = this.m_map[i2];
            if (n3 != n2) continue;
            return i2;
        }
        return -1;
    }

    public void sort(int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n4 >= n5) {
            return;
        }
        if (n4 == n5 - 1) {
            if (nArray[n4] > nArray[n5]) {
                int n6 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n6;
            }
            return;
        }
        int n7 = n4 + n5 >>> 1;
        int n8 = nArray[n7];
        nArray[n7] = nArray[n5];
        nArray[n5] = n8;
        while (n4 < n5) {
            while (nArray[n4] <= n8 && n4 < n5) {
                ++n4;
            }
            while (n8 <= nArray[n5] && n4 < n5) {
                --n5;
            }
            if (n4 >= n5) continue;
            int n9 = nArray[n4];
            nArray[n4] = nArray[n5];
            nArray[n5] = n9;
        }
        nArray[n3] = nArray[n5];
        nArray[n5] = n8;
        this.sort(nArray, n2, n4 - 1);
        this.sort(nArray, n5 + 1, n3);
    }

    public void sort() {
        this.sort(this.m_map, 0, this.m_firstFree - 1);
    }
}

