/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class IntVector
implements Cloneable {
    protected int m_blocksize;
    protected int[] m_map;
    protected int m_firstFree = 0;
    protected int m_mapSize;

    public IntVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new int[this.m_blocksize];
    }

    public IntVector(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new int[n2];
    }

    public IntVector(int n2, int n3) {
        this.m_blocksize = n3;
        this.m_mapSize = n2;
        this.m_map = new int[n2];
    }

    public IntVector(IntVector intVector) {
        this.m_map = new int[intVector.m_mapSize];
        this.m_mapSize = intVector.m_mapSize;
        this.m_firstFree = intVector.m_firstFree;
        this.m_blocksize = intVector.m_blocksize;
        System.arraycopy(intVector.m_map, 0, this.m_map, 0, this.m_firstFree);
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void setSize(int n2) {
        this.m_firstFree = n2;
    }

    public final void addElement(int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n2;
        ++this.m_firstFree;
    }

    public final void addElements(int n2, int n3) {
        if (this.m_firstFree + n3 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n3;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.m_map[this.m_firstFree] = n2;
            ++this.m_firstFree;
        }
    }

    public final void addElements(int n2) {
        if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n2;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        this.m_firstFree += n2;
    }

    public final void insertElementAt(int n2, int n3) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n3 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n3, this.m_map, n3 + 1, this.m_firstFree - n3);
        }
        this.m_map[n3] = n2;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            this.m_map[i2] = Integer.MIN_VALUE;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(int n2) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != n2) continue;
            if (i2 + 1 < this.m_firstFree) {
                System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
            } else {
                this.m_map[i2] = Integer.MIN_VALUE;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int n2) {
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2, this.m_firstFree);
        } else {
            this.m_map[n2] = Integer.MIN_VALUE;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(int n2, int n3) {
        this.m_map[n3] = n2;
    }

    public final int elementAt(int n2) {
        return this.m_map[n2];
    }

    public final boolean contains(int n2) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(int n2, int n3) {
        for (int i2 = n3; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != n2) continue;
            return i2;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(int n2) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != n2) continue;
            return i2;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(int n2) {
        for (int i2 = this.m_firstFree - 1; i2 >= 0; --i2) {
            if (this.m_map[i2] != n2) continue;
            return i2;
        }
        return Integer.MIN_VALUE;
    }

    public Object clone() {
        return new IntVector(this);
    }
}

