/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorListener,
ErrorHandler {
    PrintWriter m_pw;
    boolean m_throwExceptionOnError = true;

    public DefaultErrorHandler(PrintWriter printWriter) {
        this.m_pw = printWriter;
    }

    public DefaultErrorHandler(PrintStream printStream) {
        this.m_pw = new PrintWriter(printStream, true);
    }

    public DefaultErrorHandler() {
        this(true);
    }

    public DefaultErrorHandler(boolean bl2) {
        this.m_throwExceptionOnError = bl2;
    }

    public PrintWriter getErrorWriter() {
        if (this.m_pw == null) {
            this.m_pw = new PrintWriter(System.err, true);
        }
        return this.m_pw;
    }

    public void warning(SAXParseException sAXParseException) {
        PrintWriter printWriter = this.getErrorWriter();
        DefaultErrorHandler.printLocation(printWriter, (Throwable)sAXParseException);
        printWriter.println("Parser warning: " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) {
        throw sAXParseException;
    }

    public void warning(TransformerException transformerException) {
        PrintWriter printWriter = this.getErrorWriter();
        DefaultErrorHandler.printLocation(printWriter, (Throwable)transformerException);
        printWriter.println(transformerException.getMessage());
    }

    public void error(TransformerException transformerException) {
        if (this.m_throwExceptionOnError) {
            throw transformerException;
        }
        PrintWriter printWriter = this.getErrorWriter();
        DefaultErrorHandler.printLocation(printWriter, (Throwable)transformerException);
        printWriter.println(transformerException.getMessage());
    }

    public void fatalError(TransformerException transformerException) {
        if (this.m_throwExceptionOnError) {
            throw transformerException;
        }
        PrintWriter printWriter = this.getErrorWriter();
        DefaultErrorHandler.printLocation(printWriter, (Throwable)transformerException);
        printWriter.println(transformerException.getMessage());
    }

    public static void ensureLocationSet(TransformerException transformerException) {
        SourceLocator sourceLocator = null;
        Throwable throwable = transformerException;
        do {
            SourceLocator sourceLocator2;
            if (throwable instanceof SAXParseException) {
                sourceLocator = new SAXSourceLocator((SAXParseException)throwable);
                continue;
            }
            if (!(throwable instanceof TransformerException) || null == (sourceLocator2 = throwable.getLocator())) continue;
            sourceLocator = sourceLocator2;
        } while (null != (throwable = throwable instanceof TransformerException ? throwable.getCause() : (throwable instanceof SAXException ? ((SAXException)throwable).getException() : null)));
        transformerException.setLocator(sourceLocator);
    }

    public static void printLocation(PrintStream printStream, TransformerException transformerException) {
        DefaultErrorHandler.printLocation(new PrintWriter(printStream), (Throwable)transformerException);
    }

    public static void printLocation(PrintStream printStream, SAXParseException sAXParseException) {
        DefaultErrorHandler.printLocation(new PrintWriter(printStream), (Throwable)sAXParseException);
    }

    public static void printLocation(PrintWriter printWriter, Throwable throwable) {
        Object object;
        SourceLocator sourceLocator = null;
        Throwable throwable2 = throwable;
        do {
            if (throwable2 instanceof SAXParseException) {
                sourceLocator = new SAXSourceLocator((SAXParseException)throwable2);
                continue;
            }
            if (!(throwable2 instanceof TransformerException) || null == (object = ((TransformerException)throwable2).getLocator())) continue;
            sourceLocator = object;
        } while (null != (throwable2 = throwable2 instanceof TransformerException ? ((TransformerException)throwable2).getCause() : (throwable2 instanceof WrappedRuntimeException ? ((WrappedRuntimeException)throwable2).getException() : (throwable2 instanceof SAXException ? ((SAXException)throwable2).getException() : null))));
        if (null != sourceLocator) {
            object = null != sourceLocator.getPublicId() ? sourceLocator.getPublicId() : (null != sourceLocator.getSystemId() ? sourceLocator.getSystemId() : XMLMessages.createXMLMessage("ER_SYSTEMID_UNKNOWN", null));
            printWriter.print((String)object + "; " + XMLMessages.createXMLMessage("line", null) + sourceLocator.getLineNumber() + "; " + XMLMessages.createXMLMessage("column", null) + sourceLocator.getColumnNumber() + "; ");
        } else {
            printWriter.print("(" + XMLMessages.createXMLMessage("ER_LOCATION_UNKNOWN", null) + ")");
        }
    }
}

