/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer.utils;

public final class StringToIntTable {
    public static final int INVALID_KEY = -10000;
    private int m_blocksize;
    private String[] m_map;
    private int[] m_values;
    private int m_firstFree = 0;
    private int m_mapSize;

    public StringToIntTable() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new String[this.m_blocksize];
        this.m_values = new int[this.m_blocksize];
    }

    public StringToIntTable(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new String[n2];
        this.m_values = new int[this.m_blocksize];
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final void put(String string, int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            String[] stringArray = new String[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringArray, 0, this.m_firstFree + 1);
            this.m_map = stringArray;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_values, 0, nArray, 0, this.m_firstFree + 1);
            this.m_values = nArray;
        }
        this.m_map[this.m_firstFree] = string;
        this.m_values[this.m_firstFree] = n2;
        ++this.m_firstFree;
    }

    public final int get(String string) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (!this.m_map[i2].equals(string)) continue;
            return this.m_values[i2];
        }
        return -10000;
    }

    public final int getIgnoreCase(String string) {
        if (null == string) {
            return -10000;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (!this.m_map[i2].equalsIgnoreCase(string)) continue;
            return this.m_values[i2];
        }
        return -10000;
    }

    public final boolean contains(String string) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (!this.m_map[i2].equals(string)) continue;
            return true;
        }
        return false;
    }

    public final String[] keys() {
        String[] stringArray = new String[this.m_firstFree];
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            stringArray[i2] = this.m_map[i2];
        }
        return stringArray;
    }
}

