/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer.dom3;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NamespaceSupport {
    static final String PREFIX_XML = "xml".intern();
    static final String PREFIX_XMLNS = "xmlns".intern();
    public static final String XML_URI = "http://www.w3.org/XML/1998/namespace".intern();
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/".intern();
    protected String[] fNamespace = new String[32];
    protected int fNamespaceSize;
    protected int[] fContext = new int[8];
    protected int fCurrentContext;
    protected String[] fPrefixes = new String[16];

    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = this.fNamespaceSize;
        this.fNamespace[this.fNamespaceSize++] = PREFIX_XML;
        this.fNamespace[this.fNamespaceSize++] = XML_URI;
        this.fNamespace[this.fNamespaceSize++] = PREFIX_XMLNS;
        this.fNamespace[this.fNamespaceSize++] = XMLNS_URI;
        ++this.fCurrentContext;
    }

    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] nArray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, nArray, 0, this.fContext.length);
            this.fContext = nArray;
        }
        this.fContext[++this.fCurrentContext] = this.fNamespaceSize;
    }

    public void popContext() {
        this.fNamespaceSize = this.fContext[this.fCurrentContext--];
    }

    public boolean declarePrefix(String string, String string2) {
        if (string == PREFIX_XML || string == PREFIX_XMLNS) {
            return false;
        }
        for (int i2 = this.fNamespaceSize; i2 > this.fContext[this.fCurrentContext]; i2 -= 2) {
            if (!this.fNamespace[i2 - 2].equals(string)) continue;
            this.fNamespace[i2 - 1] = string2;
            return true;
        }
        if (this.fNamespaceSize == this.fNamespace.length) {
            String[] stringArray = new String[this.fNamespaceSize * 2];
            System.arraycopy(this.fNamespace, 0, stringArray, 0, this.fNamespaceSize);
            this.fNamespace = stringArray;
        }
        this.fNamespace[this.fNamespaceSize++] = string;
        this.fNamespace[this.fNamespaceSize++] = string2;
        return true;
    }

    public String getURI(String string) {
        for (int i2 = this.fNamespaceSize; i2 > 0; i2 -= 2) {
            if (!this.fNamespace[i2 - 2].equals(string)) continue;
            return this.fNamespace[i2 - 1];
        }
        return null;
    }

    public String getPrefix(String string) {
        for (int i2 = this.fNamespaceSize; i2 > 0; i2 -= 2) {
            if (!this.fNamespace[i2 - 1].equals(string) || !this.getURI(this.fNamespace[i2 - 2]).equals(string)) continue;
            return this.fNamespace[i2 - 2];
        }
        return null;
    }

    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    public String getDeclaredPrefixAt(int n2) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + n2 * 2];
    }

    public Enumeration getAllPrefixes() {
        Object object;
        int n2 = 0;
        if (this.fPrefixes.length < this.fNamespace.length / 2) {
            object = new String[this.fNamespaceSize];
            this.fPrefixes = object;
        }
        object = null;
        boolean bl2 = true;
        for (int i2 = 2; i2 < this.fNamespaceSize - 2; i2 += 2) {
            object = this.fNamespace[i2 + 2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if (this.fPrefixes[i3] != object) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                this.fPrefixes[n2++] = object;
            }
            bl2 = true;
        }
        return new Prefixes(this, this.fPrefixes, n2);
    }

    protected final class Prefixes
    implements Enumeration {
        private String[] prefixes;
        private int counter;
        private int size;
        private final NamespaceSupport this$0;

        public Prefixes(NamespaceSupport namespaceSupport, String[] stringArray, int n2) {
            this.this$0 = namespaceSupport;
            this.counter = 0;
            this.size = 0;
            this.prefixes = stringArray;
            this.size = n2;
        }

        public boolean hasMoreElements() {
            return this.counter < this.size;
        }

        public Object nextElement() {
            if (this.counter < this.size) {
                return this.this$0.fPrefixes[this.counter++];
            }
            throw new NoSuchElementException("Illegal access to Namespace prefixes enumeration.");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.size; ++i2) {
                stringBuffer.append(this.prefixes[i2]);
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
    }
}

