/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToTextStream
extends ToStream {
    protected void startDocumentInternal() {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void endDocument() {
        this.flushPending();
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
    }

    public void characters(char[] cArray, int n2, int n3) {
        this.flushPending();
        try {
            if (this.inTemporaryOutputState()) {
                this.m_writer.write(cArray, n2, n3);
            } else {
                this.writeNormalizedChars(cArray, n2, n3, this.m_lineSepUse);
            }
            if (this.m_tracer != null) {
                super.fireCharEvent(cArray, n2, n3);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void charactersRaw(char[] cArray, int n2, int n3) {
        try {
            this.writeNormalizedChars(cArray, n2, n3, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    void writeNormalizedChars(char[] cArray, int n2, int n3, boolean bl2) {
        String string = this.getEncoding();
        Writer writer = this.m_writer;
        int n4 = n2 + n3;
        int n5 = 10;
        for (int i2 = n2; i2 < n4; ++i2) {
            String string2;
            char c2 = cArray[i2];
            if ('\n' == c2 && bl2) {
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                continue;
            }
            if (this.m_encodingInfo.isInEncoding(c2)) {
                writer.write(c2);
                continue;
            }
            if (Encodings.isHighUTF16Surrogate(c2)) {
                int n6 = this.writeUTF16Surrogate(c2, cArray, i2, n4);
                if (n6 != 0) {
                    string2 = Integer.toString(n6);
                    String string3 = Utils.messages.createMessage("ER_ILLEGAL_CHARACTER", new Object[]{string2, string});
                    System.err.println(string3);
                }
                ++i2;
                continue;
            }
            if (string != null) {
                writer.write(38);
                writer.write(35);
                writer.write(Integer.toString(c2));
                writer.write(59);
                String string4 = Integer.toString(c2);
                string2 = Utils.messages.createMessage("ER_ILLEGAL_CHARACTER", new Object[]{string4, string});
                System.err.println(string2);
                continue;
            }
            writer.write(c2);
        }
    }

    public void cdata(char[] cArray, int n2, int n3) {
        try {
            this.writeNormalizedChars(cArray, n2, n3, this.m_lineSepUse);
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n2, n3);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        try {
            this.writeNormalizedChars(cArray, n2, n3, this.m_lineSepUse);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public void comment(String string) {
        int n2 = string.length();
        if (n2 > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n2);
    }

    public void comment(char[] cArray, int n2, int n3) {
        this.flushPending();
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n2, n3);
        }
    }

    public void entityReference(String string) {
        if (this.m_tracer != null) {
            super.fireEntityReference(string);
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl2) {
    }

    public void endCDATA() {
    }

    public void endElement(String string) {
        if (this.m_tracer != null) {
            super.fireEndElem(string);
        }
    }

    public void startElement(String string, String string2, String string3) {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_tracer != null) {
            super.fireStartElem(string3);
            this.firePseudoAttributes();
        }
    }

    public void characters(String string) {
        int n2 = string.length();
        if (n2 > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, n2);
    }

    public void addAttribute(String string, String string2) {
    }

    public void addUniqueAttribute(String string, String string2, int n2) {
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl2) {
        return false;
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void namespaceAfterStartElement(String string, String string2) {
    }

    public void flushPending() {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
    }
}

