/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.utils.SystemIDResolver;
import org.apache.xml.serializer.utils.Utils;
import org.apache.xml.serializer.utils.WrappedRuntimeException;

final class CharInfo {
    private HashMap m_charToString;
    public static final String HTML_ENTITIES_RESOURCE = SerializerBase.PKG_NAME + ".HTMLEntities";
    public static final String XML_ENTITIES_RESOURCE = SerializerBase.PKG_NAME + ".XMLEntities";
    static final char S_HORIZONAL_TAB = '\t';
    static final char S_LINEFEED = '\n';
    static final char S_CARRIAGERETURN = '\r';
    static final char S_SPACE = ' ';
    static final char S_QUOTE = '\"';
    static final char S_LT = '<';
    static final char S_GT = '>';
    static final char S_NEL = '\u0085';
    static final char S_LINE_SEPARATOR = '\u2028';
    boolean onlyQuotAmpLtGt = true;
    static final int ASCII_MAX = 128;
    private final boolean[] shouldMapAttrChar_ASCII;
    private final boolean[] shouldMapTextChar_ASCII;
    private final int[] array_of_bits = this.createEmptySetOfIntegers(65535);
    private static final int SHIFT_PER_WORD = 5;
    private static final int LOW_ORDER_BITMASK = 31;
    private int firstWordNotUsed = 0;
    private final CharKey m_charKey;
    private static Hashtable m_getCharInfoCache = new Hashtable();
    static Class class$org$apache$xml$serializer$CharInfo;

    private CharInfo() {
        this.shouldMapAttrChar_ASCII = new boolean[128];
        this.shouldMapTextChar_ASCII = new boolean[128];
        this.m_charKey = new CharKey();
    }

    private CharInfo(String string, String string2, boolean bl2) {
        this();
        this.m_charToString = new HashMap();
        ResourceBundle resourceBundle = null;
        boolean bl3 = true;
        if (bl2) {
            try {
                resourceBundle = PropertyResourceBundle.getBundle(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle != null) {
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3;
                int n2;
                String string4 = enumeration.nextElement();
                boolean bl4 = this.defineEntity(string4, (char)(n2 = Integer.parseInt(string3 = resourceBundle.getString(string4))));
                if (!bl4) continue;
                bl3 = false;
            }
        } else {
            InputStream inputStream = null;
            try {
                Object object;
                Object object2;
                if (bl2) {
                    inputStream = (class$org$apache$xml$serializer$CharInfo == null ? (class$org$apache$xml$serializer$CharInfo = CharInfo.class$("org.apache.xml.serializer.CharInfo")) : class$org$apache$xml$serializer$CharInfo).getResourceAsStream(string);
                } else {
                    object2 = ObjectFactory.findClassLoader();
                    inputStream = object2 == null ? ClassLoader.getSystemResourceAsStream(string) : ((ClassLoader)object2).getResourceAsStream(string);
                    if (inputStream == null) {
                        try {
                            object = new URL(string);
                            inputStream = ((URL)object).openStream();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (inputStream == null) {
                    throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_FIND", new Object[]{string, string}));
                }
                try {
                    object2 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = new BufferedReader(new InputStreamReader(inputStream));
                }
                object = ((BufferedReader)object2).readLine();
                while (object != null) {
                    if (((String)object).length() == 0 || ((String)object).charAt(0) == '#') {
                        object = ((BufferedReader)object2).readLine();
                        continue;
                    }
                    int n3 = ((String)object).indexOf(32);
                    if (n3 > 1) {
                        String string5 = ((String)object).substring(0, n3);
                        if (++n3 < ((String)object).length()) {
                            int n4;
                            boolean bl5;
                            String string6 = ((String)object).substring(n3);
                            if ((n3 = string6.indexOf(32)) > 0) {
                                string6 = string6.substring(0, n3);
                            }
                            if (bl5 = this.defineEntity(string5, (char)(n4 = Integer.parseInt(string6)))) {
                                bl3 = false;
                            }
                        }
                    }
                    object = ((BufferedReader)object2).readLine();
                }
                inputStream.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(Utils.messages.createMessage("ER_RESOURCE_COULD_NOT_LOAD", new Object[]{string, exception.toString(), string, exception.toString()}));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.onlyQuotAmpLtGt = bl3;
        if ("xml".equals(string2)) {
            this.shouldMapTextChar_ASCII[34] = false;
        }
        if ("html".equals(string2)) {
            this.shouldMapAttrChar_ASCII[60] = false;
            this.shouldMapTextChar_ASCII[34] = false;
        }
    }

    private boolean defineEntity(String string, char c2) {
        StringBuffer stringBuffer = new StringBuffer("&");
        stringBuffer.append(string);
        stringBuffer.append(';');
        String string2 = stringBuffer.toString();
        boolean bl2 = this.defineChar2StringMapping(string2, c2);
        return bl2;
    }

    String getOutputStringForChar(char c2) {
        this.m_charKey.setChar(c2);
        return (String)this.m_charToString.get(this.m_charKey);
    }

    final boolean shouldMapAttrChar(int n2) {
        if (n2 < 128) {
            return this.shouldMapAttrChar_ASCII[n2];
        }
        return this.get(n2);
    }

    final boolean shouldMapTextChar(int n2) {
        if (n2 < 128) {
            return this.shouldMapTextChar_ASCII[n2];
        }
        return this.get(n2);
    }

    private static CharInfo getCharInfoBasedOnPrivilege(String string, String string2, boolean bl2) {
        return (CharInfo)AccessController.doPrivileged(new PrivilegedAction(string, string2, bl2){
            private final String val$entitiesFileName;
            private final String val$method;
            private final boolean val$internal;
            {
                this.val$entitiesFileName = string;
                this.val$method = string2;
                this.val$internal = bl2;
            }

            public Object run() {
                return new CharInfo(this.val$entitiesFileName, this.val$method, this.val$internal, null);
            }
        });
    }

    static CharInfo getCharInfo(String string, String string2) {
        CharInfo charInfo = (CharInfo)m_getCharInfoCache.get(string);
        if (charInfo != null) {
            return CharInfo.mutableCopyOf(charInfo);
        }
        try {
            charInfo = CharInfo.getCharInfoBasedOnPrivilege(string, string2, true);
            m_getCharInfoCache.put(string, charInfo);
            return CharInfo.mutableCopyOf(charInfo);
        }
        catch (Exception exception) {
            try {
                return CharInfo.getCharInfoBasedOnPrivilege(string, string2, false);
            }
            catch (Exception exception2) {
                if (string.indexOf(58) < 0) {
                    String string3 = SystemIDResolver.getAbsoluteURIFromRelative(string);
                } else {
                    try {
                        String string4 = SystemIDResolver.getAbsoluteURI(string, null);
                    }
                    catch (TransformerException transformerException) {
                        throw new WrappedRuntimeException(transformerException);
                    }
                }
                return CharInfo.getCharInfoBasedOnPrivilege(string, string2, false);
            }
        }
    }

    private static CharInfo mutableCopyOf(CharInfo charInfo) {
        CharInfo charInfo2 = new CharInfo();
        int n2 = charInfo.array_of_bits.length;
        System.arraycopy(charInfo.array_of_bits, 0, charInfo2.array_of_bits, 0, n2);
        charInfo2.firstWordNotUsed = charInfo.firstWordNotUsed;
        n2 = charInfo.shouldMapAttrChar_ASCII.length;
        System.arraycopy(charInfo.shouldMapAttrChar_ASCII, 0, charInfo2.shouldMapAttrChar_ASCII, 0, n2);
        n2 = charInfo.shouldMapTextChar_ASCII.length;
        System.arraycopy(charInfo.shouldMapTextChar_ASCII, 0, charInfo2.shouldMapTextChar_ASCII, 0, n2);
        charInfo2.m_charToString = (HashMap)charInfo.m_charToString.clone();
        charInfo2.onlyQuotAmpLtGt = charInfo.onlyQuotAmpLtGt;
        return charInfo2;
    }

    private static int arrayIndex(int n2) {
        return n2 >> 5;
    }

    private static int bit(int n2) {
        int n3 = 1 << (n2 & 0x1F);
        return n3;
    }

    private int[] createEmptySetOfIntegers(int n2) {
        this.firstWordNotUsed = 0;
        int[] nArray = new int[CharInfo.arrayIndex(n2 - 1) + 1];
        return nArray;
    }

    private final void set(int n2) {
        this.setASCIItextDirty(n2);
        this.setASCIIattrDirty(n2);
        int n3 = n2 >> 5;
        int n4 = n3 + 1;
        if (this.firstWordNotUsed < n4) {
            this.firstWordNotUsed = n4;
        }
        int n5 = n3;
        this.array_of_bits[n5] = this.array_of_bits[n5] | 1 << (n2 & 0x1F);
    }

    private final boolean get(int n2) {
        boolean bl2 = false;
        int n3 = n2 >> 5;
        if (n3 < this.firstWordNotUsed) {
            bl2 = (this.array_of_bits[n3] & 1 << (n2 & 0x1F)) != 0;
        }
        return bl2;
    }

    private boolean extraEntity(String string, int n2) {
        boolean bl2 = false;
        if (n2 < 128) {
            switch (n2) {
                case 34: {
                    if (string.equals("&quot;")) break;
                    bl2 = true;
                    break;
                }
                case 38: {
                    if (string.equals("&amp;")) break;
                    bl2 = true;
                    break;
                }
                case 60: {
                    if (string.equals("&lt;")) break;
                    bl2 = true;
                    break;
                }
                case 62: {
                    if (string.equals("&gt;")) break;
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private void setASCIItextDirty(int n2) {
        if (0 <= n2 && n2 < 128) {
            this.shouldMapTextChar_ASCII[n2] = true;
        }
    }

    private void setASCIIattrDirty(int n2) {
        if (0 <= n2 && n2 < 128) {
            this.shouldMapAttrChar_ASCII[n2] = true;
        }
    }

    boolean defineChar2StringMapping(String string, char c2) {
        CharKey charKey = new CharKey(c2);
        this.m_charToString.put(charKey, string);
        this.set(c2);
        boolean bl2 = this.extraEntity(string, c2);
        return bl2;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    CharInfo(String string, String string2, boolean bl2, 1 var4_4) {
        this(string, string2, bl2);
    }

    private static class CharKey {
        private char m_char;

        public CharKey(char c2) {
            this.m_char = c2;
        }

        public CharKey() {
        }

        public final void setChar(char c2) {
            this.m_char = c2;
        }

        public final int hashCode() {
            return this.m_char;
        }

        public final boolean equals(Object object) {
            return ((CharKey)object).m_char == this.m_char;
        }
    }
}

