/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.xalan.xsltc.compiler.Constants;
import org.apache.xalan.xsltc.compiler.Pattern;
import org.apache.xalan.xsltc.compiler.XSLTC;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.InternalError;
import org.apache.xalan.xsltc.compiler.util.MarkerInstruction;
import org.apache.xalan.xsltc.compiler.util.ObjectType;
import org.apache.xalan.xsltc.compiler.util.OutlineableChunkEnd;
import org.apache.xalan.xsltc.compiler.util.OutlineableChunkStart;
import org.apache.xalan.xsltc.compiler.util.SlotAllocator;

public class MethodGenerator
extends MethodGen
implements Constants {
    protected static final int INVALID_INDEX = -1;
    private static final String START_ELEMENT_SIG = "(Ljava/lang/String;)V";
    private static final String END_ELEMENT_SIG = "(Ljava/lang/String;)V";
    private InstructionList _mapTypeSub;
    private static final int DOM_INDEX = 1;
    private static final int ITERATOR_INDEX = 2;
    private static final int HANDLER_INDEX = 3;
    private static final int MAX_METHOD_SIZE = 65535;
    private static final int MAX_BRANCH_TARGET_OFFSET = Short.MAX_VALUE;
    private static final int MIN_BRANCH_TARGET_OFFSET = Short.MIN_VALUE;
    private static final int TARGET_METHOD_SIZE = 60000;
    private static final int MINIMUM_OUTLINEABLE_CHUNK_SIZE = 1000;
    private Instruction _iloadCurrent;
    private Instruction _istoreCurrent;
    private final Instruction _astoreHandler;
    private final Instruction _aloadHandler;
    private final Instruction _astoreIterator;
    private final Instruction _aloadIterator;
    private final Instruction _aloadDom;
    private final Instruction _astoreDom;
    private final Instruction _startElement;
    private final Instruction _endElement;
    private final Instruction _startDocument;
    private final Instruction _endDocument;
    private final Instruction _attribute;
    private final Instruction _uniqueAttribute;
    private final Instruction _namespace;
    private final Instruction _setStartNode;
    private final Instruction _reset;
    private final Instruction _nextNode;
    private SlotAllocator _slotAllocator;
    private boolean _allocatorInit = false;
    private LocalVariableRegistry _localVariableRegistry;
    private Hashtable _preCompiled = new Hashtable();
    private int m_totalChunks = 0;
    private int m_openChunks = 0;

    public MethodGenerator(int n2, Type type, Type[] typeArray, String[] stringArray, String string, String string2, InstructionList instructionList, ConstantPoolGen constantPoolGen) {
        super(n2, type, typeArray, stringArray, string, string2, instructionList, constantPoolGen);
        this._astoreHandler = new ASTORE(3);
        this._aloadHandler = new ALOAD(3);
        this._astoreIterator = new ASTORE(2);
        this._aloadIterator = new ALOAD(2);
        this._aloadDom = new ALOAD(1);
        this._astoreDom = new ASTORE(1);
        int n3 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "startElement", "(Ljava/lang/String;)V");
        this._startElement = new INVOKEINTERFACE(n3, 2);
        int n4 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "endElement", "(Ljava/lang/String;)V");
        this._endElement = new INVOKEINTERFACE(n4, 2);
        int n5 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "addAttribute", "(Ljava/lang/String;Ljava/lang/String;)V");
        this._attribute = new INVOKEINTERFACE(n5, 3);
        int n6 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "addUniqueAttribute", "(Ljava/lang/String;Ljava/lang/String;I)V");
        this._uniqueAttribute = new INVOKEINTERFACE(n6, 4);
        int n7 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "namespaceAfterStartElement", "(Ljava/lang/String;Ljava/lang/String;)V");
        this._namespace = new INVOKEINTERFACE(n7, 3);
        int n8 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "startDocument", "()V");
        this._startDocument = new INVOKEINTERFACE(n8, 1);
        n8 = constantPoolGen.addInterfaceMethodref(TRANSLET_OUTPUT_INTERFACE, "endDocument", "()V");
        this._endDocument = new INVOKEINTERFACE(n8, 1);
        n8 = constantPoolGen.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "setStartNode", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
        this._setStartNode = new INVOKEINTERFACE(n8, 2);
        n8 = constantPoolGen.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "reset", "()Lorg/apache/xml/dtm/DTMAxisIterator;");
        this._reset = new INVOKEINTERFACE(n8, 1);
        n8 = constantPoolGen.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "next", "()I");
        this._nextNode = new INVOKEINTERFACE(n8, 1);
        this._slotAllocator = new SlotAllocator();
        this._slotAllocator.initialize(this.getLocalVariableRegistry().getLocals(false));
        this._allocatorInit = true;
    }

    public LocalVariableGen addLocalVariable(String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        LocalVariableGen localVariableGen;
        if (this._allocatorInit) {
            localVariableGen = this.addLocalVariable2(string, type, instructionHandle);
        } else {
            localVariableGen = super.addLocalVariable(string, type, instructionHandle, instructionHandle2);
            this.getLocalVariableRegistry().registerLocalVariable(localVariableGen);
        }
        return localVariableGen;
    }

    public LocalVariableGen addLocalVariable2(String string, Type type, InstructionHandle instructionHandle) {
        LocalVariableGen localVariableGen = super.addLocalVariable(string, type, this._slotAllocator.allocateSlot(type), instructionHandle, null);
        this.getLocalVariableRegistry().registerLocalVariable(localVariableGen);
        return localVariableGen;
    }

    private LocalVariableRegistry getLocalVariableRegistry() {
        if (this._localVariableRegistry == null) {
            this._localVariableRegistry = new LocalVariableRegistry(this);
        }
        return this._localVariableRegistry;
    }

    boolean offsetInLocalVariableGenRange(LocalVariableGen localVariableGen, int n2) {
        InstructionHandle instructionHandle = localVariableGen.getStart();
        InstructionHandle instructionHandle2 = localVariableGen.getEnd();
        if (instructionHandle == null) {
            instructionHandle = this.getInstructionList().getStart();
        }
        if (instructionHandle2 == null) {
            instructionHandle2 = this.getInstructionList().getEnd();
        }
        return instructionHandle.getPosition() <= n2 && instructionHandle2.getPosition() + instructionHandle2.getInstruction().getLength() >= n2;
    }

    public void removeLocalVariable(LocalVariableGen localVariableGen) {
        this._slotAllocator.releaseSlot(localVariableGen);
        this.getLocalVariableRegistry().removeByNameTracking(localVariableGen);
        super.removeLocalVariable(localVariableGen);
    }

    public Instruction loadDOM() {
        return this._aloadDom;
    }

    public Instruction storeDOM() {
        return this._astoreDom;
    }

    public Instruction storeHandler() {
        return this._astoreHandler;
    }

    public Instruction loadHandler() {
        return this._aloadHandler;
    }

    public Instruction storeIterator() {
        return this._astoreIterator;
    }

    public Instruction loadIterator() {
        return this._aloadIterator;
    }

    public final Instruction setStartNode() {
        return this._setStartNode;
    }

    public final Instruction reset() {
        return this._reset;
    }

    public final Instruction nextNode() {
        return this._nextNode;
    }

    public final Instruction startElement() {
        return this._startElement;
    }

    public final Instruction endElement() {
        return this._endElement;
    }

    public final Instruction startDocument() {
        return this._startDocument;
    }

    public final Instruction endDocument() {
        return this._endDocument;
    }

    public final Instruction attribute() {
        return this._attribute;
    }

    public final Instruction uniqueAttribute() {
        return this._uniqueAttribute;
    }

    public final Instruction namespace() {
        return this._namespace;
    }

    public Instruction loadCurrentNode() {
        if (this._iloadCurrent == null) {
            int n2 = this.getLocalIndex("current");
            this._iloadCurrent = n2 > 0 ? new ILOAD(n2) : new ICONST(0);
        }
        return this._iloadCurrent;
    }

    public Instruction storeCurrentNode() {
        return this._istoreCurrent != null ? this._istoreCurrent : (this._istoreCurrent = new ISTORE(this.getLocalIndex("current")));
    }

    public Instruction loadContextNode() {
        return this.loadCurrentNode();
    }

    public Instruction storeContextNode() {
        return this.storeCurrentNode();
    }

    public int getLocalIndex(String string) {
        return this.getLocalVariable(string).getIndex();
    }

    public LocalVariableGen getLocalVariable(String string) {
        return this.getLocalVariableRegistry().lookUpByName(string);
    }

    public void setMaxLocals() {
        int n2 = super.getMaxLocals();
        LocalVariableGen[] localVariableGenArray = super.getLocalVariables();
        if (localVariableGenArray != null && localVariableGenArray.length > n2) {
            n2 = localVariableGenArray.length;
        }
        if (n2 < 5) {
            n2 = 5;
        }
        super.setMaxLocals(n2);
    }

    public void addInstructionList(Pattern pattern, InstructionList instructionList) {
        this._preCompiled.put(pattern, instructionList);
    }

    public InstructionList getInstructionList(Pattern pattern) {
        return (InstructionList)this._preCompiled.get(pattern);
    }

    private ArrayList getCandidateChunks(ClassGenerator classGenerator, int n2) {
        InstructionHandle instructionHandle;
        Iterator iterator = this.getInstructionList().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        Stack<ArrayList> stack = new Stack<ArrayList>();
        boolean bl2 = false;
        boolean bl3 = true;
        if (this.m_openChunks != 0) {
            String string = new ErrorMsg("OUTLINE_ERR_UNBALANCED_MARKERS").toString();
            throw new InternalError(string);
        }
        do {
            InstructionHandle instructionHandle2;
            int n3;
            int n4;
            Instruction instruction;
            instructionHandle = iterator.hasNext() ? (InstructionHandle)iterator.next() : null;
            Instruction instruction2 = instruction = instructionHandle != null ? instructionHandle.getInstruction() : null;
            if (bl3) {
                bl2 = true;
                arrayList2.add(instructionHandle);
                bl3 = false;
            }
            if (instruction instanceof OutlineableChunkStart) {
                if (bl2) {
                    stack.push(arrayList2);
                    arrayList2 = new ArrayList();
                }
                bl2 = true;
                arrayList2.add(instructionHandle);
                continue;
            }
            if (instructionHandle != null && !(instruction instanceof OutlineableChunkEnd)) continue;
            ArrayList arrayList3 = null;
            if (!bl2) {
                arrayList3 = arrayList2;
                arrayList2 = (ArrayList)stack.pop();
            }
            if ((n4 = (n3 = instructionHandle != null ? instructionHandle.getPosition() : n2) - (instructionHandle2 = (InstructionHandle)arrayList2.get(arrayList2.size() - 1)).getPosition()) <= 60000) {
                arrayList2.add(instructionHandle);
            } else {
                int n5;
                if (!bl2 && (n5 = arrayList3.size() / 2) > 0) {
                    Object object;
                    Chunk[] chunkArray = new Chunk[n5];
                    for (int i2 = 0; i2 < n5; ++i2) {
                        InstructionHandle instructionHandle3 = (InstructionHandle)arrayList3.get(i2 * 2);
                        object = (InstructionHandle)arrayList3.get(i2 * 2 + 1);
                        chunkArray[i2] = new Chunk(instructionHandle3, (InstructionHandle)object);
                    }
                    ArrayList arrayList4 = this.mergeAdjacentChunks(chunkArray);
                    for (int i3 = 0; i3 < arrayList4.size(); ++i3) {
                        object = (Chunk)arrayList4.get(i3);
                        int n6 = ((Chunk)object).getChunkSize();
                        if (n6 < 1000 || n6 > 60000) continue;
                        arrayList.add(object);
                    }
                }
                arrayList2.remove(arrayList2.size() - 1);
            }
            boolean bl4 = bl2 = (arrayList2.size() & 1) == 1;
        } while (instructionHandle != null);
        return arrayList;
    }

    private ArrayList mergeAdjacentChunks(Chunk[] chunkArray) {
        int n2;
        int n3;
        int[] nArray = new int[chunkArray.length];
        int[] nArray2 = new int[chunkArray.length];
        boolean[] blArray = new boolean[chunkArray.length];
        int n4 = 0;
        int n5 = 0;
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n6 = 0;
        for (n3 = 1; n3 < chunkArray.length; ++n3) {
            if (chunkArray[n3 - 1].isAdjacentTo(chunkArray[n3])) continue;
            n2 = n3 - n6;
            if (n4 < n2) {
                n4 = n2;
            }
            if (n2 > 1) {
                nArray2[n5] = n2;
                nArray[n5] = n6;
                ++n5;
            }
            n6 = n3;
        }
        if (chunkArray.length - n6 > 1) {
            n3 = chunkArray.length - n6;
            if (n4 < n3) {
                n4 = n3;
            }
            nArray2[n5] = chunkArray.length - n6;
            nArray[n5] = n6;
            ++n5;
        }
        for (n3 = n4; n3 > 1; --n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n7 = nArray[n2];
                int n8 = n7 + nArray2[n2] - 1;
                boolean bl2 = false;
                int n9 = n7;
                while (n9 + n3 - 1 <= n8 && !bl2) {
                    int n10;
                    int n11 = n9 + n3 - 1;
                    int n12 = 0;
                    for (n10 = n9; n10 <= n11; ++n10) {
                        n12 += chunkArray[n10].getChunkSize();
                    }
                    if (n12 <= 60000) {
                        bl2 = true;
                        for (n10 = n9; n10 <= n11; ++n10) {
                            blArray[n10] = true;
                        }
                        arrayList.add(new Chunk(chunkArray[n9].getChunkStart(), chunkArray[n11].getChunkEnd()));
                        nArray2[n2] = nArray[n2] - n9;
                        n10 = n8 - n11;
                        if (n10 >= 2) {
                            nArray[n5] = n11 + 1;
                            nArray2[n5] = n10;
                            ++n5;
                        }
                    }
                    ++n9;
                }
            }
        }
        for (n3 = 0; n3 < chunkArray.length; ++n3) {
            if (blArray[n3]) continue;
            arrayList.add(chunkArray[n3]);
        }
        return arrayList;
    }

    public Method[] outlineChunks(ClassGenerator classGenerator, int n2) {
        Method[] methodArray;
        boolean bl2;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        int n3 = n2;
        int n4 = 0;
        String string = this.getName();
        if (string.equals("<init>")) {
            string = "$lt$init$gt$";
        } else if (string.equals("<clinit>")) {
            string = "$lt$clinit$gt$";
        }
        do {
            methodArray = this.getCandidateChunks(classGenerator, n3);
            Collections.sort(methodArray);
            bl2 = false;
            for (int i2 = methodArray.size() - 1; i2 >= 0 && n3 > 60000; --i2) {
                Chunk chunk = (Chunk)methodArray.get(i2);
                arrayList.add(this.outline(chunk.getChunkStart(), chunk.getChunkEnd(), string + "$outline$" + n4, classGenerator));
                ++n4;
                bl2 = true;
                InstructionList instructionList = this.getInstructionList();
                InstructionHandle instructionHandle = instructionList.getEnd();
                instructionList.setPositions();
                n3 = instructionHandle.getPosition() + instructionHandle.getInstruction().getLength();
            }
        } while (bl2 && n3 > 60000);
        if (n3 > 65535) {
            methodArray = new ErrorMsg("OUTLINE_ERR_METHOD_TOO_BIG").toString();
            throw new InternalError((String)methodArray);
        }
        methodArray = new Method[arrayList.size() + 1];
        arrayList.toArray(methodArray);
        methodArray[arrayList.size()] = this.getThisMethod();
        return methodArray;
    }

    private Method outline(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, String string, ClassGenerator classGenerator) {
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        Serializable serializable;
        InstructionHandle instructionHandle3;
        InstructionHandle instructionHandle4;
        boolean bl2;
        if (this.getExceptionHandlers().length != 0) {
            String string2 = new ErrorMsg("OUTLINE_ERR_TRY_CATCH").toString();
            throw new InternalError(string2);
        }
        int n2 = instructionHandle.getPosition();
        int n3 = instructionHandle2.getPosition() + instructionHandle2.getInstruction().getLength();
        ConstantPoolGen constantPoolGen = this.getConstantPool();
        InstructionList instructionList = new InstructionList();
        XSLTC xSLTC = classGenerator.getParser().getXSLTC();
        String string3 = xSLTC.getHelperClassName();
        Type[] typeArray = new Type[]{new ObjectType(string3).toJCType()};
        String string4 = "copyLocals";
        String[] stringArray = new String[]{"copyLocals"};
        int n4 = 18;
        boolean bl3 = bl2 = (this.getAccessFlags() & 8) != 0;
        if (bl2) {
            n4 |= 8;
        }
        MethodGenerator methodGenerator = new MethodGenerator(n4, Type.VOID, typeArray, stringArray, string, this.getClassName(), instructionList, constantPoolGen);
        ClassGenerator classGenerator2 = new ClassGenerator(this, string3, "java.lang.Object", string3 + ".java", 49, null, classGenerator.getStylesheet()){
            private final MethodGenerator this$0;
            {
                this.this$0 = methodGenerator;
            }

            public boolean isExternal() {
                return true;
            }
        };
        ConstantPoolGen constantPoolGen2 = classGenerator2.getConstantPool();
        classGenerator2.addEmptyConstructor(1);
        int n5 = 0;
        InstructionHandle instructionHandle5 = instructionHandle2.getNext();
        InstructionList instructionList2 = new InstructionList();
        InstructionList instructionList3 = new InstructionList();
        InstructionList instructionList4 = new InstructionList();
        InstructionList instructionList5 = new InstructionList();
        InstructionHandle instructionHandle6 = instructionList2.append(new NEW(constantPoolGen.addClass(string3)));
        instructionList2.append(InstructionConstants.DUP);
        instructionList2.append(InstructionConstants.DUP);
        instructionList2.append(new INVOKESPECIAL(constantPoolGen.addMethodref(string3, "<init>", "()V")));
        if (bl2) {
            instructionHandle4 = instructionList3.append(new INVOKESTATIC(constantPoolGen.addMethodref(classGenerator.getClassName(), string, methodGenerator.getSignature())));
        } else {
            instructionList3.append(InstructionConstants.THIS);
            instructionList3.append(InstructionConstants.SWAP);
            instructionHandle4 = instructionList3.append(new INVOKEVIRTUAL(constantPoolGen.addMethodref(classGenerator.getClassName(), string, methodGenerator.getSignature())));
        }
        boolean bl4 = false;
        InstructionHandle instructionHandle7 = null;
        InstructionHandle instructionHandle8 = null;
        HashMap<InstructionHandle, InstructionHandle> hashMap = new HashMap<InstructionHandle, InstructionHandle>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, InstructionHandle> hashMap3 = new HashMap<Object, InstructionHandle>();
        HashMap<Object, InstructionHandle> hashMap4 = new HashMap<Object, InstructionHandle>();
        for (instructionHandle3 = instructionHandle; instructionHandle3 != instructionHandle5; instructionHandle3 = instructionHandle3.getNext()) {
            serializable = instructionHandle3.getInstruction();
            if (serializable instanceof MarkerInstruction) {
                if (!instructionHandle3.hasTargeters()) continue;
                if (serializable instanceof OutlineableChunkEnd) {
                    hashMap.put(instructionHandle3, instructionHandle8);
                    continue;
                }
                if (bl4) continue;
                bl4 = true;
                instructionHandle7 = instructionHandle3;
                continue;
            }
            object3 = ((Instruction)serializable).copy();
            instructionHandle8 = object3 instanceof BranchInstruction ? instructionList.append((BranchInstruction)object3) : instructionList.append((Instruction)object3);
            if (object3 instanceof LocalVariableInstruction || object3 instanceof RET) {
                iterator = (IndexedInstruction)object3;
                int n6 = iterator.getIndex();
                LocalVariableGen localVariableGen = this.getLocalVariableRegistry().lookupRegisteredLocalVariable(n6, instructionHandle3.getPosition());
                object2 = (LocalVariableGen)hashMap2.get(localVariableGen);
                if (hashMap2.get(localVariableGen) == null) {
                    boolean bl5 = this.offsetInLocalVariableGenRange(localVariableGen, n2 != 0 ? n2 - 1 : 0);
                    boolean bl6 = this.offsetInLocalVariableGenRange(localVariableGen, n3 + 1);
                    if (bl5 || bl6) {
                        InstructionHandle instructionHandle9;
                        object = localVariableGen.getName();
                        Type type = localVariableGen.getType();
                        object2 = methodGenerator.addLocalVariable((String)object, type, null, null);
                        int n7 = ((LocalVariableGen)object2).getIndex();
                        String string5 = type.getSignature();
                        hashMap2.put(localVariableGen, object2);
                        String string6 = "field" + ++n5;
                        classGenerator2.addField(new Field(1, constantPoolGen2.addUtf8(string6), constantPoolGen2.addUtf8(string5), null, constantPoolGen2.getConstantPool()));
                        int n8 = constantPoolGen.addFieldref(string3, string6, string5);
                        if (bl5) {
                            instructionList2.append(InstructionConstants.DUP);
                            instructionHandle9 = instructionList2.append(MethodGenerator.loadLocal(n6, type));
                            instructionList2.append(new PUTFIELD(n8));
                            if (!bl6) {
                                hashMap4.put(localVariableGen, instructionHandle9);
                            }
                            instructionList4.append(InstructionConstants.ALOAD_1);
                            instructionList4.append(new GETFIELD(n8));
                            instructionList4.append(MethodGenerator.storeLocal(n7, type));
                        }
                        if (bl6) {
                            instructionList5.append(InstructionConstants.ALOAD_1);
                            instructionList5.append(MethodGenerator.loadLocal(n7, type));
                            instructionList5.append(new PUTFIELD(n8));
                            instructionList3.append(InstructionConstants.DUP);
                            instructionList3.append(new GETFIELD(n8));
                            instructionHandle9 = instructionList3.append(MethodGenerator.storeLocal(n6, type));
                            if (!bl5) {
                                hashMap3.put(localVariableGen, instructionHandle9);
                            }
                        }
                    }
                }
            }
            if (instructionHandle3.hasTargeters()) {
                hashMap.put(instructionHandle3, instructionHandle8);
            }
            if (!bl4) continue;
            do {
                hashMap.put(instructionHandle7, instructionHandle8);
            } while ((instructionHandle7 = instructionHandle7.getNext()) != instructionHandle3);
            bl4 = false;
        }
        instructionHandle3 = instructionHandle;
        serializable = instructionList.getStart();
        while (serializable != null) {
            Object object4;
            InstructionTargeter[] instructionTargeterArray;
            object3 = instructionHandle3.getInstruction();
            iterator = ((InstructionHandle)serializable).getInstruction();
            if (object3 instanceof BranchInstruction) {
                instructionTargeterArray = (BranchInstruction)((Object)iterator);
                BranchInstruction branchInstruction = (BranchInstruction)object3;
                object2 = branchInstruction.getTarget();
                object4 = (InstructionHandle)hashMap.get(object2);
                instructionTargeterArray.setTarget((InstructionHandle)object4);
                if (branchInstruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)branchInstruction).getTargets();
                    object = ((Select)instructionTargeterArray).getTargets();
                    for (int i2 = 0; i2 < instructionHandleArray.length; ++i2) {
                        object[i2] = (InstructionHandle)hashMap.get(instructionHandleArray[i2]);
                    }
                }
            } else if (object3 instanceof LocalVariableInstruction || object3 instanceof RET) {
                int n9;
                instructionTargeterArray = (IndexedInstruction)((Object)iterator);
                int n10 = instructionTargeterArray.getIndex();
                object2 = this.getLocalVariableRegistry().lookupRegisteredLocalVariable(n10, instructionHandle3.getPosition());
                object4 = (LocalVariableGen)hashMap2.get(object2);
                if (object4 == null) {
                    object = ((LocalVariableGen)object2).getName();
                    Type type = ((LocalVariableGen)object2).getType();
                    object4 = methodGenerator.addLocalVariable((String)object, type, null, null);
                    n9 = ((LocalVariableGen)object4).getIndex();
                    hashMap2.put(object2, object4);
                    hashMap3.put(object2, instructionHandle4);
                    hashMap4.put(object2, instructionHandle4);
                } else {
                    n9 = ((LocalVariableGen)object4).getIndex();
                }
                instructionTargeterArray.setIndex(n9);
            }
            if (instructionHandle3.hasTargeters()) {
                instructionTargeterArray = instructionHandle3.getTargeters();
                for (int i3 = 0; i3 < instructionTargeterArray.length; ++i3) {
                    Object v2;
                    object2 = instructionTargeterArray[i3];
                    if (!(object2 instanceof LocalVariableGen) || ((LocalVariableGen)object2).getEnd() != instructionHandle3 || (v2 = hashMap2.get(object2)) == null) continue;
                    methodGenerator.removeLocalVariable((LocalVariableGen)v2);
                }
            }
            if (!(object3 instanceof MarkerInstruction)) {
                serializable = ((InstructionHandle)serializable).getNext();
            }
            instructionHandle3 = instructionHandle3.getNext();
        }
        instructionList3.append(InstructionConstants.POP);
        object3 = hashMap3.entrySet().iterator();
        while (object3.hasNext()) {
            iterator = (Map.Entry)object3.next();
            LocalVariableGen localVariableGen = (LocalVariableGen)iterator.getKey();
            InstructionHandle instructionHandle10 = (InstructionHandle)iterator.getValue();
            localVariableGen.setStart(instructionHandle10);
        }
        iterator = hashMap4.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LocalVariableGen localVariableGen = (LocalVariableGen)entry.getKey();
            object2 = (InstructionHandle)entry.getValue();
            localVariableGen.setEnd((InstructionHandle)object2);
        }
        xSLTC.dumpClass(classGenerator2.getJavaClass());
        InstructionList instructionList6 = this.getInstructionList();
        instructionList6.insert(instructionHandle, instructionList2);
        instructionList6.insert(instructionHandle, instructionList3);
        instructionList.insert(instructionList4);
        instructionList.append(instructionList5);
        instructionList.append(InstructionConstants.RETURN);
        try {
            instructionList6.delete(instructionHandle, instructionHandle2);
        }
        catch (TargetLostException targetLostException) {
            object2 = targetLostException.getTargets();
            for (int i4 = 0; i4 < ((InstructionHandle[])object2).length; ++i4) {
                InstructionHandle instructionHandle11 = object2[i4];
                object = instructionHandle11.getTargeters();
                for (int i5 = 0; i5 < ((InstructionHandle[])object).length; ++i5) {
                    if (object[i5] instanceof LocalVariableGen) {
                        LocalVariableGen localVariableGen = (LocalVariableGen)((Object)object[i5]);
                        if (localVariableGen.getStart() == instructionHandle11) {
                            localVariableGen.setStart(instructionHandle4);
                        }
                        if (localVariableGen.getEnd() != instructionHandle11) continue;
                        localVariableGen.setEnd(instructionHandle4);
                        continue;
                    }
                    object[i5].updateTarget(instructionHandle11, instructionHandle6);
                }
            }
        }
        String[] stringArray2 = this.getExceptions();
        for (int i6 = 0; i6 < stringArray2.length; ++i6) {
            methodGenerator.addException(stringArray2[i6]);
        }
        return methodGenerator.getThisMethod();
    }

    private static Instruction loadLocal(int n2, Type type) {
        if (type == Type.BOOLEAN) {
            return new ILOAD(n2);
        }
        if (type == Type.INT) {
            return new ILOAD(n2);
        }
        if (type == Type.SHORT) {
            return new ILOAD(n2);
        }
        if (type == Type.LONG) {
            return new LLOAD(n2);
        }
        if (type == Type.BYTE) {
            return new ILOAD(n2);
        }
        if (type == Type.CHAR) {
            return new ILOAD(n2);
        }
        if (type == Type.FLOAT) {
            return new FLOAD(n2);
        }
        if (type == Type.DOUBLE) {
            return new DLOAD(n2);
        }
        return new ALOAD(n2);
    }

    private static Instruction storeLocal(int n2, Type type) {
        if (type == Type.BOOLEAN) {
            return new ISTORE(n2);
        }
        if (type == Type.INT) {
            return new ISTORE(n2);
        }
        if (type == Type.SHORT) {
            return new ISTORE(n2);
        }
        if (type == Type.LONG) {
            return new LSTORE(n2);
        }
        if (type == Type.BYTE) {
            return new ISTORE(n2);
        }
        if (type == Type.CHAR) {
            return new ISTORE(n2);
        }
        if (type == Type.FLOAT) {
            return new FSTORE(n2);
        }
        if (type == Type.DOUBLE) {
            return new DSTORE(n2);
        }
        return new ASTORE(n2);
    }

    public void markChunkStart() {
        this.getInstructionList().append(OutlineableChunkStart.OUTLINEABLECHUNKSTART);
        ++this.m_totalChunks;
        ++this.m_openChunks;
    }

    public void markChunkEnd() {
        this.getInstructionList().append(OutlineableChunkEnd.OUTLINEABLECHUNKEND);
        --this.m_openChunks;
        if (this.m_openChunks < 0) {
            String string = new ErrorMsg("OUTLINE_ERR_UNBALANCED_MARKERS").toString();
            throw new InternalError(string);
        }
    }

    Method[] getGeneratedMethods(ClassGenerator classGenerator) {
        boolean bl2;
        InstructionList instructionList = this.getInstructionList();
        InstructionHandle instructionHandle = instructionList.getEnd();
        instructionList.setPositions();
        int n2 = instructionHandle.getPosition() + instructionHandle.getInstruction().getLength();
        if (n2 > Short.MAX_VALUE && (bl2 = this.widenConditionalBranchTargetOffsets())) {
            instructionList.setPositions();
            instructionHandle = instructionList.getEnd();
            n2 = instructionHandle.getPosition() + instructionHandle.getInstruction().getLength();
        }
        Method[] methodArray = n2 > 65535 ? this.outlineChunks(classGenerator, n2) : new Method[]{this.getThisMethod()};
        return methodArray;
    }

    protected Method getThisMethod() {
        this.stripAttributes(true);
        this.setMaxLocals();
        this.setMaxStack();
        this.removeNOPs();
        return this.getMethod();
    }

    boolean widenConditionalBranchTargetOffsets() {
        Instruction instruction;
        InstructionHandle instructionHandle;
        boolean bl2 = false;
        int n2 = 0;
        InstructionList instructionList = this.getInstructionList();
        block7: for (instructionHandle = instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            switch (instruction.getOpcode()) {
                case 167: 
                case 168: {
                    n2 += 2;
                    continue block7;
                }
                case 170: 
                case 171: {
                    n2 += 3;
                    continue block7;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    n2 += 5;
                }
            }
        }
        for (instructionHandle = instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            if (!(instruction instanceof IfInstruction)) continue;
            IfInstruction ifInstruction = (IfInstruction)instruction;
            BranchHandle branchHandle = (BranchHandle)instructionHandle;
            InstructionHandle instructionHandle2 = ifInstruction.getTarget();
            int n3 = instructionHandle2.getPosition() - branchHandle.getPosition();
            if (n3 - n2 >= Short.MIN_VALUE && n3 + n2 <= Short.MAX_VALUE) continue;
            InstructionHandle instructionHandle3 = branchHandle.getNext();
            IfInstruction ifInstruction2 = ifInstruction.negate();
            BranchHandle branchHandle2 = instructionList.append((InstructionHandle)branchHandle, ifInstruction2);
            BranchHandle branchHandle3 = instructionList.append((InstructionHandle)branchHandle2, new GOTO(instructionHandle2));
            if (instructionHandle3 == null) {
                instructionHandle3 = instructionList.append((InstructionHandle)branchHandle3, NOP);
            }
            branchHandle2.updateTarget(instructionHandle2, instructionHandle3);
            if (branchHandle.hasTargeters()) {
                InstructionTargeter[] instructionTargeterArray = branchHandle.getTargeters();
                for (int i2 = 0; i2 < instructionTargeterArray.length; ++i2) {
                    InstructionTargeter instructionTargeter = instructionTargeterArray[i2];
                    if (instructionTargeter instanceof LocalVariableGen) {
                        LocalVariableGen localVariableGen = (LocalVariableGen)instructionTargeter;
                        if (localVariableGen.getStart() == branchHandle) {
                            localVariableGen.setStart(branchHandle2);
                            continue;
                        }
                        if (localVariableGen.getEnd() != branchHandle) continue;
                        localVariableGen.setEnd(branchHandle3);
                        continue;
                    }
                    instructionTargeter.updateTarget(branchHandle, branchHandle2);
                }
            }
            try {
                instructionList.delete(branchHandle);
            }
            catch (TargetLostException targetLostException) {
                String string = new ErrorMsg("OUTLINE_ERR_DELETED_TARGET", targetLostException.getMessage()).toString();
                throw new InternalError(string);
            }
            instructionHandle = branchHandle3;
            bl2 = true;
        }
        return bl2;
    }

    private static class Chunk
    implements Comparable {
        private InstructionHandle m_start;
        private InstructionHandle m_end;
        private int m_size;

        Chunk(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            this.m_start = instructionHandle;
            this.m_end = instructionHandle2;
            this.m_size = instructionHandle2.getPosition() - instructionHandle.getPosition();
        }

        boolean isAdjacentTo(Chunk chunk) {
            return this.getChunkEnd().getNext() == chunk.getChunkStart();
        }

        InstructionHandle getChunkStart() {
            return this.m_start;
        }

        InstructionHandle getChunkEnd() {
            return this.m_end;
        }

        int getChunkSize() {
            return this.m_size;
        }

        public int compareTo(Object object) {
            return this.getChunkSize() - ((Chunk)object).getChunkSize();
        }
    }

    protected class LocalVariableRegistry {
        protected ArrayList _variables;
        protected HashMap _nameToLVGMap;
        private final MethodGenerator this$0;

        protected LocalVariableRegistry(MethodGenerator methodGenerator) {
            this.this$0 = methodGenerator;
            this._variables = new ArrayList();
            this._nameToLVGMap = new HashMap();
        }

        protected void registerLocalVariable(LocalVariableGen localVariableGen) {
            int n2;
            int n3 = localVariableGen.getIndex();
            if (n3 >= (n2 = this._variables.size())) {
                for (int i2 = n2; i2 < n3; ++i2) {
                    this._variables.add(null);
                }
                this._variables.add(localVariableGen);
            } else {
                Object e2 = this._variables.get(n3);
                if (e2 != null) {
                    if (e2 instanceof LocalVariableGen) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.add(e2);
                        arrayList.add(localVariableGen);
                        this._variables.set(n3, arrayList);
                    } else {
                        ((ArrayList)e2).add(localVariableGen);
                    }
                } else {
                    this._variables.set(n3, localVariableGen);
                }
            }
            this.registerByName(localVariableGen);
        }

        protected LocalVariableGen lookupRegisteredLocalVariable(int n2, int n3) {
            Object var3_3;
            Object v0 = var3_3 = this._variables != null ? this._variables.get(n2) : null;
            if (var3_3 != null) {
                if (var3_3 instanceof LocalVariableGen) {
                    LocalVariableGen localVariableGen = var3_3;
                    if (this.this$0.offsetInLocalVariableGenRange(localVariableGen, n3)) {
                        return localVariableGen;
                    }
                } else {
                    ArrayList arrayList = var3_3;
                    int n4 = arrayList.size();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        LocalVariableGen localVariableGen = (LocalVariableGen)arrayList.get(i2);
                        if (!this.this$0.offsetInLocalVariableGenRange(localVariableGen, n3)) continue;
                        return localVariableGen;
                    }
                }
            }
            return null;
        }

        protected void registerByName(LocalVariableGen localVariableGen) {
            Object v2 = this._nameToLVGMap.get(localVariableGen.getName());
            if (v2 == null) {
                this._nameToLVGMap.put(localVariableGen.getName(), localVariableGen);
            } else {
                ArrayList<LocalVariableGen> arrayList;
                if (v2 instanceof ArrayList) {
                    arrayList = (ArrayList<LocalVariableGen>)v2;
                    arrayList.add(localVariableGen);
                } else {
                    arrayList = new ArrayList<LocalVariableGen>();
                    arrayList.add((LocalVariableGen)v2);
                    arrayList.add(localVariableGen);
                }
                this._nameToLVGMap.put(localVariableGen.getName(), arrayList);
            }
        }

        protected void removeByNameTracking(LocalVariableGen localVariableGen) {
            Object v2 = this._nameToLVGMap.get(localVariableGen.getName());
            if (v2 instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)v2;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (arrayList.get(i2) != localVariableGen) continue;
                    arrayList.remove(i2);
                    break;
                }
            } else {
                this._nameToLVGMap.remove(localVariableGen);
            }
        }

        protected LocalVariableGen lookUpByName(String string) {
            LocalVariableGen localVariableGen = null;
            Object v2 = this._nameToLVGMap.get(string);
            if (v2 instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)v2;
                for (int i2 = 0; i2 < arrayList.size() && (localVariableGen = (LocalVariableGen)arrayList.get(i2)).getName() != string; ++i2) {
                }
            } else {
                localVariableGen = (LocalVariableGen)v2;
            }
            return localVariableGen;
        }

        protected LocalVariableGen[] getLocals(boolean bl2) {
            LocalVariableGen[] localVariableGenArray = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (bl2) {
                int n2 = arrayList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object e2 = this._variables.get(i2);
                    if (e2 == null) continue;
                    if (e2 instanceof ArrayList) {
                        ArrayList arrayList2 = (ArrayList)e2;
                        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                            arrayList.add(arrayList2.get(i2));
                        }
                        continue;
                    }
                    arrayList.add(e2);
                }
            } else {
                Iterator iterator = this._nameToLVGMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object v2 = entry.getValue();
                    if (v2 == null) continue;
                    if (v2 instanceof ArrayList) {
                        ArrayList arrayList3 = (ArrayList)v2;
                        for (int i4 = 0; i4 < arrayList3.size(); ++i4) {
                            arrayList.add(arrayList3.get(i4));
                        }
                        continue;
                    }
                    arrayList.add(v2);
                }
            }
            localVariableGenArray = new LocalVariableGen[arrayList.size()];
            arrayList.toArray(localVariableGenArray);
            return localVariableGenArray;
        }
    }
}

