/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.cmdline.getopt;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.xalan.xsltc.cmdline.getopt.IllegalArgumentException;
import org.apache.xalan.xsltc.cmdline.getopt.MissingOptArgException;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;

public class GetOpt {
    private Option theCurrentOption = null;
    private ListIterator theOptionsIterator;
    private List theOptions = new ArrayList();
    private List theCmdArgs = null;
    private OptionMatcher theOptionMatcher = null;

    public GetOpt(String[] stringArray, String string) {
        String string2;
        int n2;
        int n3 = 0;
        this.theCmdArgs = new ArrayList();
        this.theOptionMatcher = new OptionMatcher(string);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            int n4;
            string2 = stringArray[n2];
            int n5 = string2.length();
            if (string2.equals("--")) {
                n3 = n2 + 1;
                break;
            }
            if (string2.startsWith("-") && n5 == 2) {
                this.theOptions.add(new Option(string2.charAt(1)));
                continue;
            }
            if (string2.startsWith("-") && n5 > 2) {
                for (n4 = 1; n4 < n5; ++n4) {
                    this.theOptions.add(new Option(string2.charAt(n4)));
                }
                continue;
            }
            if (string2.startsWith("-")) continue;
            if (this.theOptions.size() == 0) {
                n3 = n2;
                break;
            }
            n4 = 0;
            n4 = this.theOptions.size() - 1;
            Option option = (Option)this.theOptions.get(n4);
            char c2 = option.getArgLetter();
            if (!option.hasArg() && this.theOptionMatcher.hasArg(c2)) {
                option.setArg(string2);
                continue;
            }
            n3 = n2;
            break;
        }
        this.theOptionsIterator = this.theOptions.listIterator();
        for (n2 = n3; n2 < stringArray.length; ++n2) {
            string2 = stringArray[n2];
            this.theCmdArgs.add(string2);
        }
    }

    public void printOptions() {
        ListIterator listIterator = this.theOptions.listIterator();
        while (listIterator.hasNext()) {
            Option option = (Option)listIterator.next();
            System.out.print("OPT =" + option.getArgLetter());
            String string = option.getArgument();
            if (string != null) {
                System.out.print(" " + string);
            }
            System.out.println();
        }
    }

    public int getNextOption() {
        int n2 = -1;
        if (this.theOptionsIterator.hasNext()) {
            this.theCurrentOption = (Option)this.theOptionsIterator.next();
            char c2 = this.theCurrentOption.getArgLetter();
            boolean bl2 = this.theOptionMatcher.hasArg(c2);
            String string = this.theCurrentOption.getArgument();
            if (!this.theOptionMatcher.match(c2)) {
                ErrorMsg errorMsg = new ErrorMsg("ILLEGAL_CMDLINE_OPTION_ERR", new Character(c2));
                throw new IllegalArgumentException(errorMsg.toString());
            }
            if (bl2 && string == null) {
                ErrorMsg errorMsg = new ErrorMsg("CMDLINE_OPT_MISSING_ARG_ERR", new Character(c2));
                throw new MissingOptArgException(errorMsg.toString());
            }
            n2 = c2;
        }
        return n2;
    }

    public String getOptionArg() {
        String string = null;
        String string2 = this.theCurrentOption.getArgument();
        char c2 = this.theCurrentOption.getArgLetter();
        if (this.theOptionMatcher.hasArg(c2)) {
            string = string2;
        }
        return string;
    }

    public String[] getCmdArgs() {
        String[] stringArray = new String[this.theCmdArgs.size()];
        int n2 = 0;
        ListIterator listIterator = this.theCmdArgs.listIterator();
        while (listIterator.hasNext()) {
            stringArray[n2++] = (String)listIterator.next();
        }
        return stringArray;
    }

    static class OptionMatcher {
        private String theOptString = null;

        public OptionMatcher(String string) {
            this.theOptString = string;
        }

        public boolean match(char c2) {
            boolean bl2 = false;
            if (this.theOptString.indexOf(c2) != -1) {
                bl2 = true;
            }
            return bl2;
        }

        public boolean hasArg(char c2) {
            boolean bl2 = false;
            int n2 = this.theOptString.indexOf(c2) + 1;
            if (n2 == this.theOptString.length()) {
                bl2 = false;
            } else if (this.theOptString.charAt(n2) == ':') {
                bl2 = true;
            }
            return bl2;
        }
    }

    static class Option {
        private char theArgLetter;
        private String theArgument = null;

        public Option(char c2) {
            this.theArgLetter = c2;
        }

        public void setArg(String string) {
            this.theArgument = string;
        }

        public boolean hasArg() {
            return this.theArgument != null;
        }

        public char getArgLetter() {
            return this.theArgLetter;
        }

        public String getArgument() {
            return this.theArgument;
        }
    }
}

