/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public abstract class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    protected static Hashtable factories = new Hashtable();
    static Class class$org$apache$commons$logging$LogFactory;
    static Class class$java$lang$Thread;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1);

    public abstract Log getInstance(String var1);

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() {
        String string;
        Object object;
        Enumeration<?> enumeration;
        Properties properties;
        LogFactory logFactory;
        ClassLoader classLoader;
        block19: {
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return LogFactory.getContextClassLoader();
                }
            });
            logFactory = LogFactory.getCachedFactory(classLoader);
            if (logFactory != null) {
                return logFactory;
            }
            properties = null;
            try {
                enumeration = LogFactory.getResourceAsStream(classLoader, FACTORY_PROPERTIES);
                if (enumeration != null) {
                    properties = new Properties();
                    properties.load((InputStream)((Object)enumeration));
                    ((InputStream)((Object)enumeration)).close();
                }
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                enumeration = System.getProperty(FACTORY_PROPERTY);
                if (enumeration != null) {
                    logFactory = LogFactory.newFactory((String)((Object)enumeration), classLoader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (logFactory == null) {
                try {
                    enumeration = LogFactory.getResourceAsStream(classLoader, SERVICE_ID);
                    if (enumeration == null) break block19;
                    try {
                        object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration)));
                    }
                    string = ((BufferedReader)object).readLine();
                    ((BufferedReader)object).close();
                    if (string != null && !"".equals(string)) {
                        logFactory = LogFactory.newFactory(string, classLoader);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (logFactory == null && properties != null && (enumeration = properties.getProperty(FACTORY_PROPERTY)) != null) {
            logFactory = LogFactory.newFactory((String)((Object)enumeration), classLoader);
        }
        if (logFactory == null) {
            logFactory = LogFactory.newFactory(FACTORY_DEFAULT, (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader());
        }
        if (logFactory != null) {
            LogFactory.cacheFactory(classLoader, logFactory);
            if (properties != null) {
                enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string = properties.getProperty((String)object);
                    logFactory.setAttribute((String)object, string);
                }
            }
        }
        return logFactory;
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) {
        return LogFactory.getFactory().getInstance(string);
    }

    public static void release(ClassLoader classLoader) {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            LogFactory logFactory = (LogFactory)factories.get(classLoader);
            if (logFactory != null) {
                logFactory.release();
                factories.remove(classLoader);
            }
        }
    }

    public static void releaseAll() {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration enumeration = factories.elements();
            while (enumeration.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)enumeration.nextElement();
                logFactory.release();
            }
            factories.clear();
        }
    }

    protected static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = LogFactory.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", invocationTargetException.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classLoader = (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader();
        }
        return classLoader;
    }

    private static LogFactory getCachedFactory(ClassLoader classLoader) {
        LogFactory logFactory = null;
        if (classLoader != null) {
            logFactory = (LogFactory)factories.get(classLoader);
        }
        return logFactory;
    }

    private static void cacheFactory(ClassLoader classLoader, LogFactory logFactory) {
        if (classLoader != null && logFactory != null) {
            factories.put(classLoader, logFactory);
        }
    }

    protected static LogFactory newFactory(String string, ClassLoader classLoader) {
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(classLoader, string){
            static Class class$org$apache$commons$logging$LogFactory;
            private final ClassLoader val$classLoader;
            private final String val$factoryClass;
            {
                this.val$classLoader = classLoader;
                this.val$factoryClass = string;
            }

            public Object run() {
                Class<?> clazz = null;
                try {
                    block10: {
                        if (this.val$classLoader != null) {
                            try {
                                clazz = this.val$classLoader.loadClass(this.val$factoryClass);
                                return (LogFactory)clazz.newInstance();
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (this.val$classLoader == (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = 2.class$(LogFactory.FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader()) {
                                    throw classNotFoundException;
                                }
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                if (this.val$classLoader == (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = 2.class$(LogFactory.FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader()) {
                                    throw noClassDefFoundError;
                                }
                            }
                            catch (ClassCastException classCastException) {
                                if (this.val$classLoader != (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = 2.class$(LogFactory.FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader()) break block10;
                                throw classCastException;
                            }
                        }
                    }
                    clazz = Class.forName(this.val$factoryClass);
                    return (LogFactory)clazz.newInstance();
                }
                catch (Exception exception) {
                    if (clazz != null && !(class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = 2.class$(LogFactory.FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).isAssignableFrom(clazz)) {
                        return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", exception);
                    }
                    return new LogConfigurationException(exception);
                }
            }

            static Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        if (t2 instanceof LogConfigurationException) {
            throw (LogConfigurationException)t2;
        }
        return (LogFactory)t2;
    }

    private static InputStream getResourceAsStream(ClassLoader classLoader, String string) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(classLoader, string){
            private final ClassLoader val$loader;
            private final String val$name;
            {
                this.val$loader = classLoader;
                this.val$name = string;
            }

            public Object run() {
                if (this.val$loader != null) {
                    return this.val$loader.getResourceAsStream(this.val$name);
                }
                return ClassLoader.getSystemResourceAsStream(this.val$name);
            }
        });
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

