/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private int threshold;
    private long written;
    private boolean thresholdExceeded;

    public ThresholdingOutputStream(int n2) {
        this.threshold = n2;
    }

    public void write(int n2) {
        this.checkThreshold(1);
        this.getStream().write(n2);
        ++this.written;
    }

    public void write(byte[] byArray) {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.written += (long)byArray.length;
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.checkThreshold(n3);
        this.getStream().write(byArray, n2, n3);
        this.written += (long)n3;
    }

    public void flush() {
        this.getStream().flush();
    }

    public void close() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    public int getThreshold() {
        return this.threshold;
    }

    public long getByteCount() {
        return this.written;
    }

    public boolean isThresholdExceeded() {
        return this.written > (long)this.threshold;
    }

    protected void checkThreshold(int n2) {
        if (!this.thresholdExceeded && this.written + (long)n2 > (long)this.threshold) {
            this.thresholdReached();
            this.thresholdExceeded = true;
        }
    }

    protected abstract OutputStream getStream();

    protected abstract void thresholdReached();
}

