/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LockableFileWriter
extends Writer {
    private static final String LCK = ".lck";
    private final Writer out;
    private final File lockFile;
    static Class class$org$apache$commons$io$output$LockableFileWriter;

    public LockableFileWriter(String string) {
        this(string, false, null);
    }

    public LockableFileWriter(String string, boolean bl2) {
        this(string, bl2, null);
    }

    public LockableFileWriter(String string, boolean bl2, String string2) {
        this(new File(string), bl2, string2);
    }

    public LockableFileWriter(File file) {
        this(file, false, null);
    }

    public LockableFileWriter(File file, boolean bl2) {
        this(file, bl2, null);
    }

    public LockableFileWriter(File file, boolean bl2, String string) {
        this(file, null, bl2, string);
    }

    public LockableFileWriter(File file, String string) {
        this(file, string, false, null);
    }

    public LockableFileWriter(File file, String string, boolean bl2, String string2) {
        file = file.getAbsoluteFile();
        if (file.getParentFile() != null) {
            FileUtils.forceMkdir(file.getParentFile());
        }
        if (file.isDirectory()) {
            throw new IOException("File specified is a directory");
        }
        if (string2 == null) {
            string2 = System.getProperty("java.io.tmpdir");
        }
        File file2 = new File(string2);
        FileUtils.forceMkdir(file2);
        this.testLockDir(file2);
        this.lockFile = new File(file2, file.getName() + LCK);
        this.createLock();
        this.out = this.initWriter(file, string, bl2);
    }

    private void testLockDir(File file) {
        if (!file.exists()) {
            throw new IOException("Could not find lockDir: " + file.getAbsolutePath());
        }
        if (!file.canWrite()) {
            throw new IOException("Could not write to lockDir: " + file.getAbsolutePath());
        }
    }

    private void createLock() {
        Class clazz = class$org$apache$commons$io$output$LockableFileWriter == null ? (class$org$apache$commons$io$output$LockableFileWriter = LockableFileWriter.class$("org.apache.commons.io.output.LockableFileWriter")) : class$org$apache$commons$io$output$LockableFileWriter;
        synchronized (clazz) {
            if (!this.lockFile.createNewFile()) {
                throw new IOException("Can't write file, lock " + this.lockFile.getAbsolutePath() + " exists");
            }
            this.lockFile.deleteOnExit();
        }
    }

    private Writer initWriter(File file, String string, boolean bl2) {
        boolean bl3 = file.exists();
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            if (string == null) {
                outputStreamWriter = new FileWriter(file.getAbsolutePath(), bl2);
            } else {
                fileOutputStream = new FileOutputStream(file.getAbsolutePath(), bl2);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(outputStreamWriter);
            IOUtils.closeQuietly(fileOutputStream);
            this.lockFile.delete();
            if (!bl3) {
                file.delete();
            }
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(outputStreamWriter);
            IOUtils.closeQuietly(fileOutputStream);
            this.lockFile.delete();
            if (!bl3) {
                file.delete();
            }
            throw runtimeException;
        }
        return outputStreamWriter;
    }

    public void close() {
        try {
            this.out.close();
            Object var2_1 = null;
            this.lockFile.delete();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lockFile.delete();
            throw throwable;
        }
    }

    public void write(int n2) {
        this.out.write(n2);
    }

    public void write(char[] cArray) {
        this.out.write(cArray);
    }

    public void write(char[] cArray, int n2, int n3) {
        this.out.write(cArray, n2, n3);
    }

    public void write(String string) {
        this.out.write(string);
    }

    public void write(String string, int n2, int n3) {
        this.out.write(string, n2, n3);
    }

    public void flush() {
        this.out.flush();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

