/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class CountingOutputStream
extends ProxyOutputStream {
    private long count;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(byte[] byArray) {
        this.count += (long)byArray.length;
        super.write(byArray);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.count += (long)n3;
        super.write(byArray, n2, n3);
    }

    public void write(int n2) {
        ++this.count;
        super.write(n2);
    }

    public synchronized int getCount() {
        long l2 = this.getByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized int resetCount() {
        long l2 = this.resetByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public synchronized long resetByteCount() {
        long l2 = this.count;
        this.count = 0L;
        return l2;
    }
}

