/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ByteArrayOutputStream
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private List buffers = new ArrayList();
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    private int count;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.needNewBuffer(n2);
    }

    private byte[] getBuffer(int n2) {
        return (byte[])this.buffers.get(n2);
    }

    private void needNewBuffer(int n2) {
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = this.getBuffer(this.currentBufferIndex);
        } else {
            int n3;
            if (this.currentBuffer == null) {
                n3 = n2;
                this.filledBufferSum = 0;
            } else {
                n3 = Math.max(this.currentBuffer.length << 1, n2 - this.filledBufferSum);
                this.filledBufferSum += this.currentBuffer.length;
            }
            ++this.currentBufferIndex;
            this.currentBuffer = new byte[n3];
            this.buffers.add(this.currentBuffer);
        }
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            int n4 = this.count + n3;
            int n5 = n3;
            int n6 = this.count - this.filledBufferSum;
            while (n5 > 0) {
                int n7 = Math.min(n5, this.currentBuffer.length - n6);
                System.arraycopy(byArray, n2 + n3 - n5, this.currentBuffer, n6, n7);
                if ((n5 -= n7) <= 0) continue;
                this.needNewBuffer(n4);
                n6 = 0;
            }
            this.count = n4;
        }
    }

    public synchronized void write(int n2) {
        int n3 = this.count - this.filledBufferSum;
        if (n3 == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
            n3 = 0;
        }
        this.currentBuffer[n3] = (byte)n2;
        ++this.count;
    }

    public synchronized int size() {
        return this.count;
    }

    public void close() {
    }

    public synchronized void reset() {
        this.count = 0;
        this.filledBufferSum = 0;
        this.currentBufferIndex = 0;
        this.currentBuffer = this.getBuffer(this.currentBufferIndex);
    }

    public synchronized void writeTo(OutputStream outputStream) {
        int n2 = this.count;
        int n3 = 0;
        while (n3 < this.buffers.size()) {
            byte[] byArray = this.getBuffer(n3);
            int n4 = Math.min(byArray.length, n2);
            outputStream.write(byArray, 0, n4);
            if ((n2 -= n4) == 0) break;
            ++n3;
        }
    }

    public synchronized byte[] toByteArray() {
        int n2 = this.count;
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.buffers.size()) {
            byte[] byArray2 = this.getBuffer(n4);
            int n5 = Math.min(byArray2.length, n2);
            System.arraycopy(byArray2, 0, byArray, n3, n5);
            n3 += n5;
            if ((n2 -= n5) == 0) break;
            ++n4;
        }
        return byArray;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String string) {
        return new String(this.toByteArray(), string);
    }
}

