/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.DataInput;
import java.io.EOFException;
import java.io.InputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.input.ProxyInputStream;

public class SwappedDataInputStream
extends ProxyInputStream
implements DataInput {
    public SwappedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public boolean readBoolean() {
        return 0 == this.readByte();
    }

    public byte readByte() {
        return (byte)this.in.read();
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public double readDouble() {
        return EndianUtils.readSwappedDouble(this.in);
    }

    public float readFloat() {
        return EndianUtils.readSwappedFloat(this.in);
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        while (n4 > 0) {
            int n5 = n2 + (n3 - n4);
            int n6 = this.read(byArray, n5, n4);
            if (-1 == n6) {
                throw new EOFException();
            }
            n4 -= n6;
        }
    }

    public int readInt() {
        return EndianUtils.readSwappedInteger(this.in);
    }

    public String readLine() {
        throw new UnsupportedOperationException("Operation not supported: readLine()");
    }

    public long readLong() {
        return EndianUtils.readSwappedLong(this.in);
    }

    public short readShort() {
        return EndianUtils.readSwappedShort(this.in);
    }

    public int readUnsignedByte() {
        return this.in.read();
    }

    public int readUnsignedShort() {
        return EndianUtils.readSwappedUnsignedShort(this.in);
    }

    public String readUTF() {
        throw new UnsupportedOperationException("Operation not supported: readUTF()");
    }

    public int skipBytes(int n2) {
        return (int)this.in.skip(n2);
    }
}

