/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class NullReader
extends Reader {
    private long size;
    private long position;
    private long mark = -1L;
    private long readlimit;
    private boolean eof;
    private boolean throwEofException;
    private boolean markSupported;

    public NullReader(long l2) {
        this(l2, true, false);
    }

    public NullReader(long l2, boolean bl2, boolean bl3) {
        this.size = l2;
        this.markSupported = bl2;
        this.throwEofException = bl3;
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    public void close() {
        this.eof = false;
        this.position = 0L;
        this.mark = -1L;
    }

    public synchronized void mark(int n2) {
        if (!this.markSupported) {
            throw new UnsupportedOperationException("Mark not supported");
        }
        this.mark = this.position;
        this.readlimit = n2;
    }

    public boolean markSupported() {
        return this.markSupported;
    }

    public int read() {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        ++this.position;
        return this.processChar();
    }

    public int read(char[] cArray) {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n2, int n3) {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += (long)n3;
        int n4 = n3;
        if (this.position > this.size) {
            n4 = n3 - (int)(this.position - this.size);
            this.position = this.size;
        }
        this.processChars(cArray, n2, n4);
        return n4;
    }

    public synchronized void reset() {
        if (!this.markSupported) {
            throw new UnsupportedOperationException("Mark not supported");
        }
        if (this.mark < 0L) {
            throw new IOException("No position has been marked");
        }
        if (this.position > this.mark + this.readlimit) {
            throw new IOException("Marked position [" + this.mark + "] is no longer valid - passed the read limit [" + this.readlimit + "]");
        }
        this.position = this.mark;
        this.eof = false;
    }

    public long skip(long l2) {
        if (this.eof) {
            throw new IOException("Skip after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += l2;
        long l3 = l2;
        if (this.position > this.size) {
            l3 = l2 - (this.position - this.size);
            this.position = this.size;
        }
        return l3;
    }

    protected int processChar() {
        return 0;
    }

    protected void processChars(char[] cArray, int n2, int n3) {
    }

    private int doEndOfFile() {
        this.eof = true;
        if (this.throwEofException) {
            throw new EOFException();
        }
        return -1;
    }
}

