/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;

public class CountingInputStream
extends ProxyInputStream {
    private long count;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read(byte[] byArray) {
        int n2 = super.read(byArray);
        this.count += n2 >= 0 ? (long)n2 : 0L;
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = super.read(byArray, n2, n3);
        this.count += n4 >= 0 ? (long)n4 : 0L;
        return n4;
    }

    public int read() {
        int n2 = super.read();
        this.count += n2 >= 0 ? 1L : 0L;
        return n2;
    }

    public long skip(long l2) {
        long l3 = super.skip(l2);
        this.count += l3;
        return l3;
    }

    public synchronized int getCount() {
        long l2 = this.getByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized int resetCount() {
        long l2 = this.resetByteCount();
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l2 + " is too large to be converted to an int");
        }
        return (int)l2;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public synchronized long resetByteCount() {
        long l2 = this.count;
        this.count = 0L;
        return l2;
    }
}

