/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFilter
extends AbstractFileFilter {
    private String[] wildcards;

    public WildcardFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
    }

    public WildcardFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = stringArray;
    }

    public WildcardFilter(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
    }

    public boolean accept(File file, String string) {
        if (file != null && new File(file, string).isDirectory()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.wildcards.length) {
            if (FilenameUtils.wildcardMatch(string, this.wildcards[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.wildcards.length) {
            if (FilenameUtils.wildcardMatch(file.getName(), this.wildcards[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

