/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SuffixFileFilter
extends AbstractFileFilter {
    private String[] suffixes;

    public SuffixFileFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{string};
    }

    public SuffixFileFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = stringArray;
    }

    public SuffixFileFilter(List list) {
        if (list == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = list.toArray(new String[list.size()]);
    }

    public boolean accept(File file) {
        String string = file.getName();
        int n2 = 0;
        while (n2 < this.suffixes.length) {
            if (string.endsWith(this.suffixes[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean accept(File file, String string) {
        int n2 = 0;
        while (n2 < this.suffixes.length) {
            if (string.endsWith(this.suffixes[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

