/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter {
    private String[] names;
    private IOCase caseSensitivity;

    public NameFileFilter(String string) {
        this(string, null);
    }

    public NameFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public NameFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = stringArray;
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(List list) {
        this(list, null);
    }

    public NameFileFilter(List list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public boolean accept(File file) {
        String string = file.getName();
        int n2 = 0;
        while (n2 < this.names.length) {
            if (this.caseSensitivity.checkEquals(string, this.names[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean accept(File file, String string) {
        int n2 = 0;
        while (n2 < this.names.length) {
            if (this.caseSensitivity.checkEquals(string, this.names[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

