/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class IOUtils {
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(reader, byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(String string) {
        return string.getBytes();
    }

    public static char[] toCharArray(InputStream inputStream) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, charArrayWriter, string);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    public static String toString(InputStream inputStream) {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string) {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(inputStream, stringWriter, string);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray) {
        return new String(byArray);
    }

    public static String toString(byte[] byArray, String string) {
        if (string == null) {
            return new String(byArray);
        }
        return new String(byArray, string);
    }

    public static List readLines(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return IOUtils.readLines(inputStreamReader);
    }

    public static List readLines(InputStream inputStream, String string) {
        if (string == null) {
            return IOUtils.readLines(inputStream);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        return IOUtils.readLines(inputStreamReader);
    }

    public static List readLines(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = bufferedReader.readLine();
        while (string != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
        }
        return arrayList;
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) {
        InputStreamReader inputStreamReader = null;
        inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        return new LineIterator(inputStreamReader);
    }

    public static InputStream toInputStream(String string) {
        byte[] byArray = string.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public static InputStream toInputStream(String string, String string2) {
        byte[] byArray = string2 != null ? string.getBytes(string2) : string.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public static void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public static void write(byte[] byArray, Writer writer) {
        if (byArray != null) {
            writer.write(new String(byArray));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) {
        if (byArray != null) {
            if (string == null) {
                IOUtils.write(byArray, writer);
            } else {
                writer.write(new String(byArray, string));
            }
        }
    }

    public static void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream) {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes());
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) {
        if (cArray != null) {
            if (string == null) {
                IOUtils.write(cArray, outputStream);
            } else {
                outputStream.write(new String(cArray).getBytes(string));
            }
        }
    }

    public static void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    public static void write(String string, OutputStream outputStream) {
        if (string != null) {
            outputStream.write(string.getBytes());
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) {
        if (string != null) {
            if (string2 == null) {
                IOUtils.write(string, outputStream);
            } else {
                outputStream.write(string.getBytes(string2));
            }
        }
    }

    public static void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream) {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes());
        }
    }

    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            if (string == null) {
                IOUtils.write(stringBuffer, outputStream);
            } else {
                outputStream.write(stringBuffer.toString().getBytes(string));
            }
        }
    }

    public static void writeLines(Collection collection, String string, OutputStream outputStream) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                outputStream.write(e2.toString().getBytes());
            }
            outputStream.write(string.getBytes());
        }
    }

    public static void writeLines(Collection collection, String string, OutputStream outputStream, String string2) {
        if (string2 == null) {
            IOUtils.writeLines(collection, string, outputStream);
        } else {
            if (collection == null) {
                return;
            }
            if (string == null) {
                string = LINE_SEPARATOR;
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 != null) {
                    outputStream.write(e2.toString().getBytes(string2));
                }
                outputStream.write(string.getBytes(string2));
            }
        }
    }

    public static void writeLines(Collection collection, String string, Writer writer) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = LINE_SEPARATOR;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                writer.write(e2.toString());
            }
            writer.write(string);
        }
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static void copy(InputStream inputStream, Writer writer) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        IOUtils.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        if (string == null) {
            IOUtils.copy(inputStream, writer);
        } else {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            IOUtils.copy((Reader)inputStreamReader, writer);
        }
    }

    public static int copy(Reader reader, Writer writer) {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        char[] cArray = new char[4096];
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static void copy(Reader reader, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) {
        if (string == null) {
            IOUtils.copy(reader, outputStream);
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            IOUtils.copy(reader, (Writer)outputStreamWriter);
            outputStreamWriter.flush();
        }
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n3 = inputStream.read();
        while (-1 != n3) {
            n2 = inputStream2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = inputStream.read();
        }
        n2 = inputStream2.read();
        return n2 == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        int n2;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        if (!(reader2 instanceof BufferedReader)) {
            reader2 = new BufferedReader(reader2);
        }
        int n3 = reader.read();
        while (-1 != n3) {
            n2 = reader2.read();
            if (n3 != n2) {
                return false;
            }
            n3 = reader.read();
        }
        n2 = reader2.read();
        return n2 == -1;
    }

    static {
        StringWriter stringWriter = new StringWriter(4);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        LINE_SEPARATOR = stringWriter.toString();
    }
}

