/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final StringBuffer _lbuffer = new StringBuffer(8);
    private static final StringBuffer _cbuffer = new StringBuffer(2);
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] byArray, long l2, OutputStream outputStream, int n2) {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n2 + " into array of length " + byArray.length);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l3 = l2 + (long)n2;
        StringBuffer stringBuffer = new StringBuffer(74);
        int n3 = n2;
        while (n3 < byArray.length) {
            int n4 = byArray.length - n3;
            if (n4 > 16) {
                n4 = 16;
            }
            stringBuffer.append((Object)HexDump.dump(l3)).append(' ');
            int n5 = 0;
            while (n5 < 16) {
                if (n5 < n4) {
                    stringBuffer.append((Object)HexDump.dump(byArray[n5 + n3]));
                } else {
                    stringBuffer.append("  ");
                }
                stringBuffer.append(' ');
                ++n5;
            }
            int n6 = 0;
            while (n6 < n4) {
                if (byArray[n6 + n3] >= 32 && byArray[n6 + n3] < 127) {
                    stringBuffer.append((char)byArray[n6 + n3]);
                } else {
                    stringBuffer.append('.');
                }
                ++n6;
            }
            stringBuffer.append(EOL);
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.flush();
            stringBuffer.setLength(0);
            l3 += (long)n4;
            n3 += 16;
        }
    }

    private static StringBuffer dump(long l2) {
        _lbuffer.setLength(0);
        int n2 = 0;
        while (n2 < 8) {
            _lbuffer.append(_hexcodes[(int)(l2 >> _shifts[n2]) & 0xF]);
            ++n2;
        }
        return _lbuffer;
    }

    private static StringBuffer dump(byte by2) {
        _cbuffer.setLength(0);
        int n2 = 0;
        while (n2 < 2) {
            _cbuffer.append(_hexcodes[by2 >> _shifts[n2 + 6] & 0xF]);
            ++n2;
        }
        return _cbuffer;
    }
}

