/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    public static String normalize(String string) {
        return FilenameUtils.doNormalize(string, true);
    }

    public static String normalizeNoEndSeparator(String string) {
        return FilenameUtils.doNormalize(string, false);
    }

    private static String doNormalize(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = FilenameUtils.getPrefixLength(string);
        if (n3 < 0) {
            return null;
        }
        char[] cArray = new char[n2 + 2];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        while (n4 < cArray.length) {
            if (cArray[n4] == OTHER_SEPARATOR) {
                cArray[n4] = SYSTEM_SEPARATOR;
            }
            ++n4;
        }
        boolean bl3 = true;
        if (cArray[n2 - 1] != SYSTEM_SEPARATOR) {
            cArray[n2++] = SYSTEM_SEPARATOR;
            bl3 = false;
        }
        int n5 = n3 + 1;
        while (n5 < n2) {
            if (cArray[n5] == SYSTEM_SEPARATOR && cArray[n5 - 1] == SYSTEM_SEPARATOR) {
                System.arraycopy(cArray, n5, cArray, n5 - 1, n2 - n5);
                --n2;
                --n5;
            }
            ++n5;
        }
        int n6 = n3 + 1;
        while (n6 < n2) {
            if (cArray[n6] == SYSTEM_SEPARATOR && cArray[n6 - 1] == '.' && (n6 == n3 + 1 || cArray[n6 - 2] == SYSTEM_SEPARATOR)) {
                if (n6 == n2 - 1) {
                    bl3 = true;
                }
                System.arraycopy(cArray, n6 + 1, cArray, n6 - 1, n2 - n6);
                n2 -= 2;
                --n6;
            }
            ++n6;
        }
        int n7 = n3 + 2;
        while (n7 < n2) {
            block20: {
                if (cArray[n7] == SYSTEM_SEPARATOR && cArray[n7 - 1] == '.' && cArray[n7 - 2] == '.' && (n7 == n3 + 2 || cArray[n7 - 3] == SYSTEM_SEPARATOR)) {
                    if (n7 == n3 + 2) {
                        return null;
                    }
                    if (n7 == n2 - 1) {
                        bl3 = true;
                    }
                    int n8 = n7 - 4;
                    while (n8 >= n3) {
                        if (cArray[n8] == SYSTEM_SEPARATOR) {
                            System.arraycopy(cArray, n7 + 1, cArray, n8 + 1, n2 - n7);
                            n2 -= n7 - n8;
                            n7 = n8 + 1;
                            break block20;
                        }
                        --n8;
                    }
                    System.arraycopy(cArray, n7 + 1, cArray, n3, n2 - n7);
                    n2 -= n7 + 1 - n3;
                    n7 = n3 + 1;
                }
            }
            ++n7;
        }
        if (n2 <= 0) {
            return "";
        }
        if (n2 <= n3) {
            return new String(cArray, 0, n2);
        }
        if (bl3 && bl2) {
            return new String(cArray, 0, n2);
        }
        return new String(cArray, 0, n2 - 1);
    }

    public static String concat(String string, String string2) {
        int n2 = FilenameUtils.getPrefixLength(string2);
        if (n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            return FilenameUtils.normalize(string2);
        }
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return FilenameUtils.normalize(string2);
        }
        char c2 = string.charAt(n3 - 1);
        if (FilenameUtils.isSeparator(c2)) {
            return FilenameUtils.normalize(string + string2);
        }
        return FilenameUtils.normalize(string + '/' + string2);
    }

    public static String separatorsToUnix(String string) {
        if (string == null || string.indexOf(92) == -1) {
            return string;
        }
        return string.replace('\\', '/');
    }

    public static String separatorsToWindows(String string) {
        if (string == null || string.indexOf(47) == -1) {
            return string;
        }
        return string.replace('/', '\\');
    }

    public static String separatorsToSystem(String string) {
        if (string == null) {
            return null;
        }
        if (FilenameUtils.isSystemWindows()) {
            return FilenameUtils.separatorsToWindows(string);
        }
        return FilenameUtils.separatorsToUnix(string);
    }

    public static int getPrefixLength(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        char c2 = string.charAt(0);
        if (c2 == ':') {
            return -1;
        }
        if (n2 == 1) {
            if (c2 == '~') {
                return 2;
            }
            return FilenameUtils.isSeparator(c2) ? 1 : 0;
        }
        if (c2 == '~') {
            int n3 = string.indexOf(47, 1);
            int n4 = string.indexOf(92, 1);
            if (n3 == -1 && n4 == -1) {
                return n2 + 1;
            }
            n3 = n3 == -1 ? n4 : n3;
            n4 = n4 == -1 ? n3 : n4;
            return Math.min(n3, n4) + 1;
        }
        char c3 = string.charAt(1);
        if (c3 == ':') {
            if ((c2 = Character.toUpperCase(c2)) >= 'A' && c2 <= 'Z') {
                if (n2 == 2 || !FilenameUtils.isSeparator(string.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator(c2) && FilenameUtils.isSeparator(c3)) {
            int n5 = string.indexOf(47, 2);
            int n6 = string.indexOf(92, 2);
            if (n5 == -1 && n6 == -1 || n5 == 2 || n6 == 2) {
                return -1;
            }
            n5 = n5 == -1 ? n6 : n5;
            n6 = n6 == -1 ? n5 : n6;
            return Math.min(n5, n6) + 1;
        }
        return FilenameUtils.isSeparator(c2) ? 1 : 0;
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static int indexOfExtension(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(46);
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        return n3 > n2 ? -1 : n2;
    }

    public static String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 > string.length()) {
            return string + '/';
        }
        return string.substring(0, n2);
    }

    public static String getPath(String string) {
        return FilenameUtils.doGetPath(string, 1);
    }

    public static String getPathNoEndSeparator(String string) {
        return FilenameUtils.doGetPath(string, 0);
    }

    private static String doGetPath(String string, int n2) {
        if (string == null) {
            return null;
        }
        int n3 = FilenameUtils.getPrefixLength(string);
        if (n3 < 0) {
            return null;
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 >= string.length() || n4 < 0) {
            return "";
        }
        return string.substring(n3, n4 + n2);
    }

    public static String getFullPath(String string) {
        return FilenameUtils.doGetFullPath(string, true);
    }

    public static String getFullPathNoEndSeparator(String string) {
        return FilenameUtils.doGetFullPath(string, false);
    }

    private static String doGetFullPath(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= string.length()) {
            if (bl2) {
                return FilenameUtils.getPrefix(string);
            }
            return string;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 < 0) {
            return string.substring(0, n2);
        }
        int n4 = n3 + (bl2 ? 1 : 0);
        return string.substring(0, n4);
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfLastSeparator(string);
        return string.substring(n2 + 1);
    }

    public static String getBaseName(String string) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string));
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String removeExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static boolean equals(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SENSITIVE);
    }

    public static boolean equalsOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SYSTEM);
    }

    public static boolean equalsNormalized(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SYSTEM);
    }

    public static boolean equals(String string, String string2, boolean bl2, IOCase iOCase) {
        if (string == null || string2 == null) {
            return string == string2;
        }
        if (bl2) {
            string = FilenameUtils.normalize(string);
            string2 = FilenameUtils.normalize(string2);
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        return iOCase.checkEquals(string, string2);
    }

    public static boolean isExtension(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string3 = FilenameUtils.getExtension(string);
        return string3.equals(string2);
    }

    public static boolean isExtension(String string, String[] stringArray) {
        if (string == null) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string2 = FilenameUtils.getExtension(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isExtension(String string, Collection collection) {
        if (string == null) {
            return false;
        }
        if (collection == null || collection.isEmpty()) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string2 = FilenameUtils.getExtension(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!string2.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardMatch(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatchOnSystem(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SYSTEM);
    }

    public static boolean wildcardMatch(String string, String string2, IOCase iOCase) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (iOCase == null) {
            iOCase = IOCase.SENSITIVE;
        }
        string = iOCase.convertCase(string);
        string2 = iOCase.convertCase(string2);
        String[] stringArray = FilenameUtils.splitOnTokens(string2);
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        Stack<int[]> stack = new Stack<int[]>();
        do {
            if (stack.size() > 0) {
                int[] nArray = (int[])stack.pop();
                n3 = nArray[0];
                n2 = nArray[1];
                bl2 = true;
            }
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals("?")) {
                    ++n2;
                    bl2 = false;
                } else if (stringArray[n3].equals("*")) {
                    bl2 = true;
                    if (n3 == stringArray.length - 1) {
                        n2 = string.length();
                    }
                } else {
                    if (bl2) {
                        if ((n2 = string.indexOf(stringArray[n3], n2)) == -1) break;
                        int n4 = string.indexOf(stringArray[n3], n2 + 1);
                        if (n4 >= 0) {
                            stack.push(new int[]{n3, n4});
                        }
                    } else if (!string.startsWith(stringArray[n3], n2)) break;
                    n2 += stringArray[n3].length();
                    bl2 = false;
                }
                ++n3;
            }
            if (n3 != stringArray.length || n2 != string.length()) continue;
            return true;
        } while (stack.size() > 0);
        return false;
    }

    static String[] splitOnTokens(String string) {
        if (string.indexOf("?") == -1 && string.indexOf("*") == -1) {
            return new String[]{string};
        }
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '?' || cArray[n2] == '*') {
                if (stringBuffer.length() != 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                if (cArray[n2] == '?') {
                    arrayList.add("?");
                } else if (arrayList.size() == 0 || n2 > 0 && !arrayList.get(arrayList.size() - 1).equals("*")) {
                    arrayList.add("*");
                }
            } else {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        if (stringBuffer.length() != 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

