/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileSystemUtils {
    private static final FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final int INIT_PROBLEM = -1;
    private static final int OTHER = 0;
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int POSIX_UNIX = 3;
    private static final int OS;

    public static long freeSpace(String string) {
        return INSTANCE.freeSpaceOS(string, OS, false);
    }

    public static long freeSpaceKb(String string) {
        return INSTANCE.freeSpaceOS(string, OS, true);
    }

    long freeSpaceOS(String string, int n2, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        switch (n2) {
            case 1: {
                return bl2 ? this.freeSpaceWindows(string) / 1024L : this.freeSpaceWindows(string);
            }
            case 2: {
                return this.freeSpaceUnix(string, bl2, false);
            }
            case 3: {
                return this.freeSpaceUnix(string, bl2, true);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    long freeSpaceWindows(String string) {
        if ((string = FilenameUtils.normalize(string)).length() > 2 && string.charAt(1) == ':') {
            string = string.substring(0, 2);
        }
        String[] stringArray = new String[]{"cmd.exe", "/C", "dir /-c " + string};
        List list = this.performCommand(stringArray, Integer.MAX_VALUE);
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            String string2 = (String)list.get(n2);
            if (string2.length() > 0) {
                return this.parseDir(string2, string);
            }
            --n2;
        }
        throw new IOException("Command line 'dir /-c' did not return any info for path '" + string + "'");
    }

    long parseDir(String string, String string2) {
        char c2;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length() - 1;
        while (n4 >= 0) {
            c2 = string.charAt(n4);
            if (Character.isDigit(c2)) {
                n3 = n4 + 1;
                break;
            }
            --n4;
        }
        while (n4 >= 0) {
            c2 = string.charAt(n4);
            if (!Character.isDigit(c2) && c2 != ',' && c2 != '.') {
                n2 = n4 + 1;
                break;
            }
            --n4;
        }
        if (n4 < 0) {
            throw new IOException("Command line 'dir /-c' did not return valid info for path '" + string2 + "'");
        }
        StringBuffer stringBuffer = new StringBuffer(string.substring(n2, n3));
        int n5 = 0;
        while (n5 < stringBuffer.length()) {
            if (stringBuffer.charAt(n5) == ',' || stringBuffer.charAt(n5) == '.') {
                stringBuffer.deleteCharAt(n5--);
            }
            ++n5;
        }
        return this.parseBytes(stringBuffer.toString(), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long freeSpaceUnix(String string, boolean bl2, boolean bl3) {
        String string2;
        String[] stringArray;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        string = FilenameUtils.normalize(string);
        String string3 = "-";
        if (bl2) {
            string3 = string3 + "k";
        }
        if (bl3) {
            string3 = string3 + "P";
        }
        if (string3.length() > 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "df";
            stringArray2[1] = string3;
            stringArray = stringArray2;
            stringArray2[2] = string;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "df";
            stringArray = stringArray3;
            stringArray3[1] = string;
        }
        String[] stringArray4 = stringArray;
        List list = this.performCommand(stringArray4, 3);
        if (list.size() < 2) {
            throw new IOException("Command line 'df' did not return info as expected for path '" + string + "'- response was " + list);
        }
        String string4 = (String)list.get(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
        if (stringTokenizer.countTokens() < 4) {
            if (stringTokenizer.countTokens() != 1 || list.size() < 3) throw new IOException("Command line 'df' did not return data as expected for path '" + string + "'- check path is valid");
            string2 = (String)list.get(2);
            stringTokenizer = new StringTokenizer(string2, " ");
        } else {
            stringTokenizer.nextToken();
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        return this.parseBytes(string2, string);
    }

    long parseBytes(String string, String string2) {
        try {
            long l2 = Long.parseLong(string);
            if (l2 < 0L) {
                throw new IOException("Command line 'df' did not find free space in response for path '" + string2 + "'- check path is valid");
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Command line 'df' did not return numeric data as expected for path '" + string2 + "'- check path is valid");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List performCommand(String[] stringArray, int n2) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>(20);
        Process process = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        InputStream inputStream2 = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                process = this.openProcess(stringArray);
                inputStream = process.getInputStream();
                outputStream = process.getOutputStream();
                inputStream2 = process.getErrorStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                while (true) {
                    if (string == null || arrayList2.size() >= n2) {
                        process.waitFor();
                        if (process.exitValue() == 0) break;
                        throw new IOException("Command line returned OS error code '" + process.exitValue() + "' for command " + Arrays.asList(stringArray));
                    }
                    string = string.toLowerCase().trim();
                    arrayList2.add(string);
                    string = bufferedReader.readLine();
                }
                if (arrayList2.size() == 0) {
                    throw new IOException("Command line did not return any info for command " + Arrays.asList(stringArray));
                }
                arrayList = arrayList2;
                Object var12_12 = null;
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Command line threw an InterruptedException '" + interruptedException.getMessage() + "' for command " + Arrays.asList(stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream2);
            IOUtils.closeQuietly(bufferedReader);
            if (process == null) throw throwable;
            process.destroy();
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        IOUtils.closeQuietly(inputStream2);
        IOUtils.closeQuietly(bufferedReader);
        if (process == null) return arrayList;
        process.destroy();
        return arrayList;
    }

    Process openProcess(String[] stringArray) {
        return Runtime.getRuntime().exec(stringArray);
    }

    static {
        int n2 = 0;
        try {
            String string = System.getProperty("os.name");
            if (string == null) {
                throw new IOException("os.name not found");
            }
            n2 = (string = string.toLowerCase()).indexOf("windows") != -1 ? 1 : (string.indexOf("linux") != -1 || string.indexOf("sun os") != -1 || string.indexOf("sunos") != -1 || string.indexOf("solaris") != -1 || string.indexOf("mpe/ix") != -1 || string.indexOf("freebsd") != -1 || string.indexOf("irix") != -1 || string.indexOf("digital unix") != -1 || string.indexOf("unix") != -1 || string.indexOf("mac os x") != -1 ? 2 : (string.indexOf("hp-ux") != -1 || string.indexOf("aix") != -1 ? 3 : 0));
        }
        catch (Exception exception) {
            n2 = -1;
        }
        OS = n2;
    }
}

