/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public abstract class DirectoryWalker {
    private final FileFilter filter;
    private final int depthLimit;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(FileFilter fileFilter, int n2) {
        this.filter = fileFilter;
        this.depthLimit = n2;
    }

    protected DirectoryWalker(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, int n2) {
        if (iOFileFilter == null && iOFileFilter2 == null) {
            this.filter = null;
        } else {
            iOFileFilter = iOFileFilter != null ? iOFileFilter : TrueFileFilter.TRUE;
            iOFileFilter2 = iOFileFilter2 != null ? iOFileFilter2 : TrueFileFilter.TRUE;
            iOFileFilter = FileFilterUtils.makeDirectoryOnly(iOFileFilter);
            iOFileFilter2 = FileFilterUtils.makeFileOnly(iOFileFilter2);
            this.filter = FileFilterUtils.orFileFilter(iOFileFilter, iOFileFilter2);
        }
        this.depthLimit = n2;
    }

    protected final void walk(File file, Collection collection) {
        if (file == null) {
            throw new NullPointerException("Start Directory is null");
        }
        try {
            this.handleStart(file, collection);
            this.walk(file, 0, collection);
            this.handleEnd(collection);
        }
        catch (CancelException cancelException) {
            this.handleCancelled(file, collection, cancelException);
        }
    }

    private void walk(File file, int n2, Collection collection) {
        this.checkIfCancelled(file, n2, collection);
        if (this.handleDirectory(file, n2, collection)) {
            this.handleDirectoryStart(file, n2, collection);
            int n3 = n2 + 1;
            if (this.depthLimit < 0 || n3 <= this.depthLimit) {
                File[] fileArray;
                this.checkIfCancelled(file, n2, collection);
                File[] fileArray2 = fileArray = this.filter == null ? file.listFiles() : file.listFiles(this.filter);
                if (fileArray == null) {
                    this.handleRestricted(file, n3, collection);
                } else {
                    int n4 = 0;
                    while (n4 < fileArray.length) {
                        File file2 = fileArray[n4];
                        if (file2.isDirectory()) {
                            this.walk(file2, n3, collection);
                        } else {
                            this.checkIfCancelled(file2, n3, collection);
                            this.handleFile(file2, n3, collection);
                            this.checkIfCancelled(file2, n3, collection);
                        }
                        ++n4;
                    }
                }
            }
            this.handleDirectoryEnd(file, n2, collection);
        }
        this.checkIfCancelled(file, n2, collection);
    }

    protected final void checkIfCancelled(File file, int n2, Collection collection) {
        if (this.handleIsCancelled(file, n2, collection)) {
            throw new CancelException(file, n2);
        }
    }

    protected boolean handleIsCancelled(File file, int n2, Collection collection) {
        return false;
    }

    protected void handleCancelled(File file, Collection collection, CancelException cancelException) {
        throw cancelException;
    }

    protected void handleStart(File file, Collection collection) {
    }

    protected boolean handleDirectory(File file, int n2, Collection collection) {
        return true;
    }

    protected void handleDirectoryStart(File file, int n2, Collection collection) {
    }

    protected void handleFile(File file, int n2, Collection collection) {
    }

    protected void handleRestricted(File file, int n2, Collection collection) {
    }

    protected void handleDirectoryEnd(File file, int n2, Collection collection) {
    }

    protected void handleEnd(Collection collection) {
    }

    public static class CancelException
    extends IOException {
        private static final long serialVersionUID = 1347339620135041008L;
        private File file;
        private int depth = -1;

        public CancelException(File file, int n2) {
            this("Operation Cancelled", file, n2);
        }

        public CancelException(String string, File file, int n2) {
            super(string);
            this.file = file;
            this.depth = n2;
        }

        public File getFile() {
            return this.file;
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

