/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class CopyUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void copy(byte[] byArray, OutputStream outputStream) {
        outputStream.write(byArray);
    }

    public static void copy(byte[] byArray, Writer writer) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CopyUtils.copy((InputStream)byteArrayInputStream, writer);
    }

    public static void copy(byte[] byArray, Writer writer, String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CopyUtils.copy(byteArrayInputStream, writer, string);
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[4096];
        int n2 = 0;
        int n3 = 0;
        while (-1 != (n3 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n3);
            n2 += n3;
        }
        return n2;
    }

    public static int copy(Reader reader, Writer writer) {
        char[] cArray = new char[4096];
        int n2 = 0;
        int n3 = 0;
        while (-1 != (n3 = reader.read(cArray))) {
            writer.write(cArray, 0, n3);
            n2 += n3;
        }
        return n2;
    }

    public static void copy(InputStream inputStream, Writer writer) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        CopyUtils.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        CopyUtils.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(Reader reader, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        CopyUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(String string, OutputStream outputStream) {
        StringReader stringReader = new StringReader(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        CopyUtils.copy((Reader)stringReader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(String string, Writer writer) {
        writer.write(string);
    }
}

