/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.awt.Color;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.Subroutine;

public class Subroutines {
    private Hashtable subroutines = new Hashtable();
    public final Subroutine TOPLEVEL;

    public Subroutines(MethodGen methodGen) {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        InstructionHandle[] instructionHandleArray = methodGen.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl(this);
        HashSet<InstructionHandle> hashSet = new HashSet<InstructionHandle>();
        InstructionHandle instructionHandle = instructionHandleArray[0];
        int n2 = 0;
        while (n2 < instructionHandleArray.length) {
            object2 = instructionHandleArray[n2].getInstruction();
            if (object2 instanceof JsrInstruction) {
                hashSet.add(((JsrInstruction)object2).getTarget());
            }
            ++n2;
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            SubroutineImpl subroutineImpl = new SubroutineImpl(this);
            serializable2 = (InstructionHandle)object2.next();
            subroutineImpl.setLocalVariable(((ASTORE)((InstructionHandle)serializable2).getInstruction()).getIndex());
            this.subroutines.put(serializable2, subroutineImpl);
        }
        this.subroutines.put(instructionHandleArray[0], this.TOPLEVEL);
        hashSet.add(instructionHandleArray[0]);
        int n3 = 0;
        while (n3 < instructionHandleArray.length) {
            serializable2 = instructionHandleArray[n3].getInstruction();
            if (serializable2 instanceof JsrInstruction) {
                serializable = ((JsrInstruction)serializable2).getTarget();
                ((SubroutineImpl)this.getSubroutine((InstructionHandle)serializable)).addEnteringJsrInstruction(instructionHandleArray[n3]);
            }
            ++n3;
        }
        serializable2 = new HashSet();
        serializable = new Hashtable();
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            int n4;
            InstructionHandle instructionHandle2 = (InstructionHandle)object2.next();
            int n5 = 0;
            while (n5 < instructionHandleArray.length) {
                ((Hashtable)serializable).put(instructionHandleArray[n5], Color.white);
                ++n5;
            }
            ((Hashtable)serializable).put(instructionHandle2, Color.gray);
            object = new ArrayList<InstructionHandle>();
            ((ArrayList)object).add(instructionHandle2);
            if (instructionHandle2 == instructionHandleArray[0]) {
                n4 = 0;
                while (n4 < codeExceptionGenArray.length) {
                    ((Hashtable)serializable).put(codeExceptionGenArray[n4].getHandlerPC(), Color.gray);
                    ((ArrayList)object).add(codeExceptionGenArray[n4].getHandlerPC());
                    ++n4;
                }
            }
            while (((ArrayList)object).size() != 0) {
                InstructionHandle instructionHandle3 = (InstructionHandle)((ArrayList)object).remove(0);
                InstructionHandle[] instructionHandleArray2 = Subroutines.getSuccessors(instructionHandle3);
                int n6 = 0;
                while (n6 < instructionHandleArray2.length) {
                    if ((Color)((Hashtable)serializable).get(instructionHandleArray2[n6]) == Color.white) {
                        ((Hashtable)serializable).put(instructionHandleArray2[n6], Color.gray);
                        ((ArrayList)object).add(instructionHandleArray2[n6]);
                    }
                    ++n6;
                }
                ((Hashtable)serializable).put(instructionHandle3, Color.black);
            }
            n4 = 0;
            while (n4 < instructionHandleArray.length) {
                if (((Hashtable)serializable).get(instructionHandleArray[n4]) == Color.black) {
                    ((SubroutineImpl)(instructionHandle2 == instructionHandleArray[0] ? this.getTopLevel() : this.getSubroutine(instructionHandle2))).addInstruction(instructionHandleArray[n4]);
                    if (((HashSet)serializable2).contains(instructionHandleArray[n4])) {
                        throw new StructuralCodeConstraintException("Instruction '" + instructionHandleArray[n4] + "' is part of more than one subroutine (or of the top level and a subroutine).");
                    }
                    ((HashSet)serializable2).add(instructionHandleArray[n4]);
                }
                ++n4;
            }
            if (instructionHandle2 == instructionHandleArray[0]) continue;
            ((SubroutineImpl)this.getSubroutine(instructionHandle2)).setLeavingRET();
        }
        int n7 = 0;
        while (n7 < codeExceptionGenArray.length) {
            InstructionHandle instructionHandle4 = codeExceptionGenArray[n7].getStartPC();
            while (instructionHandle4 != codeExceptionGenArray[n7].getEndPC().getNext()) {
                object = this.subroutines.elements();
                while (object.hasMoreElements()) {
                    Subroutine subroutine = (Subroutine)object.nextElement();
                    if (subroutine == this.subroutines.get(instructionHandleArray[0]) || !subroutine.contains(instructionHandle4)) continue;
                    throw new StructuralCodeConstraintException("Subroutine instruction '" + instructionHandle4 + "' is protected by an exception handler, '" + codeExceptionGenArray[n7] + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                }
                instructionHandle4 = instructionHandle4.getNext();
            }
            ++n7;
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet());
    }

    private void noRecursiveCalls(Subroutine subroutine, HashSet hashSet) {
        Subroutine[] subroutineArray = subroutine.subSubs();
        int n2 = 0;
        while (n2 < subroutineArray.length) {
            int n3 = ((RET)subroutineArray[n2].getLeavingRET().getInstruction()).getIndex();
            if (!hashSet.add(new Integer(n3))) {
                SubroutineImpl subroutineImpl = (SubroutineImpl)subroutineArray[n2];
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + SubroutineImpl.access$000(subroutineImpl) + "', JSRs '" + SubroutineImpl.access$100(subroutineImpl) + "', RET '" + SubroutineImpl.access$200(subroutineImpl) + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(subroutineArray[n2], hashSet);
            hashSet.remove(new Integer(n3));
            ++n2;
        }
    }

    public Subroutine getSubroutine(InstructionHandle instructionHandle) {
        Subroutine subroutine = (Subroutine)this.subroutines.get(instructionHandle);
        if (subroutine == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (subroutine == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return subroutine;
    }

    public Subroutine subroutineOf(InstructionHandle instructionHandle) {
        Iterator iterator = this.subroutines.values().iterator();
        while (iterator.hasNext()) {
            Subroutine subroutine = (Subroutine)iterator.next();
            if (!subroutine.contains(instructionHandle)) continue;
            return subroutine;
        }
        System.err.println("DEBUG: Please verify '" + instructionHandle + "' lies in dead code.");
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instructionHandle) {
        InstructionHandle[] instructionHandleArray = new InstructionHandle[]{};
        InstructionHandle[] instructionHandleArray2 = new InstructionHandle[1];
        InstructionHandle[] instructionHandleArray3 = new InstructionHandle[2];
        Instruction instruction = instructionHandle.getInstruction();
        if (instruction instanceof RET) {
            return instructionHandleArray;
        }
        if (instruction instanceof ReturnInstruction) {
            return instructionHandleArray;
        }
        if (instruction instanceof ATHROW) {
            return instructionHandleArray;
        }
        if (instruction instanceof JsrInstruction) {
            instructionHandleArray2[0] = instructionHandle.getNext();
            return instructionHandleArray2;
        }
        if (instruction instanceof GotoInstruction) {
            instructionHandleArray2[0] = ((GotoInstruction)instruction).getTarget();
            return instructionHandleArray2;
        }
        if (instruction instanceof BranchInstruction) {
            if (instruction instanceof Select) {
                InstructionHandle[] instructionHandleArray4 = ((Select)instruction).getTargets();
                InstructionHandle[] instructionHandleArray5 = new InstructionHandle[instructionHandleArray4.length + 1];
                instructionHandleArray5[0] = ((Select)instruction).getTarget();
                System.arraycopy(instructionHandleArray4, 0, instructionHandleArray5, 1, instructionHandleArray4.length);
                return instructionHandleArray5;
            }
            instructionHandleArray3[0] = instructionHandle.getNext();
            instructionHandleArray3[1] = ((BranchInstruction)instruction).getTarget();
            return instructionHandleArray3;
        }
        instructionHandleArray2[0] = instructionHandle.getNext();
        return instructionHandleArray2;
    }

    public String toString() {
        return "---\n" + this.subroutines.toString() + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private final int UNSET = -1;
        private int localVariable;
        private HashSet instructions;
        private HashSet theJSRs;
        private InstructionHandle theRET;
        private final Subroutines this$0;

        public boolean contains(InstructionHandle instructionHandle) {
            return this.instructions.contains(instructionHandle);
        }

        public String toString() {
            String string = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions.toString() + "'.";
            string = string + " Accessed local variable slots: '";
            int[] nArray = this.getAccessedLocalsIndices();
            int n2 = 0;
            while (n2 < nArray.length) {
                string = string + nArray[n2] + " ";
                ++n2;
            }
            string = string + "'.";
            string = string + " Recursively (via subsub...routines) accessed local variable slots: '";
            nArray = this.getRecursivelyAccessedLocalsIndices();
            int n3 = 0;
            while (n3 < nArray.length) {
                string = string + nArray[n3] + " ";
                ++n3;
            }
            string = string + "'.";
            return string;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            Iterator iterator = this.instructions.iterator();
            InstructionHandle instructionHandle = null;
            while (iterator.hasNext()) {
                InstructionHandle instructionHandle2 = (InstructionHandle)iterator.next();
                if (!(instructionHandle2.getInstruction() instanceof RET)) continue;
                if (instructionHandle != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + instructionHandle + "' and '" + instructionHandle2 + "'.");
                }
                instructionHandle = instructionHandle2;
            }
            if (instructionHandle == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)instructionHandle.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + instructionHandle + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = instructionHandle;
        }

        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == this.this$0.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.theJSRs.size()];
            return ((AbstractCollection)this.theJSRs).toArray(instructionHandleArray);
        }

        public void addEnteringJsrInstruction(InstructionHandle instructionHandle) {
            if (instructionHandle == null || !(instructionHandle.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)instructionHandle.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(instructionHandle);
        }

        public InstructionHandle getLeavingRET() {
            if (this == this.this$0.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        public InstructionHandle[] getInstructions() {
            InstructionHandle[] instructionHandleArray = new InstructionHandle[this.instructions.size()];
            return ((AbstractCollection)this.instructions).toArray(instructionHandleArray);
        }

        void addInstruction(InstructionHandle instructionHandle) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(instructionHandle);
        }

        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int[] nArray = this.getAccessedLocalsIndices();
            int n2 = 0;
            while (n2 < nArray.length) {
                hashSet.add(new Integer(nArray[n2]));
                ++n2;
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(hashSet, this.subSubs());
            int[] nArray2 = new int[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n3 = -1;
            while (iterator.hasNext()) {
                nArray2[++n3] = (Integer)iterator.next();
            }
            return nArray2;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(HashSet hashSet, Subroutine[] subroutineArray) {
            int n2 = 0;
            while (n2 < subroutineArray.length) {
                int[] nArray = subroutineArray[n2].getAccessedLocalsIndices();
                int n3 = 0;
                while (n3 < nArray.length) {
                    hashSet.add(new Integer(nArray[n3]));
                    ++n3;
                }
                if (subroutineArray[n2].subSubs().length != 0) {
                    this._getRecursivelyAccessedLocalsIndicesHelper(hashSet, subroutineArray[n2].subSubs());
                }
                ++n2;
            }
        }

        public int[] getAccessedLocalsIndices() {
            int n2;
            Object object;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (this.theRET == null && this != this.this$0.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            Iterator iterator = this.instructions.iterator();
            while (iterator.hasNext()) {
                object = (InstructionHandle)iterator.next();
                if (!(((InstructionHandle)object).getInstruction() instanceof LocalVariableInstruction) && !(((InstructionHandle)object).getInstruction() instanceof RET)) continue;
                n2 = ((IndexedInstruction)((Object)((InstructionHandle)object).getInstruction())).getIndex();
                hashSet.add(new Integer(n2));
                try {
                    int n3;
                    if (!(((InstructionHandle)object).getInstruction() instanceof LocalVariableInstruction) || (n3 = ((LocalVariableInstruction)((InstructionHandle)object).getInstruction()).getType(null).getSize()) != 2) continue;
                    hashSet.add(new Integer(n2 + 1));
                }
                catch (RuntimeException runtimeException) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.");
                }
            }
            object = new int[hashSet.size()];
            iterator = hashSet.iterator();
            n2 = -1;
            while (iterator.hasNext()) {
                object[++n2] = (Integer)iterator.next();
            }
            return object;
        }

        public Subroutine[] subSubs() {
            Object object;
            HashSet<Subroutine> hashSet = new HashSet<Subroutine>();
            Iterator iterator = this.instructions.iterator();
            while (iterator.hasNext()) {
                object = ((InstructionHandle)iterator.next()).getInstruction();
                if (!(object instanceof JsrInstruction)) continue;
                InstructionHandle instructionHandle = ((JsrInstruction)object).getTarget();
                hashSet.add(this.this$0.getSubroutine(instructionHandle));
            }
            object = new Subroutine[hashSet.size()];
            return ((AbstractCollection)hashSet).toArray((T[])object);
        }

        void setLocalVariable(int n2) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = n2;
        }

        public SubroutineImpl(Subroutines subroutines) {
            this.this$0 = subroutines;
            this.UNSET = -1;
            this.localVariable = -1;
            this.instructions = new HashSet();
            this.theJSRs = new HashSet();
        }

        static int access$000(SubroutineImpl subroutineImpl) {
            return subroutineImpl.localVariable;
        }

        static HashSet access$100(SubroutineImpl subroutineImpl) {
            return subroutineImpl.theJSRs;
        }

        static InstructionHandle access$200(SubroutineImpl subroutineImpl) {
            return subroutineImpl.theRET;
        }
    }
}

