/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.VerifierConstraintViolatedException;
import org.apache.bcel.verifier.structurals.ControlFlowGraph;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public final class Pass3bVerifier
extends PassVerifier {
    private static final boolean DEBUG = true;
    private Verifier myOwner;
    private int method_no;

    public Pass3bVerifier(Verifier verifier, int n2) {
        this.myOwner = verifier;
        this.method_no = n2;
    }

    private void circulationPump(ControlFlowGraph controlFlowGraph, InstructionContext instructionContext, Frame frame, InstConstraintVisitor instConstraintVisitor, ExecutionVisitor executionVisitor) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Random random = new Random();
        InstructionContextQueue instructionContextQueue = new InstructionContextQueue(null);
        instructionContext.execute(frame, new ArrayList(), instConstraintVisitor, executionVisitor);
        instructionContextQueue.add(instructionContext, new ArrayList());
        while (!instructionContextQueue.isEmpty()) {
            int n2;
            Object object5;
            Object object6;
            object4 = instructionContextQueue.getIC(0);
            object3 = instructionContextQueue.getEC(0);
            instructionContextQueue.remove(0);
            object2 = (ArrayList)((ArrayList)object3).clone();
            object = (ArrayList)((ArrayList)object3).clone();
            ((ArrayList)object).add(object4);
            if (object4.getInstruction().getInstruction() instanceof RET) {
                object6 = (RET)object4.getInstruction().getInstruction();
                ReturnaddressType returnaddressType = (ReturnaddressType)object4.getOutFrame((ArrayList)object2).getLocals().get(((RET)object6).getIndex());
                object5 = controlFlowGraph.contextOf(returnaddressType.getTarget());
                InstructionContext instructionContext2 = null;
                int n3 = 0;
                int n4 = ((ArrayList)object2).size() - 1;
                while (n4 >= 0) {
                    if (n3 < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (((InstructionContext)((ArrayList)object2).get(n4)).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (n3 == 0) {
                            instructionContext2 = (InstructionContext)((ArrayList)object2).get(n4);
                            break;
                        }
                        --n3;
                    }
                    if (((InstructionContext)((ArrayList)object2).get(n4)).getInstruction().getInstruction() instanceof RET) {
                        ++n3;
                    }
                    --n4;
                }
                if (instructionContext2 == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + object2 + "'.");
                }
                JsrInstruction jsrInstruction = (JsrInstruction)instructionContext2.getInstruction().getInstruction();
                if (object5 != controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + object4.getInstruction() + "' info inconsistent: jump back to '" + object5 + "' or '" + controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor()) + "'?");
                }
                if (object5.execute(object4.getOutFrame((ArrayList)object2), (ArrayList)object, instConstraintVisitor, executionVisitor)) {
                    instructionContextQueue.add((InstructionContext)object5, (ArrayList)((ArrayList)object).clone());
                }
            } else {
                object6 = object4.getSuccessors();
                n2 = 0;
                while (n2 < ((InstructionContext[])object6).length) {
                    object5 = object6[n2];
                    if (object5.execute(object4.getOutFrame((ArrayList)object2), (ArrayList)object, instConstraintVisitor, executionVisitor)) {
                        instructionContextQueue.add((InstructionContext)object5, (ArrayList)((ArrayList)object).clone());
                    }
                    ++n2;
                }
            }
            object6 = object4.getExceptionHandlers();
            n2 = 0;
            while (n2 < ((Object)object6).length) {
                object5 = controlFlowGraph.contextOf(((ExceptionHandler)object6[n2]).getHandlerStart());
                if (object5.execute(new Frame(object4.getOutFrame((ArrayList)object2).getLocals(), new OperandStack(object4.getOutFrame((ArrayList)object2).getStack().maxStack(), ((ExceptionHandler)object6[n2]).getExceptionType() == null ? Type.THROWABLE : ((ExceptionHandler)object6[n2]).getExceptionType())), new ArrayList(), instConstraintVisitor, executionVisitor)) {
                    instructionContextQueue.add((InstructionContext)object5, new ArrayList());
                }
                ++n2;
            }
        }
        object4 = instructionContext.getInstruction();
        do {
            if (!(((InstructionHandle)object4).getInstruction() instanceof ReturnInstruction) || controlFlowGraph.isDead((InstructionHandle)object4)) continue;
            object3 = controlFlowGraph.contextOf((InstructionHandle)object4);
            object2 = object3.getOutFrame(new ArrayList());
            object = ((Frame)object2).getLocals();
            int n5 = 0;
            while (n5 < ((LocalVariables)object).maxLocals()) {
                if (((LocalVariables)object).get(n5) instanceof UninitializedObjectType) {
                    this.addMessage("Warning: ReturnInstruction '" + object3 + "' may leave method with an uninitialized object in the local variables array '" + object + "'.");
                }
                ++n5;
            }
            OperandStack operandStack = ((Frame)object2).getStack();
            int n6 = 0;
            while (n6 < operandStack.size()) {
                if (operandStack.peek(n6) instanceof UninitializedObjectType) {
                    this.addMessage("Warning: ReturnInstruction '" + object3 + "' may leave method with an uninitialized object on the operand stack '" + operandStack + "'.");
                }
                ++n6;
            }
        } while ((object4 = ((InstructionHandle)object4).getNext()) != null);
    }

    public VerificationResult do_verify() {
        if (!this.myOwner.doPass3a(this.method_no).equals(VerificationResult.VR_OK)) {
            return VerificationResult.VR_NOTYET;
        }
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
        InstConstraintVisitor instConstraintVisitor = new InstConstraintVisitor();
        instConstraintVisitor.setConstantPoolGen(constantPoolGen);
        ExecutionVisitor executionVisitor = new ExecutionVisitor();
        executionVisitor.setConstantPoolGen(constantPoolGen);
        Method[] methodArray = javaClass.getMethods();
        try {
            MethodGen methodGen = new MethodGen(methodArray[this.method_no], this.myOwner.getClassName(), constantPoolGen);
            instConstraintVisitor.setMethodGen(methodGen);
            if (!methodGen.isAbstract() && !methodGen.isNative()) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph(methodGen);
                Frame frame = new Frame(methodGen.getMaxLocals(), methodGen.getMaxStack());
                if (!methodGen.isStatic()) {
                    if (methodGen.getName().equals("<init>")) {
                        Frame._this = new UninitializedObjectType(new ObjectType(javaClass.getClassName()));
                        frame.getLocals().set(0, Frame._this);
                    } else {
                        Frame._this = null;
                        frame.getLocals().set(0, new ObjectType(javaClass.getClassName()));
                    }
                }
                Type[] typeArray = methodGen.getArgumentTypes();
                int n2 = 0;
                int n3 = 0;
                while (n3 < typeArray.length) {
                    if (typeArray[n3] == Type.SHORT || typeArray[n3] == Type.BYTE || typeArray[n3] == Type.CHAR || typeArray[n3] == Type.BOOLEAN) {
                        typeArray[n3] = Type.INT;
                    }
                    frame.getLocals().set(n2 + n3 + (methodGen.isStatic() ? 0 : 1), typeArray[n3]);
                    if (typeArray[n3].getSize() == 2) {
                        frame.getLocals().set(++n2 + n3 + (methodGen.isStatic() ? 0 : 1), Type.UNKNOWN);
                    }
                    ++n3;
                }
                this.circulationPump(controlFlowGraph, controlFlowGraph.contextOf(methodGen.getInstructionList().getStart()), frame, instConstraintVisitor, executionVisitor);
            }
        }
        catch (VerifierConstraintViolatedException verifierConstraintViolatedException) {
            verifierConstraintViolatedException.extendMessage("Constraint violated in method '" + methodArray[this.method_no] + "':\n", "");
            return new VerificationResult(2, verifierConstraintViolatedException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            runtimeException.printStackTrace(printWriter);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + javaClass.getClassName() + "', method '" + methodArray[this.method_no] + "'. Original RuntimeException's stack trace:\n---\n" + stringWriter + "---\n");
        }
        return VerificationResult.VR_OK;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    class 1 {
    }

    private static final class InstructionContextQueue {
        private Vector ics = new Vector();
        private Vector ecs = new Vector();

        private InstructionContextQueue() {
        }

        public void add(InstructionContext instructionContext, ArrayList arrayList) {
            this.ics.add(instructionContext);
            this.ecs.add(arrayList);
        }

        public boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove() {
            this.remove(0);
        }

        public void remove(int n2) {
            this.ics.remove(n2);
            this.ecs.remove(n2);
        }

        public InstructionContext getIC(int n2) {
            return (InstructionContext)this.ics.get(n2);
        }

        public ArrayList getEC(int n2) {
            return (ArrayList)this.ecs.get(n2);
        }

        public int size() {
            return this.ics.size();
        }

        InstructionContextQueue(1 var1_1) {
            this();
        }
    }
}

