/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.AbstractList;
import java.util.ArrayList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class OperandStack {
    private ArrayList stack = new ArrayList();
    private int maxStack;

    public OperandStack(int n2) {
        this.maxStack = n2;
    }

    public OperandStack(int n2, ObjectType objectType) {
        this.maxStack = n2;
        this.push(objectType);
    }

    protected Object clone() {
        OperandStack operandStack = new OperandStack(this.maxStack);
        operandStack.stack = (ArrayList)this.stack.clone();
        return operandStack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OperandStack)) {
            return false;
        }
        OperandStack operandStack = (OperandStack)object;
        return ((AbstractList)this.stack).equals(operandStack.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int n2) {
        return (Type)this.stack.get(this.size() - n2 - 1);
    }

    public Type pop() {
        Type type = (Type)this.stack.remove(this.size() - 1);
        return type;
    }

    public Type pop(int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.pop();
            ++n3;
        }
        return null;
    }

    public void push(Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.stack.size()) {
            n2 += this.peek(n3).getSize();
            ++n3;
        }
        return n2;
    }

    public String toString() {
        String string = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        int n2 = 0;
        while (n2 < this.size()) {
            string = string + this.peek(n2) + " (Size: " + this.peek(n2).getSize() + ")\n";
            ++n2;
        }
        return string;
    }

    public void merge(OperandStack operandStack) {
        if (this.slotsUsed() != operandStack.slotsUsed() || this.size() != operandStack.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + operandStack);
        }
        int n2 = 0;
        while (n2 < this.size()) {
            if (!(this.stack.get(n2) instanceof UninitializedObjectType) && operandStack.stack.get(n2) instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (!this.stack.get(n2).equals(operandStack.stack.get(n2)) && this.stack.get(n2) instanceof UninitializedObjectType && !(operandStack.stack.get(n2) instanceof UninitializedObjectType)) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (this.stack.get(n2) instanceof UninitializedObjectType && !(operandStack.stack.get(n2) instanceof UninitializedObjectType)) {
                this.stack.set(n2, ((UninitializedObjectType)this.stack.get(n2)).getInitialized());
            }
            if (!this.stack.get(n2).equals(operandStack.stack.get(n2))) {
                if (this.stack.get(n2) instanceof ReferenceType && operandStack.stack.get(n2) instanceof ReferenceType) {
                    this.stack.set(n2, ((ReferenceType)this.stack.get(n2)).firstCommonSuperclass((ReferenceType)operandStack.stack.get(n2)));
                } else {
                    throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + operandStack);
                }
            }
            ++n2;
        }
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        int n2 = 0;
        while (n2 < this.stack.size()) {
            if (this.stack.get(n2) == uninitializedObjectType) {
                this.stack.set(n2, uninitializedObjectType.getInitialized());
            }
            ++n2;
        }
    }
}

