/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int n2) {
        this.locals = new Type[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.locals[n3] = Type.UNKNOWN;
            ++n3;
        }
    }

    protected Object clone() {
        LocalVariables localVariables = new LocalVariables(this.locals.length);
        int n2 = 0;
        while (n2 < this.locals.length) {
            localVariables.locals[n2] = this.locals[n2];
            ++n2;
        }
        return localVariables;
    }

    public Type get(int n2) {
        return this.locals[n2];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int n2, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[n2] = type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariables)) {
            return false;
        }
        LocalVariables localVariables = (LocalVariables)object;
        if (this.locals.length != localVariables.locals.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.locals.length) {
            if (!this.locals[n2].equals(localVariables.locals[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void merge(LocalVariables localVariables) {
        if (this.locals.length != localVariables.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        int n2 = 0;
        while (n2 < this.locals.length) {
            this.merge(localVariables, n2);
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables localVariables, int n2) {
        if (!(this.locals[n2] instanceof UninitializedObjectType) && localVariables.locals[n2] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (!this.locals[n2].equals(localVariables.locals[n2]) && this.locals[n2] instanceof UninitializedObjectType && localVariables.locals[n2] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (this.locals[n2] instanceof UninitializedObjectType && !(localVariables.locals[n2] instanceof UninitializedObjectType)) {
            this.locals[n2] = ((UninitializedObjectType)this.locals[n2]).getInitialized();
        }
        if (this.locals[n2] instanceof ReferenceType && localVariables.locals[n2] instanceof ReferenceType) {
            if (this.locals[n2].equals(localVariables.locals[n2])) return;
            ReferenceType referenceType = ((ReferenceType)this.locals[n2]).firstCommonSuperclass((ReferenceType)localVariables.locals[n2]);
            if (referenceType == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[n2] + "' and '" + localVariables.locals[n2] + "'.");
            this.locals[n2] = referenceType;
            return;
        } else {
            if (this.locals[n2].equals(localVariables.locals[n2])) return;
            this.locals[n2] = Type.UNKNOWN;
        }
    }

    public String toString() {
        String string = new String();
        int n2 = 0;
        while (n2 < this.locals.length) {
            string = string + Integer.toString(n2) + ": " + this.locals[n2] + "\n";
            ++n2;
        }
        return string;
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        int n2 = 0;
        while (n2 < this.locals.length) {
            if (this.locals[n2] == uninitializedObjectType) {
                this.locals[n2] = uninitializedObjectType.getInitialized();
            }
            ++n2;
        }
    }
}

