/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BREAKPOINT;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMPDEP1;
import org.apache.bcel.generic.IMPDEP2;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackInstruction;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class InstConstraintVisitor
extends EmptyVisitor
implements Visitor {
    private static ObjectType GENERIC_ARRAY = new ObjectType("org.apache.bcel.verifier.structurals.GenericArray");
    private Frame frame = null;
    private ConstantPoolGen cpg = null;
    private MethodGen mg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(Instruction instruction, String string) {
        String string2 = instruction.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + string2.substring(string2.lastIndexOf(46) + 1) + " constraint violated: " + string);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setConstantPoolGen(ConstantPoolGen constantPoolGen) {
        this.cpg = constantPoolGen;
    }

    public void setMethodGen(MethodGen methodGen) {
        this.mg = methodGen;
    }

    private void indexOfInt(Instruction instruction, Type type) {
        if (!type.equals(Type.INT)) {
            this.constraintViolated(instruction, "The 'index' is not of type int but of type " + type + ".");
        }
    }

    private void referenceTypeIsInitialized(Instruction instruction, ReferenceType referenceType) {
        if (referenceType instanceof UninitializedObjectType) {
            this.constraintViolated(instruction, "Working on an uninitialized object '" + referenceType + "'.");
        }
    }

    private void valueOfInt(Instruction instruction, Type type) {
        if (!type.equals(Type.INT)) {
            this.constraintViolated(instruction, "The 'value' is not of type int but of type " + type + ".");
        }
    }

    private boolean arrayrefOfArrayType(Instruction instruction, Type type) {
        if (!(type instanceof ArrayType) && !type.equals(Type.NULL)) {
            this.constraintViolated(instruction, "The 'arrayref' does not refer to an array but is of type " + type + ".");
        }
        return type instanceof ArrayType;
    }

    private void _visitStackAccessor(Instruction instruction) {
        int n2;
        int n3 = instruction.consumeStack(this.cpg);
        if (n3 > this.stack().slotsUsed()) {
            this.constraintViolated(instruction, "Cannot consume " + n3 + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((n2 = instruction.produceStack(this.cpg) - instruction.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(instruction, "Cannot produce " + n2 + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    public void visitLoadClass(LoadClass loadClass) {
        Verifier verifier;
        VerificationResult verificationResult;
        ObjectType objectType = loadClass.getLoadClassType(this.cpg);
        if (objectType != null && (verificationResult = (verifier = VerifierFactory.getVerifier(objectType.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
    }

    public void visitStackConsumer(StackConsumer stackConsumer) {
        this._visitStackAccessor((Instruction)((Object)stackConsumer));
    }

    public void visitStackProducer(StackProducer stackProducer) {
        this._visitStackAccessor((Instruction)((Object)stackProducer));
    }

    public void visitCPInstruction(CPInstruction cPInstruction) {
        int n2 = cPInstruction.getIndex();
        if (n2 < 0 || n2 >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + cPInstruction + "' illegal? Pass 3a should have checked this!");
        }
    }

    public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        String string;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type;
        Constant constant = this.cpg.getConstant(fieldInstruction.getIndex());
        if (!(constant instanceof ConstantFieldref)) {
            this.constraintViolated(fieldInstruction, "Index '" + fieldInstruction.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + constant + "'.");
        }
        if ((type = fieldInstruction.getType(this.cpg)) instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier(string = ((ObjectType)type).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(fieldInstruction, "Class '" + string + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
    }

    public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
    }

    public void visitStackInstruction(StackInstruction stackInstruction) {
        this._visitStackAccessor(stackInstruction);
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        if (this.locals().maxLocals() <= (localVariableInstruction.getType(this.cpg).getSize() == 1 ? localVariableInstruction.getIndex() : localVariableInstruction.getIndex() + 1)) {
            this.constraintViolated(localVariableInstruction, "The 'index' is not a valid index into the local variable array.");
        }
    }

    public void visitLoadInstruction(LoadInstruction loadInstruction) {
        if (this.locals().get(loadInstruction.getIndex()) == Type.UNKNOWN) {
            this.constraintViolated(loadInstruction, "Read-Access on local variable " + loadInstruction.getIndex() + " with unknown content.");
        }
        if (loadInstruction.getType(this.cpg).getSize() == 2 && this.locals().get(loadInstruction.getIndex() + 1) != Type.UNKNOWN) {
            this.constraintViolated(loadInstruction, "Reading a two-locals value from local variables " + loadInstruction.getIndex() + " and " + (loadInstruction.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!(loadInstruction instanceof ALOAD)) {
            if (this.locals().get(loadInstruction.getIndex()) != loadInstruction.getType(this.cpg)) {
                this.constraintViolated(loadInstruction, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(loadInstruction.getIndex()) + "'; Instruction type: '" + loadInstruction.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(loadInstruction.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(loadInstruction, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(loadInstruction.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < loadInstruction.getType(this.cpg).getSize()) {
            this.constraintViolated(loadInstruction, "Not enough free stack slots to load a '" + loadInstruction.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    public void visitStoreInstruction(StoreInstruction storeInstruction) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(storeInstruction, "Cannot STORE: Stack to read from is empty.");
        }
        if (!(storeInstruction instanceof ASTORE)) {
            if (this.stack().peek() != storeInstruction.getType(this.cpg)) {
                this.constraintViolated(storeInstruction, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + storeInstruction.getType(this.cpg) + "'.");
            }
        } else {
            Type type = this.stack().peek();
            if (!(type instanceof ReferenceType) && !(type instanceof ReturnaddressType)) {
                this.constraintViolated(storeInstruction, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
            if (type instanceof ReferenceType) {
                this.referenceTypeIsInitialized(storeInstruction, (ReferenceType)type);
            }
        }
    }

    public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        if (returnInstruction instanceof RETURN) {
            return;
        }
        if (returnInstruction instanceof ARETURN) {
            if (this.stack().peek() == Type.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(returnInstruction, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(returnInstruction, (ReferenceType)this.stack().peek());
            ReferenceType referenceType = (ReferenceType)this.stack().peek();
        } else {
            Type type = this.mg.getType();
            if (type == Type.BOOLEAN || type == Type.BYTE || type == Type.SHORT || type == Type.CHAR) {
                type = Type.INT;
            }
            if (!type.equals(this.stack().peek())) {
                this.constraintViolated(returnInstruction, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + type + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
            }
        }
    }

    public void visitAALOAD(AALOAD aALOAD) {
        Type type = this.stack().peek(1);
        Type type2 = this.stack().peek(0);
        this.indexOfInt(aALOAD, type2);
        if (this.arrayrefOfArrayType(aALOAD, type)) {
            if (!(((ArrayType)type).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(aALOAD, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)type).getElementType() + ".");
            }
            this.referenceTypeIsInitialized(aALOAD, (ReferenceType)((ArrayType)type).getElementType());
        }
    }

    public void visitAASTORE(AASTORE aASTORE) {
        Type type = this.stack().peek(2);
        Type type2 = this.stack().peek(1);
        Type type3 = this.stack().peek(0);
        this.indexOfInt(aASTORE, type2);
        if (!(type3 instanceof ReferenceType)) {
            this.constraintViolated(aASTORE, "The 'value' is not of a ReferenceType but of type " + type3 + ".");
        } else {
            this.referenceTypeIsInitialized(aASTORE, (ReferenceType)type3);
        }
        if (this.arrayrefOfArrayType(aASTORE, type)) {
            if (!(((ArrayType)type).getElementType() instanceof ReferenceType)) {
                this.constraintViolated(aASTORE, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)type).getElementType() + ".");
            }
            if (!((ReferenceType)type3).isAssignmentCompatibleWith((ReferenceType)((ArrayType)type).getElementType())) {
                this.constraintViolated(aASTORE, "The type of 'value' ('" + type3 + "') is not assignment compatible to the components of the array 'arrayref' refers to. ('" + ((ArrayType)type).getElementType() + "')");
            }
        }
    }

    public void visitACONST_NULL(ACONST_NULL aCONST_NULL) {
    }

    public void visitALOAD(ALOAD aLOAD) {
    }

    public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
        if (!this.stack().peek().equals(Type.INT)) {
            this.constraintViolated(aNEWARRAY, "The 'count' at the stack top is not of type '" + Type.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitARETURN(ARETURN aRETURN) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(aRETURN, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType referenceType = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(aRETURN, referenceType);
    }

    public void visitARRAYLENGTH(ARRAYLENGTH aRRAYLENGTH) {
        Type type = this.stack().peek(0);
        this.arrayrefOfArrayType(aRRAYLENGTH, type);
    }

    public void visitASTORE(ASTORE aSTORE) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(aSTORE, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
        if (this.stack().peek() instanceof ReferenceType) {
            this.referenceTypeIsInitialized(aSTORE, (ReferenceType)this.stack().peek());
        }
    }

    public void visitATHROW(ATHROW aTHROW) {
        ObjectType objectType;
        if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(Type.NULL)) {
            this.constraintViolated(aTHROW, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
        }
        if (this.stack().peek().equals(Type.NULL)) {
            return;
        }
        ObjectType objectType2 = (ObjectType)this.stack().peek();
        if (!objectType2.subclassOf(objectType = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !objectType2.equals(objectType)) {
            this.constraintViolated(aTHROW, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
        }
    }

    public void visitBALOAD(BALOAD bALOAD) {
        Type type = this.stack().peek(1);
        Type type2 = this.stack().peek(0);
        this.indexOfInt(bALOAD, type2);
        if (this.arrayrefOfArrayType(bALOAD, type) && !((ArrayType)type).getElementType().equals(Type.BOOLEAN) && !((ArrayType)type).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(bALOAD, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)type).getElementType() + "'.");
        }
    }

    public void visitBASTORE(BASTORE bASTORE) {
        Type type = this.stack().peek(2);
        Type type2 = this.stack().peek(1);
        Type type3 = this.stack().peek(0);
        this.indexOfInt(bASTORE, type2);
        this.valueOfInt(bASTORE, type2);
        if (this.arrayrefOfArrayType(bASTORE, type) && !((ArrayType)type).getElementType().equals(Type.BOOLEAN) && !((ArrayType)type).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(bASTORE, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)type).getElementType() + "'.");
        }
    }

    public void visitBIPUSH(BIPUSH bIPUSH) {
    }

    public void visitBREAKPOINT(BREAKPOINT bREAKPOINT) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    public void visitCALOAD(CALOAD cALOAD) {
        Type type = this.stack().peek(1);
        Type type2 = this.stack().peek(0);
        this.indexOfInt(cALOAD, type2);
        this.arrayrefOfArrayType(cALOAD, type);
    }

    public void visitCASTORE(CASTORE cASTORE) {
        Type type = this.stack().peek(2);
        Type type2 = this.stack().peek(1);
        Type type3 = this.stack().peek(0);
        this.indexOfInt(cASTORE, type2);
        this.valueOfInt(cASTORE, type2);
        if (this.arrayrefOfArrayType(cASTORE, type) && !((ArrayType)type).getElementType().equals(Type.CHAR)) {
            this.constraintViolated(cASTORE, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)type).getElementType() + ".");
        }
    }

    public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        Type type = this.stack().peek(0);
        if (!(type instanceof ReferenceType)) {
            this.constraintViolated(cHECKCAST, "The 'objectref' is not of a ReferenceType but of type " + type + ".");
        } else {
            this.referenceTypeIsInitialized(cHECKCAST, (ReferenceType)type);
        }
        Constant constant = this.cpg.getConstant(cHECKCAST.getIndex());
        if (!(constant instanceof ConstantClass)) {
            this.constraintViolated(cHECKCAST, "The Constant at 'index' is not a ConstantClass, but '" + constant + "'.");
        }
    }

    public void visitD2F(D2F d2F) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(d2F, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitD2I(D2I d2I) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(d2I, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitD2L(D2L d2L) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(d2L, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDADD(DADD dADD) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dADD, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dADD, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDALOAD(DALOAD dALOAD) {
        Type type;
        this.indexOfInt(dALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(dALOAD, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(dALOAD, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDASTORE(DASTORE dASTORE) {
        Type type;
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dASTORE, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(dASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(dASTORE, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(dASTORE, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitDCMPG(DCMPG dCMPG) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dCMPG, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dCMPG, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCMPL(DCMPL dCMPL) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dCMPL, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dCMPL, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCONST(DCONST dCONST) {
    }

    public void visitDDIV(DDIV dDIV) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dDIV, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dDIV, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDLOAD(DLOAD dLOAD) {
    }

    public void visitDMUL(DMUL dMUL) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dMUL, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dMUL, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDNEG(DNEG dNEG) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dNEG, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDREM(DREM dREM) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dREM, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dREM, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDRETURN(DRETURN dRETURN) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dRETURN, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDSTORE(DSTORE dSTORE) {
    }

    public void visitDSUB(DSUB dSUB) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(dSUB, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(dSUB, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDUP(DUP dUP) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(dUP, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitDUP_X1(DUP_X1 dUP_X1) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(dUP_X1, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(dUP_X1, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitDUP_X2(DUP_X2 dUP_X2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(dUP_X2, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(dUP_X2, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    public void visitDUP2(DUP2 dUP2) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(dUP2, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X1(DUP2_X1 dUP2_X1) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(dUP2_X1, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(dUP2_X1, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(dUP2_X1, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X2(DUP2_X2 dUP2_X2) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(dUP2_X2, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(dUP2_X2, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    public void visitF2D(F2D f2D) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(f2D, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2I(F2I f2I) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(f2I, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2L(F2L f2L) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(f2L, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFADD(FADD fADD) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fADD, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fADD, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFALOAD(FALOAD fALOAD) {
        Type type;
        this.indexOfInt(fALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(fALOAD, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(fALOAD, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFASTORE(FASTORE fASTORE) {
        Type type;
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fASTORE, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(fASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(fASTORE, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(fASTORE, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitFCMPG(FCMPG fCMPG) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fCMPG, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fCMPG, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCMPL(FCMPL fCMPL) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fCMPL, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fCMPL, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCONST(FCONST fCONST) {
    }

    public void visitFDIV(FDIV fDIV) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fDIV, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fDIV, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFLOAD(FLOAD fLOAD) {
    }

    public void visitFMUL(FMUL fMUL) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fMUL, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fMUL, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFNEG(FNEG fNEG) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fNEG, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFREM(FREM fREM) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fREM, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fREM, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFRETURN(FRETURN fRETURN) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fRETURN, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFSTORE(FSTORE fSTORE) {
    }

    public void visitFSUB(FSUB fSUB) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(fSUB, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(fSUB, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitGETFIELD(GETFIELD gETFIELD) {
        ObjectType objectType;
        ObjectType objectType2;
        Type type = this.stack().peek();
        if (!(type instanceof ObjectType) && type != Type.NULL) {
            this.constraintViolated(gETFIELD, "Stack top should be an object reference that's not an array reference, but is '" + type + "'.");
        }
        String string = gETFIELD.getFieldName(this.cpg);
        JavaClass javaClass = Repository.lookupClass(gETFIELD.getClassType(this.cpg).getClassName());
        Field[] fieldArray = javaClass.getFields();
        AccessFlags accessFlags = null;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (fieldArray[n2].getName().equals(string)) {
                accessFlags = fieldArray[n2];
                break;
            }
            ++n2;
        }
        if (accessFlags == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        if (accessFlags.isProtected() && ((objectType2 = gETFIELD.getClassType(this.cpg)).equals(objectType = new ObjectType(this.mg.getClassName())) || objectType.subclassOf(objectType2))) {
            ObjectType objectType3;
            Type type2 = this.stack().peek();
            if (type2 == Type.NULL) {
                return;
            }
            if (!(type2 instanceof ObjectType)) {
                this.constraintViolated(gETFIELD, "The 'objectref' must refer to an object that's not an array. Found instead: '" + type2 + "'.");
            }
            if ((objectType3 = (ObjectType)type2).equals(objectType) || !objectType3.subclassOf(objectType)) {
                // empty if block
            }
        }
        if (accessFlags.isStatic()) {
            this.constraintViolated(gETFIELD, "Referenced field '" + accessFlags + "' is static which it shouldn't be.");
        }
    }

    public void visitGETSTATIC(GETSTATIC gETSTATIC) {
    }

    public void visitGOTO(GOTO gOTO) {
    }

    public void visitGOTO_W(GOTO_W gOTO_W) {
    }

    public void visitI2B(I2B i2B) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2B, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2C(I2C i2C) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2C, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2D(I2D i2D) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2D, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2F(I2F i2F) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2F, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2L(I2L i2L) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2L, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2S(I2S i2S) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(i2S, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIADD(IADD iADD) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iADD, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iADD, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIALOAD(IALOAD iALOAD) {
        Type type;
        this.indexOfInt(iALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(iALOAD, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.INT) {
            this.constraintViolated(iALOAD, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIAND(IAND iAND) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iAND, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iAND, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIASTORE(IASTORE iASTORE) {
        Type type;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iASTORE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(iASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(iASTORE, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.INT) {
            this.constraintViolated(iASTORE, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitICONST(ICONST iCONST) {
    }

    public void visitIDIV(IDIV iDIV) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iDIV, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iDIV, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ACMPEQ(IF_ACMPEQ iF_ACMPEQ) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPEQ, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(iF_ACMPEQ, (ReferenceType)this.stack().peek());
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPEQ, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
        this.referenceTypeIsInitialized(iF_ACMPEQ, (ReferenceType)this.stack().peek(1));
    }

    public void visitIF_ACMPNE(IF_ACMPNE iF_ACMPNE) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPNE, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
            this.referenceTypeIsInitialized(iF_ACMPNE, (ReferenceType)this.stack().peek());
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(iF_ACMPNE, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
            this.referenceTypeIsInitialized(iF_ACMPNE, (ReferenceType)this.stack().peek(1));
        }
    }

    public void visitIF_ICMPEQ(IF_ICMPEQ iF_ICMPEQ) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPEQ, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPEQ, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGE(IF_ICMPGE iF_ICMPGE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPGE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPGE, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGT(IF_ICMPGT iF_ICMPGT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPGT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPGT, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLE(IF_ICMPLE iF_ICMPLE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPLE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPLE, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLT(IF_ICMPLT iF_ICMPLT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPLT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPLT, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPNE(IF_ICMPNE iF_ICMPNE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iF_ICMPNE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iF_ICMPNE, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIFEQ(IFEQ iFEQ) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFEQ, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGE(IFGE iFGE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFGE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGT(IFGT iFGT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFGT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLE(IFLE iFLE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFLE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLT(IFLT iFLT) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFLT, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNE(IFNE iFNE) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iFNE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNONNULL(IFNONNULL iFNONNULL) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iFNONNULL, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(iFNONNULL, (ReferenceType)this.stack().peek());
    }

    public void visitIFNULL(IFNULL iFNULL) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(iFNULL, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(iFNULL, (ReferenceType)this.stack().peek());
    }

    public void visitIINC(IINC iINC) {
        if (this.locals().maxLocals() <= (iINC.getType(this.cpg).getSize() == 1 ? iINC.getIndex() : iINC.getIndex() + 1)) {
            this.constraintViolated(iINC, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(iINC, this.locals().get(iINC.getIndex()));
    }

    public void visitILOAD(ILOAD iLOAD) {
    }

    public void visitIMPDEP1(IMPDEP1 iMPDEP1) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    public void visitIMPDEP2(IMPDEP2 iMPDEP2) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    public void visitIMUL(IMUL iMUL) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iMUL, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iMUL, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitINEG(INEG iNEG) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iNEG, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        Type type = this.stack().peek(0);
        if (!(type instanceof ReferenceType)) {
            this.constraintViolated(iNSTANCEOF, "The 'objectref' is not of a ReferenceType but of type " + type + ".");
        } else {
            this.referenceTypeIsInitialized(iNSTANCEOF, (ReferenceType)type);
        }
        Constant constant = this.cpg.getConstant(iNSTANCEOF.getIndex());
        if (!(constant instanceof ConstantClass)) {
            this.constraintViolated(iNSTANCEOF, "The Constant at 'index' is not a ConstantClass, but '" + constant + "'.");
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
        Object object;
        Object object2;
        Type type;
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        int n2 = iNVOKEINTERFACE.getCount();
        if (n2 == 0) {
            this.constraintViolated(iNVOKEINTERFACE, "The 'count' argument must not be 0.");
        }
        ConstantInterfaceMethodref constantInterfaceMethodref = (ConstantInterfaceMethodref)this.cpg.getConstant(iNVOKEINTERFACE.getIndex());
        Type type2 = iNVOKEINTERFACE.getType(this.cpg);
        if (type2 instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKEINTERFACE, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKEINTERFACE.getArgumentTypes(this.cpg);
        int n3 = typeArray.length;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            type = this.stack().peek(n3 - 1 - n4);
            object2 = typeArray[n4];
            if (object2 == Type.BOOLEAN || object2 == Type.BYTE || object2 == Type.CHAR || object2 == Type.SHORT) {
                object2 = Type.INT;
            }
            if (!type.equals(object2)) {
                if (type instanceof ReferenceType && object2 instanceof ReferenceType) {
                    object = (ReferenceType)type;
                    ReferenceType referenceType = (ReferenceType)object2;
                } else {
                    this.constraintViolated(iNVOKEINTERFACE, "Expecting a '" + object2 + "' but found a '" + type + "' on the stack.");
                }
            }
            --n4;
        }
        type = this.stack().peek(n3);
        if (type == Type.NULL) {
            return;
        }
        if (!(type instanceof ReferenceType)) {
            this.constraintViolated(iNVOKEINTERFACE, "Expecting a reference type as 'objectref' on the stack, not a '" + type + "'.");
        }
        this.referenceTypeIsInitialized(iNVOKEINTERFACE, (ReferenceType)type);
        if (!(type instanceof ObjectType)) {
            if (!(type instanceof ArrayType)) {
                this.constraintViolated(iNVOKEINTERFACE, "Expecting an ObjectType as 'objectref' on the stack, not a '" + type + "'.");
            } else {
                type = GENERIC_ARRAY;
            }
        }
        object2 = ((ObjectType)type).getClassName();
        object = iNVOKEINTERFACE.getClassName(this.cpg);
        int n5 = 1;
        int n6 = 0;
        while (n6 < n3) {
            n5 += typeArray[n6].getSize();
            ++n6;
        }
        if (n2 != n5) {
            this.constraintViolated(iNVOKEINTERFACE, "The 'count' argument should probably read '" + n5 + "' but is '" + n2 + "'.");
        }
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
        Object object;
        Object object2;
        Type type;
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2;
        if (iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(iNVOKESPECIAL.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
            this.constraintViolated(iNVOKESPECIAL, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
        }
        if ((type2 = iNVOKESPECIAL.getType(this.cpg)) instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKESPECIAL, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKESPECIAL.getArgumentTypes(this.cpg);
        int n2 = typeArray.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            type = this.stack().peek(n2 - 1 - n3);
            object2 = typeArray[n3];
            if (object2 == Type.BOOLEAN || object2 == Type.BYTE || object2 == Type.CHAR || object2 == Type.SHORT) {
                object2 = Type.INT;
            }
            if (!type.equals(object2)) {
                if (type instanceof ReferenceType && object2 instanceof ReferenceType) {
                    object = (ReferenceType)type;
                    ReferenceType referenceType = (ReferenceType)object2;
                } else {
                    this.constraintViolated(iNVOKESPECIAL, "Expecting a '" + object2 + "' but found a '" + type + "' on the stack.");
                }
            }
            --n3;
        }
        type = this.stack().peek(n2);
        if (type == Type.NULL) {
            return;
        }
        if (!(type instanceof ReferenceType)) {
            this.constraintViolated(iNVOKESPECIAL, "Expecting a reference type as 'objectref' on the stack, not a '" + type + "'.");
        }
        object2 = null;
        if (!iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>")) {
            this.referenceTypeIsInitialized(iNVOKESPECIAL, (ReferenceType)type);
            if (!(type instanceof ObjectType)) {
                if (!(type instanceof ArrayType)) {
                    this.constraintViolated(iNVOKESPECIAL, "Expecting an ObjectType as 'objectref' on the stack, not a '" + type + "'.");
                } else {
                    type = GENERIC_ARRAY;
                }
            }
            object2 = ((ObjectType)type).getClassName();
        } else {
            if (!(type instanceof UninitializedObjectType)) {
                this.constraintViolated(iNVOKESPECIAL, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + type + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
            }
            object2 = ((UninitializedObjectType)type).getInitialized().getClassName();
        }
        object = iNVOKESPECIAL.getClassName(this.cpg);
        if (!Repository.instanceOf((String)object2, (String)object)) {
            this.constraintViolated(iNVOKESPECIAL, "The 'objref' item '" + type + "' does not implement '" + (String)object + "' as expected.");
        }
    }

    public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type = iNVOKESTATIC.getType(this.cpg);
        if (type instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKESTATIC, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKESTATIC.getArgumentTypes(this.cpg);
        int n2 = typeArray.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Type type2 = this.stack().peek(n2 - 1 - n3);
            Type type3 = typeArray[n3];
            if (type3 == Type.BOOLEAN || type3 == Type.BYTE || type3 == Type.CHAR || type3 == Type.SHORT) {
                type3 = Type.INT;
            }
            if (!type2.equals(type3)) {
                if (type2 instanceof ReferenceType && type3 instanceof ReferenceType) {
                    ReferenceType referenceType = (ReferenceType)type2;
                    ReferenceType referenceType2 = (ReferenceType)type3;
                } else {
                    this.constraintViolated(iNVOKESTATIC, "Expecting a '" + type3 + "' but found a '" + type2 + "' on the stack.");
                }
            }
            --n3;
        }
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
        Object object;
        Object object2;
        Type type;
        Type[] typeArray;
        Verifier verifier;
        VerificationResult verificationResult;
        Type type2 = iNVOKEVIRTUAL.getType(this.cpg);
        if (type2 instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier((String)(typeArray = ((ObjectType)type2).getClassName()))).doPass2()).getStatus() != 1) {
            this.constraintViolated(iNVOKEVIRTUAL, "Class '" + (String)typeArray + "' is referenced, but cannot be loaded and resolved: '" + verificationResult + "'.");
        }
        typeArray = iNVOKEVIRTUAL.getArgumentTypes(this.cpg);
        int n2 = typeArray.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            type = this.stack().peek(n2 - 1 - n3);
            object2 = typeArray[n3];
            if (object2 == Type.BOOLEAN || object2 == Type.BYTE || object2 == Type.CHAR || object2 == Type.SHORT) {
                object2 = Type.INT;
            }
            if (!type.equals(object2)) {
                if (type instanceof ReferenceType && object2 instanceof ReferenceType) {
                    object = (ReferenceType)type;
                    ReferenceType referenceType = (ReferenceType)object2;
                } else {
                    this.constraintViolated(iNVOKEVIRTUAL, "Expecting a '" + object2 + "' but found a '" + type + "' on the stack.");
                }
            }
            --n3;
        }
        type = this.stack().peek(n2);
        if (type == Type.NULL) {
            return;
        }
        if (!(type instanceof ReferenceType)) {
            this.constraintViolated(iNVOKEVIRTUAL, "Expecting a reference type as 'objectref' on the stack, not a '" + type + "'.");
        }
        this.referenceTypeIsInitialized(iNVOKEVIRTUAL, (ReferenceType)type);
        if (!(type instanceof ObjectType)) {
            if (!(type instanceof ArrayType)) {
                this.constraintViolated(iNVOKEVIRTUAL, "Expecting an ObjectType as 'objectref' on the stack, not a '" + type + "'.");
            } else {
                type = GENERIC_ARRAY;
            }
        }
        if (!Repository.instanceOf((String)(object2 = ((ObjectType)type).getClassName()), (String)(object = iNVOKEVIRTUAL.getClassName(this.cpg)))) {
            this.constraintViolated(iNVOKEVIRTUAL, "The 'objref' item '" + type + "' does not implement '" + (String)object + "' as expected.");
        }
    }

    public void visitIOR(IOR iOR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iOR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iOR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIREM(IREM iREM) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iREM, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iREM, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIRETURN(IRETURN iRETURN) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iRETURN, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitISHL(ISHL iSHL) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iSHL, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iSHL, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISHR(ISHR iSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iSHR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISTORE(ISTORE iSTORE) {
    }

    public void visitISUB(ISUB iSUB) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iSUB, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iSUB, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIUSHR(IUSHR iUSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iUSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iUSHR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIXOR(IXOR iXOR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(iXOR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(iXOR, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitJSR(JSR jSR) {
    }

    public void visitJSR_W(JSR_W jSR_W) {
    }

    public void visitL2D(L2D l2D) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(l2D, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2F(L2F l2F) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(l2F, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2I(L2I l2I) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(l2I, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLADD(LADD lADD) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lADD, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lADD, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLALOAD(LALOAD lALOAD) {
        Type type;
        this.indexOfInt(lALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(lALOAD, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.LONG) {
            this.constraintViolated(lALOAD, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLAND(LAND lAND) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lAND, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lAND, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLASTORE(LASTORE lASTORE) {
        Type type;
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lASTORE, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(lASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(lASTORE, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.LONG) {
            this.constraintViolated(lASTORE, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitLCMP(LCMP lCMP) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lCMP, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lCMP, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLCONST(LCONST lCONST) {
    }

    public void visitLDC(LDC lDC) {
        Constant constant = this.cpg.getConstant(lDC.getIndex());
        if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
            this.constraintViolated(lDC, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + constant + "'.");
        }
    }

    public void visitLDC_W(LDC_W lDC_W) {
        Constant constant = this.cpg.getConstant(lDC_W.getIndex());
        if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
            this.constraintViolated(lDC_W, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + constant + "'.");
        }
    }

    public void visitLDC2_W(LDC2_W lDC2_W) {
        Constant constant = this.cpg.getConstant(lDC2_W.getIndex());
        if (!(constant instanceof ConstantLong) && !(constant instanceof ConstantDouble)) {
            this.constraintViolated(lDC2_W, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + constant + "'.");
        }
    }

    public void visitLDIV(LDIV lDIV) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lDIV, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lDIV, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLLOAD(LLOAD lLOAD) {
    }

    public void visitLMUL(LMUL lMUL) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lMUL, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lMUL, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLNEG(LNEG lNEG) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lNEG, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lOOKUPSWITCH, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLOR(LOR lOR) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lOR, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lOR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLREM(LREM lREM) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lREM, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lREM, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLRETURN(LRETURN lRETURN) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lRETURN, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLSHL(LSHL lSHL) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lSHL, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lSHL, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSHR(LSHR lSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lSHR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSTORE(LSTORE lSTORE) {
    }

    public void visitLSUB(LSUB lSUB) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lSUB, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lSUB, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLUSHR(LUSHR lUSHR) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(lUSHR, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lUSHR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLXOR(LXOR lXOR) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(lXOR, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(lXOR, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitMONITORENTER(MONITORENTER mONITORENTER) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(mONITORENTER, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(mONITORENTER, (ReferenceType)this.stack().peek());
    }

    public void visitMONITOREXIT(MONITOREXIT mONITOREXIT) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(mONITOREXIT, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(mONITOREXIT, (ReferenceType)this.stack().peek());
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
        int n2 = mULTIANEWARRAY.getDimensions();
        int n3 = 0;
        while (n3 < n2) {
            if (this.stack().peek(n3) != Type.INT) {
                this.constraintViolated(mULTIANEWARRAY, "The '" + n2 + "' upper stack types should be 'int' but aren't.");
            }
            ++n3;
        }
    }

    public void visitNEW(NEW nEW) {
        ObjectType objectType;
        Type type = nEW.getType(this.cpg);
        if (!(type instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(type instanceof ObjectType)) {
            this.constraintViolated(nEW, "Expecting a class type (ObjectType) to work on. Found: '" + type + "'.");
        }
        if (!(objectType = (ObjectType)type).referencesClass()) {
            this.constraintViolated(nEW, "Expecting a class type (ObjectType) to work on. Found: '" + objectType + "'.");
        }
    }

    public void visitNEWARRAY(NEWARRAY nEWARRAY) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(nEWARRAY, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitNOP(NOP nOP) {
    }

    public void visitPOP(POP pOP) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(pOP, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPOP2(POP2 pOP2) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(pOP2, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPUTFIELD(PUTFIELD pUTFIELD) {
        ObjectType objectType;
        ReferenceType referenceType;
        Type type = this.stack().peek(1);
        if (!(type instanceof ObjectType) && type != Type.NULL) {
            this.constraintViolated(pUTFIELD, "Stack next-to-top should be an object reference that's not an array reference, but is '" + type + "'.");
        }
        String string = pUTFIELD.getFieldName(this.cpg);
        JavaClass javaClass = Repository.lookupClass(pUTFIELD.getClassType(this.cpg).getClassName());
        Field[] fieldArray = javaClass.getFields();
        FieldOrMethod fieldOrMethod = null;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (fieldArray[n2].getName().equals(string)) {
                fieldOrMethod = fieldArray[n2];
                break;
            }
            ++n2;
        }
        if (fieldOrMethod == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type type2 = this.stack().peek();
        Type type3 = Type.getType(fieldOrMethod.getSignature());
        Type type4 = type3;
        if (type4 == Type.BOOLEAN || type4 == Type.BYTE || type4 == Type.CHAR || type4 == Type.SHORT) {
            type4 = Type.INT;
        }
        if (type3 instanceof ReferenceType) {
            referenceType = null;
            if (type2 instanceof ReferenceType) {
                referenceType = (ReferenceType)type2;
                this.referenceTypeIsInitialized(pUTFIELD, referenceType);
            } else {
                this.constraintViolated(pUTFIELD, "The stack top type '" + type2 + "' is not of a reference type as expected.");
            }
        } else if (type4 != type2) {
            this.constraintViolated(pUTFIELD, "The stack top type '" + type2 + "' is not of type '" + type4 + "' as expected.");
        }
        if (fieldOrMethod.isProtected() && (((ObjectType)(referenceType = pUTFIELD.getClassType(this.cpg))).equals(objectType = new ObjectType(this.mg.getClassName())) || objectType.subclassOf((ObjectType)referenceType))) {
            ObjectType objectType2;
            Type type5 = this.stack().peek(1);
            if (type5 == Type.NULL) {
                return;
            }
            if (!(type5 instanceof ObjectType)) {
                this.constraintViolated(pUTFIELD, "The 'objectref' must refer to an object that's not an array. Found instead: '" + type5 + "'.");
            }
            if (!(objectType2 = (ObjectType)type5).equals(objectType) && !objectType2.subclassOf(objectType)) {
                this.constraintViolated(pUTFIELD, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
            }
        }
        if (fieldOrMethod.isStatic()) {
            this.constraintViolated(pUTFIELD, "Referenced field '" + fieldOrMethod + "' is static which it shouldn't be.");
        }
    }

    public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
        String string = pUTSTATIC.getFieldName(this.cpg);
        JavaClass javaClass = Repository.lookupClass(pUTSTATIC.getClassType(this.cpg).getClassName());
        Field[] fieldArray = javaClass.getFields();
        FieldOrMethod fieldOrMethod = null;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (fieldArray[n2].getName().equals(string)) {
                fieldOrMethod = fieldArray[n2];
                break;
            }
            ++n2;
        }
        if (fieldOrMethod == null) {
            throw new AssertionViolatedException("Field not found?!?");
        }
        Type type = this.stack().peek();
        Type type2 = Type.getType(fieldOrMethod.getSignature());
        Type type3 = type2;
        if (type3 == Type.BOOLEAN || type3 == Type.BYTE || type3 == Type.CHAR || type3 == Type.SHORT) {
            type3 = Type.INT;
        }
        if (type2 instanceof ReferenceType) {
            ReferenceType referenceType = null;
            if (type instanceof ReferenceType) {
                referenceType = (ReferenceType)type;
                this.referenceTypeIsInitialized(pUTSTATIC, referenceType);
            } else {
                this.constraintViolated(pUTSTATIC, "The stack top type '" + type + "' is not of a reference type as expected.");
            }
            if (!referenceType.isAssignmentCompatibleWith(type3)) {
                this.constraintViolated(pUTSTATIC, "The stack top type '" + type + "' is not assignment compatible with '" + type3 + "'.");
            }
        } else if (type3 != type) {
            this.constraintViolated(pUTSTATIC, "The stack top type '" + type + "' is not of type '" + type3 + "' as expected.");
        }
    }

    public void visitRET(RET rET) {
        if (!(this.locals().get(rET.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(rET, "Expecting a ReturnaddressType in local variable " + rET.getIndex() + ".");
        }
        if (this.locals().get(rET.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    public void visitRETURN(RETURN rETURN) {
        if (this.mg.getName().equals("<init>")) {
            if (Frame._this != null && !this.mg.getClassName().equals(Type.OBJECT.getClassName())) {
                this.constraintViolated(rETURN, "Leaving a constructor that itself did not call a constructor.");
            }
        }
    }

    public void visitSALOAD(SALOAD sALOAD) {
        Type type;
        this.indexOfInt(sALOAD, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(sALOAD, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(sALOAD, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitSASTORE(SASTORE sASTORE) {
        Type type;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(sASTORE, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(sASTORE, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(sASTORE, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((type = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(sASTORE, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitSIPUSH(SIPUSH sIPUSH) {
    }

    public void visitSWAP(SWAP sWAP) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(sWAP, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(sWAP, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        this.indexOfInt(tABLESWITCH, this.stack().peek());
    }
}

