/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.verifier.structurals.ExceptionHandler;

public class ExceptionHandlers {
    private Hashtable exceptionhandlers = new Hashtable();

    public ExceptionHandlers(MethodGen methodGen) {
        CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
        int n2 = 0;
        while (n2 < codeExceptionGenArray.length) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(codeExceptionGenArray[n2].getCatchType(), codeExceptionGenArray[n2].getHandlerPC());
            InstructionHandle instructionHandle = codeExceptionGenArray[n2].getStartPC();
            while (instructionHandle != codeExceptionGenArray[n2].getEndPC().getNext()) {
                HashSet<ExceptionHandler> hashSet = (HashSet<ExceptionHandler>)this.exceptionhandlers.get(instructionHandle);
                if (hashSet == null) {
                    hashSet = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(instructionHandle, hashSet);
                }
                hashSet.add(exceptionHandler);
                instructionHandle = instructionHandle.getNext();
            }
            ++n2;
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle instructionHandle) {
        HashSet hashSet = (HashSet)this.exceptionhandlers.get(instructionHandle);
        if (hashSet == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] exceptionHandlerArray = new ExceptionHandler[hashSet.size()];
        return ((AbstractCollection)hashSet).toArray(exceptionHandlerArray);
    }
}

