/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BREAKPOINT;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMPDEP1;
import org.apache.bcel.generic.IMPDEP2;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.ClassConstraintException;
import org.apache.bcel.verifier.exc.InvalidMethodException;
import org.apache.bcel.verifier.exc.StaticCodeConstraintException;
import org.apache.bcel.verifier.exc.StaticCodeInstructionConstraintException;
import org.apache.bcel.verifier.exc.StaticCodeInstructionOperandConstraintException;
import org.apache.bcel.verifier.statics.IntList;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier verifier, int n2) {
        this.myOwner = verifier;
        this.method_no = n2;
    }

    public VerificationResult do_verify() {
        if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
            JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
            Method[] methodArray = javaClass.getMethods();
            if (this.method_no >= methodArray.length) {
                throw new InvalidMethodException("METHOD DOES NOT EXIST!");
            }
            Method method = methodArray[this.method_no];
            this.code = method.getCode();
            if (method.isAbstract() || method.isNative()) {
                return VerificationResult.VR_OK;
            }
            try {
                this.instructionList = new InstructionList(method.getCode().getCode());
            }
            catch (RuntimeException runtimeException) {
                return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
            }
            this.instructionList.setPositions(true);
            VerificationResult verificationResult = VerificationResult.VR_OK;
            try {
                this.delayedPass2Checks();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult = new VerificationResult(2, classConstraintException.getMessage());
                return verificationResult;
            }
            try {
                this.pass3StaticInstructionChecks();
                this.pass3StaticInstructionOperandsChecks();
            }
            catch (StaticCodeConstraintException staticCodeConstraintException) {
                verificationResult = new VerificationResult(2, staticCodeConstraintException.getMessage());
            }
            return verificationResult;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void delayedPass2Checks() {
        int n2;
        int n3;
        int n4;
        Node[] nodeArray;
        int[] nArray = this.instructionList.getInstructionPositions();
        int n5 = this.code.getCode().length;
        LineNumberTable lineNumberTable = this.code.getLineNumberTable();
        if (lineNumberTable != null) {
            nodeArray = lineNumberTable.getLineNumberTable();
            IntList intList = new IntList();
            int n6 = 0;
            while (n6 < nodeArray.length) {
                block16: {
                    int n7 = 0;
                    while (n7 < nArray.length) {
                        n4 = ((LineNumber)nodeArray[n6]).getStartPC();
                        if (nArray[n7] == n4) {
                            if (intList.contains(n4)) {
                                this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + n4 + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                            } else {
                                intList.add(n4);
                            }
                            break block16;
                        }
                        ++n7;
                    }
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + ((LineNumber)nodeArray[n6]).getStartPC() + "') that does not exist.");
                }
                ++n6;
            }
        }
        nodeArray = this.code.getAttributes();
        int n8 = 0;
        while (n8 < nodeArray.length) {
            LocalVariableTable localVariableTable;
            if (nodeArray[n8] instanceof LocalVariableTable && (localVariableTable = (LocalVariableTable)nodeArray[n8]) != null) {
                LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
                n4 = 0;
                while (n4 < localVariableArray.length) {
                    n3 = localVariableArray[n4].getStartPC();
                    n2 = localVariableArray[n4].getLength();
                    if (!Pass3aVerifier.contains(nArray, n3)) {
                        throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + n3 + "') that does not exist.");
                    }
                    if (!Pass3aVerifier.contains(nArray, n3 + n2) && n3 + n2 != n5) {
                        throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (n3 + n2) + "') that does not exist.");
                    }
                    ++n4;
                }
            }
            ++n8;
        }
        CodeException[] codeExceptionArray = this.code.getExceptionTable();
        int n9 = 0;
        while (n9 < codeExceptionArray.length) {
            n4 = codeExceptionArray[n9].getStartPC();
            n3 = codeExceptionArray[n9].getEndPC();
            n2 = codeExceptionArray[n9].getHandlerPC();
            if (n4 >= n3) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n9] + "' that has its start_pc ('" + n4 + "') not smaller than its end_pc ('" + n3 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n4)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n9] + "' that has a non-existant bytecode offset as its start_pc ('" + n4 + "').");
            }
            if (!Pass3aVerifier.contains(nArray, n3) && n3 != n5) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n9] + "' that has a non-existant bytecode offset as its end_pc ('" + n4 + "') [that is also not equal to code_length ('" + n5 + "')].");
            }
            if (!Pass3aVerifier.contains(nArray, n2)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + codeExceptionArray[n9] + "' that has a non-existant bytecode offset as its handler_pc ('" + n2 + "').");
            }
            ++n9;
        }
    }

    private void pass3StaticInstructionChecks() {
        Instruction instruction;
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        InstructionHandle instructionHandle = this.instructionList.getStart();
        while (instructionHandle != null) {
            instruction = instructionHandle.getInstruction();
            if (instruction instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (instruction instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (instruction instanceof BREAKPOINT) {
                throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            instructionHandle = instructionHandle.getNext();
        }
        instruction = this.instructionList.getEnd().getInstruction();
        if (!(instruction instanceof ReturnInstruction || instruction instanceof RET || instruction instanceof GotoInstruction || instruction instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
        InstOperandConstraintVisitor instOperandConstraintVisitor = new InstOperandConstraintVisitor(this, constantPoolGen);
        InstructionHandle instructionHandle = this.instructionList.getStart();
        while (instructionHandle != null) {
            Instruction instruction = instructionHandle.getInstruction();
            if (instruction instanceof JsrInstruction) {
                InstructionHandle instructionHandle2 = ((JsrInstruction)instruction).getTarget();
                if (instructionHandle2 == this.instructionList.getStart()) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + instructionHandle + "' as its target.");
                }
                if (!(instructionHandle2.getInstruction() instanceof ASTORE)) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + instructionHandle + "' targets '" + instructionHandle2 + "'.");
                }
            }
            instructionHandle.accept(instOperandConstraintVisitor);
            instructionHandle = instructionHandle.getNext();
        }
    }

    private static boolean contains(int[] nArray, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    static Verifier access$000(Pass3aVerifier pass3aVerifier) {
        return pass3aVerifier.myOwner;
    }

    static int access$100(Pass3aVerifier pass3aVerifier) {
        return pass3aVerifier.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;
        private final Pass3aVerifier this$0;

        InstOperandConstraintVisitor(Pass3aVerifier pass3aVerifier, ConstantPoolGen constantPoolGen) {
            this.this$0 = pass3aVerifier;
            this.cpg = constantPoolGen;
        }

        private int max_locals() {
            return Repository.lookupClass(Pass3aVerifier.access$000(this.this$0).getClassName()).getMethods()[Pass3aVerifier.access$100(this.this$0)].getCode().getMaxLocals();
        }

        private void constraintViolated(Instruction instruction, String string) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + instruction + " constraint violated: " + string);
        }

        private void indexValid(Instruction instruction, int n2) {
            if (n2 < 0 || n2 >= this.cpg.getSize()) {
                this.constraintViolated(instruction, "Illegal constant pool index '" + n2 + "'.");
            }
        }

        public void visitLoadClass(LoadClass loadClass) {
            Verifier verifier;
            VerificationResult verificationResult;
            ObjectType objectType = loadClass.getLoadClassType(this.cpg);
            if (objectType != null && (verificationResult = (verifier = VerifierFactory.getVerifier(objectType.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)loadClass), "Class '" + loadClass.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + verificationResult + "'.");
            }
        }

        public void visitLDC(LDC lDC) {
            this.indexValid(lDC, lDC.getIndex());
            Constant constant = this.cpg.getConstant(lDC.getIndex());
            if (!(constant instanceof ConstantInteger || constant instanceof ConstantFloat || constant instanceof ConstantString)) {
                this.constraintViolated(lDC, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + constant + "'.");
            }
        }

        public void visitLDC2_W(LDC2_W lDC2_W) {
            this.indexValid(lDC2_W, lDC2_W.getIndex());
            Constant constant = this.cpg.getConstant(lDC2_W.getIndex());
            if (!(constant instanceof ConstantLong) && !(constant instanceof ConstantDouble)) {
                this.constraintViolated(lDC2_W, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + constant + "'.");
            }
            try {
                this.indexValid(lDC2_W, lDC2_W.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException staticCodeInstructionOperandConstraintException) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        public void visitFieldInstruction(FieldInstruction fieldInstruction) {
            this.indexValid(fieldInstruction, fieldInstruction.getIndex());
            Constant constant = this.cpg.getConstant(fieldInstruction.getIndex());
            if (!(constant instanceof ConstantFieldref)) {
                this.constraintViolated(fieldInstruction, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + constant + "'.");
            }
        }

        public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
            Object object;
            Object object2;
            Object object3;
            this.indexValid(invokeInstruction, invokeInstruction.getIndex());
            if (invokeInstruction instanceof INVOKEVIRTUAL || invokeInstruction instanceof INVOKESPECIAL || invokeInstruction instanceof INVOKESTATIC) {
                object3 = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(object3 instanceof ConstantMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_Methodref but a '" + object3 + "'.");
                } else {
                    object2 = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)object3).getNameAndTypeIndex());
                    object = (ConstantUtf8)this.cpg.getConstant(object2.getNameIndex());
                    if (((ConstantUtf8)object).getBytes().equals("<init>") && !(invokeInstruction instanceof INVOKESPECIAL)) {
                        this.constraintViolated(invokeInstruction, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!((ConstantUtf8)object).getBytes().equals("<init>") && ((ConstantUtf8)object).getBytes().startsWith("<")) {
                        this.constraintViolated(invokeInstruction, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                object3 = this.cpg.getConstant(invokeInstruction.getIndex());
                if (!(object3 instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(invokeInstruction, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + object3 + "'.");
                }
                if (((String)(object = ((ConstantUtf8)this.cpg.getConstant((object2 = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)object3).getNameAndTypeIndex())).getNameIndex())).getBytes())).equals("<init>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<init>'.");
                }
                if (((String)object).equals("<clinit>")) {
                    this.constraintViolated(invokeInstruction, "Method to invoke must not be '<clinit>'.");
                }
            }
            object3 = invokeInstruction.getReturnType(this.cpg);
            if (object3 instanceof ArrayType) {
                object3 = ((ArrayType)object3).getBasicType();
            }
            if (object3 instanceof ObjectType && ((VerificationResult)(object = (object2 = VerifierFactory.getVerifier(((ObjectType)object3).getClassName())).doPass2())).getStatus() != 1) {
                this.constraintViolated(invokeInstruction, "Return type class/interface could not be verified successfully: '" + ((VerificationResult)object).getMessage() + "'.");
            }
            object2 = invokeInstruction.getArgumentTypes(this.cpg);
            int n2 = 0;
            while (n2 < ((Type[])object2).length) {
                Verifier verifier;
                VerificationResult verificationResult;
                object3 = object2[n2];
                if (object3 instanceof ArrayType) {
                    object3 = ((ArrayType)object3).getBasicType();
                }
                if (object3 instanceof ObjectType && (verificationResult = (verifier = VerifierFactory.getVerifier(((ObjectType)object3).getClassName())).doPass2()).getStatus() != 1) {
                    this.constraintViolated(invokeInstruction, "Argument type class/interface could not be verified successfully: '" + verificationResult.getMessage() + "'.");
                }
                ++n2;
            }
        }

        public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
            this.indexValid(iNSTANCEOF, iNSTANCEOF.getIndex());
            Constant constant = this.cpg.getConstant(iNSTANCEOF.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(iNSTANCEOF, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        public void visitCHECKCAST(CHECKCAST cHECKCAST) {
            this.indexValid(cHECKCAST, cHECKCAST.getIndex());
            Constant constant = this.cpg.getConstant(cHECKCAST.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(cHECKCAST, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
        }

        public void visitNEW(NEW nEW) {
            this.indexValid(nEW, nEW.getIndex());
            Constant constant = this.cpg.getConstant(nEW.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(nEW, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            } else {
                ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)constant).getNameIndex());
                Type type = Type.getType("L" + constantUtf8.getBytes() + ";");
                if (type instanceof ArrayType) {
                    this.constraintViolated(nEW, "NEW must not be used to create an array.");
                }
            }
        }

        public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
            Type type;
            short s2;
            this.indexValid(mULTIANEWARRAY, mULTIANEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(mULTIANEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((s2 = mULTIANEWARRAY.getDimensions()) < 1) {
                this.constraintViolated(mULTIANEWARRAY, "Number of dimensions to create must be greater than zero.");
            }
            if ((type = mULTIANEWARRAY.getType(this.cpg)) instanceof ArrayType) {
                int n2 = ((ArrayType)type).getDimensions();
                if (n2 < s2) {
                    this.constraintViolated(mULTIANEWARRAY, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + type + "'.");
                }
            } else {
                this.constraintViolated(mULTIANEWARRAY, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
            int n2;
            Type type;
            this.indexValid(aNEWARRAY, aNEWARRAY.getIndex());
            Constant constant = this.cpg.getConstant(aNEWARRAY.getIndex());
            if (!(constant instanceof ConstantClass)) {
                this.constraintViolated(aNEWARRAY, "Expecting a CONSTANT_Class operand, but found a '" + constant + "'.");
            }
            if ((type = aNEWARRAY.getType(this.cpg)) instanceof ArrayType && (n2 = ((ArrayType)type).getDimensions()) >= 255) {
                this.constraintViolated(aNEWARRAY, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        public void visitNEWARRAY(NEWARRAY nEWARRAY) {
            byte by2 = nEWARRAY.getTypecode();
            if (by2 != 4 && by2 != 5 && by2 != 6 && by2 != 7 && by2 != 8 && by2 != 9 && by2 != 10 && by2 != 11) {
                this.constraintViolated(nEWARRAY, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        public void visitILOAD(ILOAD iLOAD) {
            int n2 = iLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitFLOAD(FLOAD fLOAD) {
            int n2 = fLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(fLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(fLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitALOAD(ALOAD aLOAD) {
            int n2 = aLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(aLOAD, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(aLOAD, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitISTORE(ISTORE iSTORE) {
            int n2 = iSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitFSTORE(FSTORE fSTORE) {
            int n2 = fSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(fSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(fSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitASTORE(ASTORE aSTORE) {
            int n2 = aSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(aSTORE, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(aSTORE, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitIINC(IINC iINC) {
            int n2 = iINC.getIndex();
            if (n2 < 0) {
                this.constraintViolated(iINC, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(iINC, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitRET(RET rET) {
            int n2 = rET.getIndex();
            if (n2 < 0) {
                this.constraintViolated(rET, "Index '" + n2 + "' must be non-negative.");
            } else {
                int n3 = this.max_locals() - 1;
                if (n2 > n3) {
                    this.constraintViolated(rET, "Index '" + n2 + "' must not be greater than max_locals-1 '" + n3 + "'.");
                }
            }
        }

        public void visitLLOAD(LLOAD lLOAD) {
            int n2 = lLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(lLOAD, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(lLOAD, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitDLOAD(DLOAD dLOAD) {
            int n2 = dLOAD.getIndex();
            if (n2 < 0) {
                this.constraintViolated(dLOAD, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(dLOAD, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitLSTORE(LSTORE lSTORE) {
            int n2 = lSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(lSTORE, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(lSTORE, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitDSTORE(DSTORE dSTORE) {
            int n2 = dSTORE.getIndex();
            if (n2 < 0) {
                this.constraintViolated(dSTORE, "Index '" + n2 + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int n3 = this.max_locals() - 2;
                if (n2 > n3) {
                    this.constraintViolated(dSTORE, "Index '" + n2 + "' must not be greater than max_locals-2 '" + n3 + "'.");
                }
            }
        }

        public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
            int[] nArray = lOOKUPSWITCH.getMatchs();
            int n2 = Integer.MIN_VALUE;
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] == n2 && n3 != 0) {
                    this.constraintViolated(lOOKUPSWITCH, "Match '" + nArray[n3] + "' occurs more than once.");
                }
                if (nArray[n3] < n2) {
                    this.constraintViolated(lOOKUPSWITCH, "Lookup table must be sorted but isn't.");
                } else {
                    n2 = nArray[n3];
                }
                ++n3;
            }
        }

        public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        }

        public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
            String string = pUTSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(pUTSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            int n2 = 0;
            while (n2 < fieldArray.length) {
                if (fieldArray[n2].getName().equals(string)) {
                    accessFlags = fieldArray[n2];
                    break;
                }
                ++n2;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (accessFlags.isFinal() && !Pass3aVerifier.access$000(this.this$0).getClassName().equals(pUTSTATIC.getClassType(this.cpg).getClassName())) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.access$000(this.this$0).getClassName() + "' which is not the case: it is declared in '" + pUTSTATIC.getClassType(this.cpg).getClassName() + "'.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(pUTSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
            String string2 = Repository.lookupClass(Pass3aVerifier.access$000(this.this$0).getClassName()).getMethods()[Pass3aVerifier.access$100(this.this$0)].getName();
            if (!javaClass.isClass() && !string2.equals("<clinit>")) {
                this.constraintViolated(pUTSTATIC, "Interface field '" + accessFlags + "' must be set in a '" + "<clinit>" + "' method.");
            }
        }

        public void visitGETSTATIC(GETSTATIC gETSTATIC) {
            String string = gETSTATIC.getFieldName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(gETSTATIC.getClassType(this.cpg).getClassName());
            Field[] fieldArray = javaClass.getFields();
            AccessFlags accessFlags = null;
            int n2 = 0;
            while (n2 < fieldArray.length) {
                if (fieldArray[n2].getName().equals(string)) {
                    accessFlags = fieldArray[n2];
                    break;
                }
                ++n2;
            }
            if (accessFlags == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(gETSTATIC, "Referenced field '" + accessFlags + "' is not static which it should be.");
            }
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
            String string = iNVOKEINTERFACE.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            int n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().equals(iNVOKEINTERFACE.getMethodName(this.cpg)) && Type.getReturnType(methodArray[n2].getSignature()).equals(iNVOKEINTERFACE.getReturnType(this.cpg)) && this.objarrayequals(Type.getArgumentTypes(methodArray[n2].getSignature()), iNVOKEINTERFACE.getArgumentTypes(this.cpg))) {
                    method = methodArray[n2];
                    break;
                }
                ++n2;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced method '" + iNVOKEINTERFACE.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (javaClass.isClass()) {
                this.constraintViolated(iNVOKEINTERFACE, "Referenced class '" + javaClass.getClassName() + "' is a class, but not an interface as expected.");
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
            JavaClass javaClass;
            String string = iNVOKESPECIAL.getClassName(this.cpg);
            JavaClass javaClass2 = Repository.lookupClass(string);
            Method[] methodArray = javaClass2.getMethods();
            Method method = null;
            int n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) && Type.getReturnType(methodArray[n2].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) && this.objarrayequals(Type.getArgumentTypes(methodArray[n2].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) {
                    method = methodArray[n2];
                    break;
                }
                ++n2;
            }
            if (method == null) {
                this.constraintViolated(iNVOKESPECIAL, "Referenced method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass2.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if ((javaClass = Repository.lookupClass(Pass3aVerifier.access$000(this.this$0).getClassName())).isSuper() && Repository.instanceOf(javaClass, javaClass2) && !javaClass.equals(javaClass2) && !iNVOKESPECIAL.getMethodName(this.cpg).equals("<init>")) {
                int n3 = -1;
                Method method2 = null;
                while (n3 != 0) {
                    n3 = javaClass.getSuperclassNameIndex();
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                    Method[] methodArray2 = javaClass.getMethods();
                    int n4 = 0;
                    while (n4 < methodArray2.length) {
                        if (methodArray2[n4].getName().equals(iNVOKESPECIAL.getMethodName(this.cpg)) && Type.getReturnType(methodArray2[n4].getSignature()).equals(iNVOKESPECIAL.getReturnType(this.cpg)) && this.objarrayequals(Type.getArgumentTypes(methodArray2[n4].getSignature()), iNVOKESPECIAL.getArgumentTypes(this.cpg))) {
                            method2 = methodArray2[n4];
                            break;
                        }
                        ++n4;
                    }
                    if (method2 != null) break;
                }
                if (method2 == null) {
                    this.constraintViolated(iNVOKESPECIAL, "ACC_SUPER special lookup procedure not successful: method '" + iNVOKESPECIAL.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                }
            }
        }

        public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
            String string = iNVOKESTATIC.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            AccessFlags accessFlags = null;
            int n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().equals(iNVOKESTATIC.getMethodName(this.cpg)) && Type.getReturnType(methodArray[n2].getSignature()).equals(iNVOKESTATIC.getReturnType(this.cpg)) && this.objarrayequals(Type.getArgumentTypes(methodArray[n2].getSignature()), iNVOKESTATIC.getArgumentTypes(this.cpg))) {
                    accessFlags = methodArray[n2];
                    break;
                }
                ++n2;
            }
            if (accessFlags == null) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!accessFlags.isStatic()) {
                this.constraintViolated(iNVOKESTATIC, "Referenced method '" + iNVOKESTATIC.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
            }
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
            String string = iNVOKEVIRTUAL.getClassName(this.cpg);
            JavaClass javaClass = Repository.lookupClass(string);
            Method[] methodArray = javaClass.getMethods();
            Method method = null;
            int n2 = 0;
            while (n2 < methodArray.length) {
                if (methodArray[n2].getName().equals(iNVOKEVIRTUAL.getMethodName(this.cpg)) && Type.getReturnType(methodArray[n2].getSignature()).equals(iNVOKEVIRTUAL.getReturnType(this.cpg)) && this.objarrayequals(Type.getArgumentTypes(methodArray[n2].getSignature()), iNVOKEVIRTUAL.getArgumentTypes(this.cpg))) {
                    method = methodArray[n2];
                    break;
                }
                ++n2;
            }
            if (method == null) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced method '" + iNVOKEVIRTUAL.getMethodName(this.cpg) + "' with expected signature not found in class '" + javaClass.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!javaClass.isClass()) {
                this.constraintViolated(iNVOKEVIRTUAL, "Referenced class '" + javaClass.getClassName() + "' is an interface, but not a class as expected.");
            }
        }

        private boolean objarrayequals(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (!objectArray[n2].equals(objectArray2[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

