/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.bcel.Constants;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.ClassConstraintException;
import org.apache.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import org.apache.bcel.verifier.statics.LocalVariablesInfo;
import org.apache.bcel.verifier.statics.StringRepresentation;

public final class Pass2Verifier
extends PassVerifier
implements Constants {
    private LocalVariablesInfo[] localVariablesInfos;
    private Verifier myOwner;

    public Pass2Verifier(Verifier verifier) {
        this.myOwner = verifier;
    }

    public LocalVariablesInfo getLocalVariablesInfo(int n2) {
        if (this.verify() != VerificationResult.VR_OK) {
            return null;
        }
        if (n2 < 0 || n2 >= this.localVariablesInfos.length) {
            throw new AssertionViolatedException("Method number out of range.");
        }
        return this.localVariablesInfos[n2];
    }

    public VerificationResult do_verify() {
        VerificationResult verificationResult = this.myOwner.doPass1();
        if (verificationResult.equals(VerificationResult.VR_OK)) {
            this.localVariablesInfos = new LocalVariablesInfo[Repository.lookupClass(this.myOwner.getClassName()).getMethods().length];
            VerificationResult verificationResult2 = VerificationResult.VR_OK;
            try {
                this.constant_pool_entries_satisfy_static_constraints();
                this.field_and_method_refs_are_valid();
                this.every_class_has_an_accessible_superclass();
                this.final_methods_are_not_overridden();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult2 = new VerificationResult(2, classConstraintException.getMessage());
            }
            return verificationResult2;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void every_class_has_an_accessible_superclass() {
        HashSet<String> hashSet = new HashSet<String>();
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        int n2 = -1;
        while (n2 != 0) {
            n2 = javaClass.getSuperclassNameIndex();
            if (n2 == 0) {
                if (javaClass == Repository.lookupClass(Type.OBJECT.getClassName())) continue;
                throw new ClassConstraintException("Superclass of '" + javaClass.getClassName() + "' missing but not " + Type.OBJECT.getClassName() + " itself!");
            }
            String string = javaClass.getSuperclassName();
            if (!hashSet.add(string)) {
                throw new ClassConstraintException("Circular superclass hierarchy detected.");
            }
            Verifier verifier = VerifierFactory.getVerifier(string);
            VerificationResult verificationResult = verifier.doPass1();
            if (verificationResult != VerificationResult.VR_OK) {
                throw new ClassConstraintException("Could not load in ancestor class '" + string + "'.");
            }
            javaClass = Repository.lookupClass(string);
            if (!javaClass.isFinal()) continue;
            throw new ClassConstraintException("Ancestor class '" + string + "' has the FINAL access modifier and must therefore not be subclassed.");
        }
    }

    private void final_methods_are_not_overridden() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        int n2 = -1;
        while (n2 != 0) {
            n2 = javaClass.getSuperclassNameIndex();
            ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
            Method[] methodArray = javaClass.getMethods();
            int n3 = 0;
            while (n3 < methodArray.length) {
                String string = methodArray[n3].getName() + methodArray[n3].getSignature();
                if (hashMap.containsKey(string)) {
                    if (methodArray[n3].isFinal()) {
                        throw new ClassConstraintException("Method '" + string + "' in class '" + hashMap.get(string) + "' overrides the final (not-overridable) definition in class '" + javaClass.getClassName() + "'.");
                    }
                    if (!methodArray[n3].isStatic()) {
                        hashMap.put(string, javaClass.getClassName());
                    }
                } else if (!methodArray[n3].isStatic()) {
                    hashMap.put(string, javaClass.getClassName());
                }
                ++n3;
            }
            javaClass = Repository.lookupClass(javaClass.getSuperclassName());
        }
    }

    private void constant_pool_entries_satisfy_static_constraints() {
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        new CPESSC_Visitor(this, javaClass, null);
    }

    private void field_and_method_refs_are_valid() {
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        DescendingVisitor descendingVisitor = new DescendingVisitor(javaClass, new FAMRAV_Visitor(this, javaClass, null));
        descendingVisitor.visit();
    }

    private static final boolean validClassName(String string) {
        return true;
    }

    private static boolean validMethodName(String string, boolean bl2) {
        if (Pass2Verifier.validJavaLangMethodName(string)) {
            return true;
        }
        if (bl2) {
            return string.equals("<init>") || string.equals("<clinit>");
        }
        return string.equals("<init>");
    }

    private static boolean validClassMethodName(String string) {
        return Pass2Verifier.validMethodName(string, false);
    }

    private static boolean validJavaLangMethodName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean validInterfaceMethodName(String string) {
        if (string.startsWith("<")) {
            return false;
        }
        return Pass2Verifier.validJavaLangMethodName(string);
    }

    private static boolean validJavaIdentifier(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean validFieldName(String string) {
        return Pass2Verifier.validJavaIdentifier(string);
    }

    private static String tostring(Node node) {
        return new StringRepresentation(node).toString();
    }

    static String access$100(Node node) {
        return Pass2Verifier.tostring(node);
    }

    static boolean access$200(String string) {
        return Pass2Verifier.validFieldName(string);
    }

    static boolean access$300(String string, boolean bl2) {
        return Pass2Verifier.validMethodName(string, bl2);
    }

    static Verifier access$400(Pass2Verifier pass2Verifier) {
        return pass2Verifier.myOwner;
    }

    static LocalVariablesInfo[] access$500(Pass2Verifier pass2Verifier) {
        return pass2Verifier.localVariablesInfos;
    }

    static boolean access$600(String string) {
        return Pass2Verifier.validJavaIdentifier(string);
    }

    static boolean access$800(String string) {
        return Pass2Verifier.validClassName(string);
    }

    static boolean access$900(String string) {
        return Pass2Verifier.validClassMethodName(string);
    }

    static boolean access$1000(String string) {
        return Pass2Verifier.validInterfaceMethodName(string);
    }

    class 1 {
    }

    private class InnerClassDetector
    extends EmptyVisitor {
        private boolean hasInnerClass;
        private JavaClass jc;
        private ConstantPool cp;
        private final Pass2Verifier this$0;

        private InnerClassDetector(Pass2Verifier pass2Verifier) {
            this.this$0 = pass2Verifier;
            this.hasInnerClass = false;
        }

        public InnerClassDetector(Pass2Verifier pass2Verifier, JavaClass javaClass) {
            this.this$0 = pass2Verifier;
            this.hasInnerClass = false;
            this.jc = javaClass;
            this.cp = this.jc.getConstantPool();
            new DescendingVisitor(this.jc, this).visit();
        }

        public boolean innerClassReferenced() {
            return this.hasInnerClass;
        }

        public void visitConstantClass(ConstantClass constantClass) {
            String string;
            Constant constant = this.cp.getConstant(constantClass.getNameIndex());
            if (constant instanceof ConstantUtf8 && (string = ((ConstantUtf8)constant).getBytes()).startsWith(this.jc.getClassName().replace('.', '/') + "$")) {
                this.hasInnerClass = true;
            }
        }
    }

    private class FAMRAV_Visitor
    extends EmptyVisitor
    implements Visitor {
        private final JavaClass jc;
        private final ConstantPool cp;
        private final Pass2Verifier this$0;

        private FAMRAV_Visitor(Pass2Verifier pass2Verifier, JavaClass javaClass) {
            this.this$0 = pass2Verifier;
            this.jc = javaClass;
            this.cp = javaClass.getConstantPool();
        }

        public void visitConstantFieldref(ConstantFieldref constantFieldref) {
            if (constantFieldref.getTag() != 9) {
                throw new ClassConstraintException("ConstantFieldref '" + Pass2Verifier.access$100(constantFieldref) + "' has wrong tag!");
            }
            int n2 = constantFieldref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n2);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.access$200(string)) {
                throw new ClassConstraintException("Invalid field name '" + string + "' referenced by '" + Pass2Verifier.access$100(constantFieldref) + "'.");
            }
            int n3 = constantFieldref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.access$800(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.access$100(constantFieldref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getType(string3);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.access$100(constantFieldref) + "'.");
            }
        }

        public void visitConstantMethodref(ConstantMethodref constantMethodref) {
            if (constantMethodref.getTag() != 10) {
                throw new ClassConstraintException("ConstantMethodref '" + Pass2Verifier.access$100(constantMethodref) + "' has wrong tag!");
            }
            int n2 = constantMethodref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n2);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.access$900(string)) {
                throw new ClassConstraintException("Invalid (non-interface) method name '" + string + "' referenced by '" + Pass2Verifier.access$100(constantMethodref) + "'.");
            }
            int n3 = constantMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.access$800(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.access$100(constantMethodref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getReturnType(string3);
                Type[] typeArray = Type.getArgumentTypes(string3);
                if (string.equals("<init>") && type != Type.VOID) {
                    throw new ClassConstraintException("Instance initialization method must have VOID return type.");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.access$100(constantMethodref) + "'.");
            }
        }

        public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
            if (constantInterfaceMethodref.getTag() != 11) {
                throw new ClassConstraintException("ConstantInterfaceMethodref '" + Pass2Verifier.access$100(constantInterfaceMethodref) + "' has wrong tag!");
            }
            int n2 = constantInterfaceMethodref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n2);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.access$1000(string)) {
                throw new ClassConstraintException("Invalid (interface) method name '" + string + "' referenced by '" + Pass2Verifier.access$100(constantInterfaceMethodref) + "'.");
            }
            int n3 = constantInterfaceMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.access$800(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.access$100(constantInterfaceMethodref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getReturnType(string3);
                Type[] typeArray = Type.getArgumentTypes(string3);
                if (string.equals("<clinit>") && type != Type.VOID) {
                    this.this$0.addMessage("Class or interface initialization method '<clinit>' usually has VOID return type instead of '" + type + "'. Note this is really not a requirement of The Java Virtual Machine Specification, Second Edition.");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.access$100(constantInterfaceMethodref) + "'.");
            }
        }

        FAMRAV_Visitor(Pass2Verifier pass2Verifier, JavaClass javaClass, 1 var3_3) {
            this(pass2Verifier, javaClass);
        }
    }

    private class CPESSC_Visitor
    extends EmptyVisitor
    implements Visitor {
        private Class CONST_Class;
        private Class CONST_Fieldref;
        private Class CONST_Methodref;
        private Class CONST_InterfaceMethodref;
        private Class CONST_String;
        private Class CONST_Integer;
        private Class CONST_Float;
        private Class CONST_Long;
        private Class CONST_Double;
        private Class CONST_NameAndType;
        private Class CONST_Utf8;
        private final JavaClass jc;
        private final ConstantPool cp;
        private final int cplen;
        private DescendingVisitor carrier;
        private HashSet field_names;
        private HashSet field_names_and_desc;
        private HashSet method_names_and_desc;
        static Class class$org$apache$bcel$classfile$ConstantClass;
        static Class class$org$apache$bcel$classfile$ConstantFieldref;
        static Class class$org$apache$bcel$classfile$ConstantMethodref;
        static Class class$org$apache$bcel$classfile$ConstantInterfaceMethodref;
        static Class class$org$apache$bcel$classfile$ConstantString;
        static Class class$org$apache$bcel$classfile$ConstantInteger;
        static Class class$org$apache$bcel$classfile$ConstantFloat;
        static Class class$org$apache$bcel$classfile$ConstantLong;
        static Class class$org$apache$bcel$classfile$ConstantDouble;
        static Class class$org$apache$bcel$classfile$ConstantNameAndType;
        static Class class$org$apache$bcel$classfile$ConstantUtf8;
        private final Pass2Verifier this$0;

        private CPESSC_Visitor(Pass2Verifier pass2Verifier, JavaClass javaClass) {
            this.this$0 = pass2Verifier;
            this.field_names = new HashSet();
            this.field_names_and_desc = new HashSet();
            this.method_names_and_desc = new HashSet();
            this.jc = javaClass;
            this.cp = javaClass.getConstantPool();
            this.cplen = this.cp.getLength();
            this.CONST_Class = class$org$apache$bcel$classfile$ConstantClass == null ? (class$org$apache$bcel$classfile$ConstantClass = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantClass")) : class$org$apache$bcel$classfile$ConstantClass;
            this.CONST_Fieldref = class$org$apache$bcel$classfile$ConstantFieldref == null ? (class$org$apache$bcel$classfile$ConstantFieldref = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantFieldref")) : class$org$apache$bcel$classfile$ConstantFieldref;
            this.CONST_Methodref = class$org$apache$bcel$classfile$ConstantMethodref == null ? (class$org$apache$bcel$classfile$ConstantMethodref = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantMethodref")) : class$org$apache$bcel$classfile$ConstantMethodref;
            this.CONST_InterfaceMethodref = class$org$apache$bcel$classfile$ConstantInterfaceMethodref == null ? (class$org$apache$bcel$classfile$ConstantInterfaceMethodref = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantInterfaceMethodref")) : class$org$apache$bcel$classfile$ConstantInterfaceMethodref;
            this.CONST_String = class$org$apache$bcel$classfile$ConstantString == null ? (class$org$apache$bcel$classfile$ConstantString = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantString")) : class$org$apache$bcel$classfile$ConstantString;
            this.CONST_Integer = class$org$apache$bcel$classfile$ConstantInteger == null ? (class$org$apache$bcel$classfile$ConstantInteger = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantInteger")) : class$org$apache$bcel$classfile$ConstantInteger;
            this.CONST_Float = class$org$apache$bcel$classfile$ConstantFloat == null ? (class$org$apache$bcel$classfile$ConstantFloat = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantFloat")) : class$org$apache$bcel$classfile$ConstantFloat;
            this.CONST_Long = class$org$apache$bcel$classfile$ConstantLong == null ? (class$org$apache$bcel$classfile$ConstantLong = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantLong")) : class$org$apache$bcel$classfile$ConstantLong;
            this.CONST_Double = class$org$apache$bcel$classfile$ConstantDouble == null ? (class$org$apache$bcel$classfile$ConstantDouble = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantDouble")) : class$org$apache$bcel$classfile$ConstantDouble;
            this.CONST_NameAndType = class$org$apache$bcel$classfile$ConstantNameAndType == null ? (class$org$apache$bcel$classfile$ConstantNameAndType = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantNameAndType")) : class$org$apache$bcel$classfile$ConstantNameAndType;
            this.CONST_Utf8 = class$org$apache$bcel$classfile$ConstantUtf8 == null ? (class$org$apache$bcel$classfile$ConstantUtf8 = CPESSC_Visitor.class$("org.apache.bcel.classfile.ConstantUtf8")) : class$org$apache$bcel$classfile$ConstantUtf8;
            this.carrier = new DescendingVisitor(javaClass, this);
            this.carrier.visit();
        }

        private void checkIndex(Node node, int n2, Class clazz) {
            if (n2 < 0 || n2 >= this.cplen) {
                throw new ClassConstraintException("Invalid index '" + n2 + "' used by '" + Pass2Verifier.access$100(node) + "'.");
            }
            Constant constant = this.cp.getConstant(n2);
            if (!clazz.isInstance(constant)) {
                String string = clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1);
                throw new ClassCastException("Illegal constant '" + Pass2Verifier.access$100(constant) + "' at index '" + n2 + "'. '" + Pass2Verifier.access$100(node) + "' expects a '" + clazz + "'.");
            }
        }

        public void visitJavaClass(JavaClass javaClass) {
            Attribute[] attributeArray = javaClass.getAttributes();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = new InnerClassDetector(this.this$0, this.jc).innerClassReferenced();
            int n2 = 0;
            while (n2 < attributeArray.length) {
                if (!(attributeArray[n2] instanceof SourceFile || attributeArray[n2] instanceof Deprecated || attributeArray[n2] instanceof InnerClasses || attributeArray[n2] instanceof Synthetic)) {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(attributeArray[n2]) + "' as an attribute of the ClassFile structure '" + Pass2Verifier.access$100(javaClass) + "' is unknown and will therefore be ignored.");
                }
                if (attributeArray[n2] instanceof SourceFile) {
                    if (!bl2) {
                        bl2 = true;
                    } else {
                        throw new ClassConstraintException("A ClassFile structure (like '" + Pass2Verifier.access$100(javaClass) + "') may have no more than one SourceFile attribute.");
                    }
                }
                if (attributeArray[n2] instanceof InnerClasses) {
                    if (!bl3) {
                        bl3 = true;
                    } else if (bl4) {
                        throw new ClassConstraintException("A Classfile structure (like '" + Pass2Verifier.access$100(javaClass) + "') must have exactly one InnerClasses attribute if at least one Inner Class is referenced (which is the case). More than one InnerClasses attribute was found.");
                    }
                    if (!bl4) {
                        this.this$0.addMessage("No referenced Inner Class found, but InnerClasses attribute '" + Pass2Verifier.access$100(attributeArray[n2]) + "' found. Strongly suggest removal of that attribute.");
                    }
                }
                ++n2;
            }
            if (bl4 && !bl3) {
                this.this$0.addMessage("A Classfile structure (like '" + Pass2Verifier.access$100(javaClass) + "') must have exactly one InnerClasses attribute if at least one Inner Class is referenced (which is the case). No InnerClasses attribute was found.");
            }
        }

        public void visitConstantClass(ConstantClass constantClass) {
            if (constantClass.getTag() != 7) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantClass) + "'.");
            }
            this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
        }

        public void visitConstantFieldref(ConstantFieldref constantFieldref) {
            if (constantFieldref.getTag() != 9) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantFieldref) + "'.");
            }
            this.checkIndex(constantFieldref, constantFieldref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantFieldref, constantFieldref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantMethodref(ConstantMethodref constantMethodref) {
            if (constantMethodref.getTag() != 10) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantMethodref) + "'.");
            }
            this.checkIndex(constantMethodref, constantMethodref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantMethodref, constantMethodref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
            if (constantInterfaceMethodref.getTag() != 11) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantInterfaceMethodref) + "'.");
            }
            this.checkIndex(constantInterfaceMethodref, constantInterfaceMethodref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantInterfaceMethodref, constantInterfaceMethodref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantString(ConstantString constantString) {
            if (constantString.getTag() != 8) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantString) + "'.");
            }
            this.checkIndex(constantString, constantString.getStringIndex(), this.CONST_Utf8);
        }

        public void visitConstantInteger(ConstantInteger constantInteger) {
            if (constantInteger.getTag() != 3) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantInteger) + "'.");
            }
        }

        public void visitConstantFloat(ConstantFloat constantFloat) {
            if (constantFloat.getTag() != 4) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantFloat) + "'.");
            }
        }

        public void visitConstantLong(ConstantLong constantLong) {
            if (constantLong.getTag() != 5) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantLong) + "'.");
            }
        }

        public void visitConstantDouble(ConstantDouble constantDouble) {
            if (constantDouble.getTag() != 6) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantDouble) + "'.");
            }
        }

        public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
            if (constantNameAndType.getTag() != 12) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantNameAndType) + "'.");
            }
            this.checkIndex(constantNameAndType, constantNameAndType.getNameIndex(), this.CONST_Utf8);
            this.checkIndex(constantNameAndType, constantNameAndType.getSignatureIndex(), this.CONST_Utf8);
        }

        public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
            if (constantUtf8.getTag() != 1) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.access$100(constantUtf8) + "'.");
            }
        }

        public void visitField(Field field) {
            Object object;
            if (this.jc.isClass()) {
                int n2 = 0;
                if (field.isPrivate()) {
                    ++n2;
                }
                if (field.isProtected()) {
                    ++n2;
                }
                if (field.isPublic()) {
                    ++n2;
                }
                if (n2 > 1) {
                    throw new ClassConstraintException("Field '" + Pass2Verifier.access$100(field) + "' must only have at most one of its ACC_PRIVATE, ACC_PROTECTED, ACC_PUBLIC modifiers set.");
                }
                if (field.isFinal() && field.isVolatile()) {
                    throw new ClassConstraintException("Field '" + Pass2Verifier.access$100(field) + "' must only have at most one of its ACC_FINAL, ACC_VOLATILE modifiers set.");
                }
            } else {
                if (!field.isPublic()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.access$100(field) + "' must have the ACC_PUBLIC modifier set but hasn't!");
                }
                if (!field.isStatic()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.access$100(field) + "' must have the ACC_STATIC modifier set but hasn't!");
                }
                if (!field.isFinal()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.access$100(field) + "' must have the ACC_FINAL modifier set but hasn't!");
                }
            }
            if ((field.getAccessFlags() & 0xFFFFFF20) > 0) {
                this.this$0.addMessage("Field '" + Pass2Verifier.access$100(field) + "' has access flag(s) other than ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_VOLATILE, ACC_TRANSIENT set (ignored).");
            }
            this.checkIndex(field, field.getNameIndex(), this.CONST_Utf8);
            String string = field.getName();
            if (!Pass2Verifier.access$200(string)) {
                throw new ClassConstraintException("Field '" + Pass2Verifier.access$100(field) + "' has illegal name '" + field.getName() + "'.");
            }
            this.checkIndex(field, field.getSignatureIndex(), this.CONST_Utf8);
            String string2 = ((ConstantUtf8)this.cp.getConstant(field.getSignatureIndex())).getBytes();
            try {
                object = Type.getType(string2);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string2 + "' used by '" + Pass2Verifier.access$100(field) + "'.");
            }
            object = string + string2;
            if (this.field_names_and_desc.contains(object)) {
                throw new ClassConstraintException("No two fields (like '" + Pass2Verifier.access$100(field) + "') are allowed have same names and descriptors!");
            }
            if (this.field_names.contains(string)) {
                this.this$0.addMessage("More than one field of name '" + string + "' detected (but with different type descriptors). This is very unusual.");
            }
            this.field_names_and_desc.add(object);
            this.field_names.add(string);
            Attribute[] attributeArray = field.getAttributes();
            int n3 = 0;
            while (n3 < attributeArray.length) {
                if (!(attributeArray[n3] instanceof ConstantValue || attributeArray[n3] instanceof Synthetic || attributeArray[n3] instanceof Deprecated)) {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(attributeArray[n3]) + "' as an attribute of Field '" + Pass2Verifier.access$100(field) + "' is unknown and will therefore be ignored.");
                }
                if (!(attributeArray[n3] instanceof ConstantValue)) {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(attributeArray[n3]) + "' as an attribute of Field '" + Pass2Verifier.access$100(field) + "' is not a ConstantValue and is therefore only of use for debuggers and such.");
                }
                ++n3;
            }
        }

        public void visitMethod(Method method) {
            String string;
            Attribute[] attributeArray;
            Verifier verifier;
            Object object;
            Type[] typeArray;
            Type type;
            this.checkIndex(method, method.getNameIndex(), this.CONST_Utf8);
            String string2 = method.getName();
            if (!Pass2Verifier.access$300(string2, true)) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.access$100(method) + "' has illegal name '" + string2 + "'.");
            }
            this.checkIndex(method, method.getSignatureIndex(), this.CONST_Utf8);
            String string3 = ((ConstantUtf8)this.cp.getConstant(method.getSignatureIndex())).getBytes();
            try {
                type = Type.getReturnType(string3);
                typeArray = Type.getArgumentTypes(string3);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by Method '" + Pass2Verifier.access$100(method) + "'.");
            }
            Type type2 = type;
            if (type2 instanceof ArrayType) {
                type2 = ((ArrayType)type2).getBasicType();
            }
            if (type2 instanceof ObjectType && (object = (verifier = VerifierFactory.getVerifier(((ObjectType)type2).getClassName())).doPass1()) != VerificationResult.VR_OK) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.access$100(method) + "' has a return type that does not pass verification pass 1: '" + object + "'.");
            }
            int n2 = 0;
            while (n2 < typeArray.length) {
                type2 = typeArray[n2];
                if (type2 instanceof ArrayType) {
                    type2 = ((ArrayType)type2).getBasicType();
                }
                if (type2 instanceof ObjectType && (attributeArray = ((Verifier)(object = VerifierFactory.getVerifier(((ObjectType)type2).getClassName()))).doPass1()) != VerificationResult.VR_OK) {
                    throw new ClassConstraintException("Method '" + Pass2Verifier.access$100(method) + "' has an argument type that does not pass verification pass 1: '" + attributeArray + "'.");
                }
                ++n2;
            }
            if (string2.equals("<clinit>") && typeArray.length != 0) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.access$100(method) + "' has illegal name '" + string2 + "'. It's name resembles the class or interface initialization method which it isn't because of its arguments (==descriptor).");
            }
            if (this.jc.isClass()) {
                int n3 = 0;
                if (method.isPrivate()) {
                    ++n3;
                }
                if (method.isProtected()) {
                    ++n3;
                }
                if (method.isPublic()) {
                    ++n3;
                }
                if (n3 > 1) {
                    throw new ClassConstraintException("Method '" + Pass2Verifier.access$100(method) + "' must only have at most one of its ACC_PRIVATE, ACC_PROTECTED, ACC_PUBLIC modifiers set.");
                }
                if (method.isAbstract()) {
                    if (method.isFinal()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.access$100(method) + "' must not have the ACC_FINAL modifier set.");
                    }
                    if (method.isNative()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.access$100(method) + "' must not have the ACC_NATIVE modifier set.");
                    }
                    if (method.isPrivate()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.access$100(method) + "' must not have the ACC_PRIVATE modifier set.");
                    }
                    if (method.isStatic()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.access$100(method) + "' must not have the ACC_STATIC modifier set.");
                    }
                    if (method.isStrictfp()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.access$100(method) + "' must not have the ACC_STRICT modifier set.");
                    }
                    if (method.isSynchronized()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.access$100(method) + "' must not have the ACC_SYNCHRONIZED modifier set.");
                    }
                }
            } else if (!string2.equals("<clinit>")) {
                if (!method.isPublic()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.access$100(method) + "' must have the ACC_PUBLIC modifier set but hasn't!");
                }
                if (!method.isAbstract()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.access$100(method) + "' must have the ACC_STATIC modifier set but hasn't!");
                }
                if (method.isPrivate() || method.isProtected() || method.isStatic() || method.isFinal() || method.isSynchronized() || method.isNative() || method.isStrictfp()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.access$100(method) + "' must not have any of the ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT modifiers set.");
                }
            }
            if (string2.equals("<init>") && (method.isStatic() || method.isFinal() || method.isSynchronized() || method.isNative() || method.isAbstract())) {
                throw new ClassConstraintException("Instance initialization method '" + Pass2Verifier.access$100(method) + "' must not have any of the ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT modifiers set.");
            }
            if (string2.equals("<clinit>")) {
                if ((method.getAccessFlags() & 0xFFFFF7FF) > 0) {
                    this.this$0.addMessage("Class or interface initialization method '" + Pass2Verifier.access$100(method) + "' has superfluous access modifier(s) set: everything but ACC_STRICT is ignored.");
                }
                if (method.isAbstract()) {
                    throw new ClassConstraintException("Class or interface initialization method '" + Pass2Verifier.access$100(method) + "' must not be abstract. This contradicts the Java Language Specification, Second Edition (which omits this constraint) but is common practice of existing verifiers.");
                }
            }
            if ((method.getAccessFlags() & 0xFFFFF2C0) > 0) {
                this.this$0.addMessage("Method '" + Pass2Verifier.access$100(method) + "' has access flag(s) other than ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT set (ignored).");
            }
            if (this.method_names_and_desc.contains(string = string2 + string3)) {
                throw new ClassConstraintException("No two methods (like '" + Pass2Verifier.access$100(method) + "') are allowed have same names and desciptors!");
            }
            this.method_names_and_desc.add(string);
            attributeArray = method.getAttributes();
            int n4 = 0;
            int n5 = 0;
            while (n5 < attributeArray.length) {
                if (!(attributeArray[n5] instanceof Code || attributeArray[n5] instanceof ExceptionTable || attributeArray[n5] instanceof Synthetic || attributeArray[n5] instanceof Deprecated)) {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(attributeArray[n5]) + "' as an attribute of Method '" + Pass2Verifier.access$100(method) + "' is unknown and will therefore be ignored.");
                }
                if (!(attributeArray[n5] instanceof Code) && !(attributeArray[n5] instanceof ExceptionTable)) {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(attributeArray[n5]) + "' as an attribute of Method '" + Pass2Verifier.access$100(method) + "' is neither Code nor Exceptions and is therefore only of use for debuggers and such.");
                }
                if (attributeArray[n5] instanceof Code && (method.isNative() || method.isAbstract())) {
                    throw new ClassConstraintException("Native or abstract methods like '" + Pass2Verifier.access$100(method) + "' must not have a Code attribute like '" + Pass2Verifier.access$100(attributeArray[n5]) + "'.");
                }
                if (attributeArray[n5] instanceof Code) {
                    ++n4;
                }
                ++n5;
            }
            if (!method.isNative() && !method.isAbstract() && n4 != 1) {
                throw new ClassConstraintException("Non-native, non-abstract methods like '" + Pass2Verifier.access$100(method) + "' must have exactly one Code attribute (found: " + n4 + ").");
            }
        }

        public void visitSourceFile(SourceFile sourceFile) {
            this.checkIndex(sourceFile, sourceFile.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(sourceFile.getNameIndex())).getBytes();
            if (!string.equals("SourceFile")) {
                throw new ClassConstraintException("The SourceFile attribute '" + Pass2Verifier.access$100(sourceFile) + "' is not correctly named 'SourceFile' but '" + string + "'.");
            }
            this.checkIndex(sourceFile, sourceFile.getSourceFileIndex(), this.CONST_Utf8);
            String string2 = ((ConstantUtf8)this.cp.getConstant(sourceFile.getSourceFileIndex())).getBytes();
            String string3 = string2.toLowerCase();
            if (string2.indexOf(47) != -1 || string2.indexOf(92) != -1 || string2.indexOf(58) != -1 || string3.lastIndexOf(".java") == -1) {
                this.this$0.addMessage("SourceFile attribute '" + Pass2Verifier.access$100(sourceFile) + "' has a funny name: remember not to confuse certain parsers working on javap's output. Also, this name ('" + string2 + "') is considered an unqualified (simple) file name only.");
            }
        }

        public void visitDeprecated(Deprecated deprecated) {
            this.checkIndex(deprecated, deprecated.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(deprecated.getNameIndex())).getBytes();
            if (!string.equals("Deprecated")) {
                throw new ClassConstraintException("The Deprecated attribute '" + Pass2Verifier.access$100(deprecated) + "' is not correctly named 'Deprecated' but '" + string + "'.");
            }
        }

        public void visitSynthetic(Synthetic synthetic) {
            this.checkIndex(synthetic, synthetic.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(synthetic.getNameIndex())).getBytes();
            if (!string.equals("Synthetic")) {
                throw new ClassConstraintException("The Synthetic attribute '" + Pass2Verifier.access$100(synthetic) + "' is not correctly named 'Synthetic' but '" + string + "'.");
            }
        }

        public void visitInnerClasses(InnerClasses innerClasses) {
            this.checkIndex(innerClasses, innerClasses.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(innerClasses.getNameIndex())).getBytes();
            if (!string.equals("InnerClasses")) {
                throw new ClassConstraintException("The InnerClasses attribute '" + Pass2Verifier.access$100(innerClasses) + "' is not correctly named 'InnerClasses' but '" + string + "'.");
            }
            InnerClass[] innerClassArray = innerClasses.getInnerClasses();
            int n2 = 0;
            while (n2 < innerClassArray.length) {
                int n3;
                this.checkIndex(innerClasses, innerClassArray[n2].getInnerClassIndex(), this.CONST_Class);
                int n4 = innerClassArray[n2].getOuterClassIndex();
                if (n4 != 0) {
                    this.checkIndex(innerClasses, n4, this.CONST_Class);
                }
                if ((n3 = innerClassArray[n2].getInnerNameIndex()) != 0) {
                    this.checkIndex(innerClasses, n3, this.CONST_Utf8);
                }
                int n5 = innerClassArray[n2].getInnerAccessFlags();
                if ((n5 &= 0xFFFFF9E0) != 0) {
                    this.this$0.addMessage("Unknown access flag for inner class '" + Pass2Verifier.access$100(innerClassArray[n2]) + "' set (InnerClasses attribute '" + Pass2Verifier.access$100(innerClasses) + "').");
                }
                ++n2;
            }
        }

        public void visitConstantValue(ConstantValue constantValue) {
            this.checkIndex(constantValue, constantValue.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(constantValue.getNameIndex())).getBytes();
            if (!string.equals("ConstantValue")) {
                throw new ClassConstraintException("The ConstantValue attribute '" + Pass2Verifier.access$100(constantValue) + "' is not correctly named 'ConstantValue' but '" + string + "'.");
            }
            Object object = this.carrier.predecessor();
            if (object instanceof Field) {
                Field field = (Field)object;
                Type type = Type.getType(((ConstantUtf8)this.cp.getConstant(field.getSignatureIndex())).getBytes());
                int n2 = constantValue.getConstantValueIndex();
                if (n2 < 0 || n2 >= this.cplen) {
                    throw new ClassConstraintException("Invalid index '" + n2 + "' used by '" + Pass2Verifier.access$100(constantValue) + "'.");
                }
                Constant constant = this.cp.getConstant(n2);
                if (this.CONST_Long.isInstance(constant) && type.equals(Type.LONG)) {
                    return;
                }
                if (this.CONST_Float.isInstance(constant) && type.equals(Type.FLOAT)) {
                    return;
                }
                if (this.CONST_Double.isInstance(constant) && type.equals(Type.DOUBLE)) {
                    return;
                }
                if (this.CONST_Integer.isInstance(constant) && (type.equals(Type.INT) || type.equals(Type.SHORT) || type.equals(Type.CHAR) || type.equals(Type.BYTE) || type.equals(Type.BOOLEAN))) {
                    return;
                }
                if (this.CONST_String.isInstance(constant) && type.equals(Type.STRING)) {
                    return;
                }
                throw new ClassConstraintException("Illegal type of ConstantValue '" + constantValue + "' embedding Constant '" + constant + "'. It is referenced by field '" + Pass2Verifier.access$100(field) + "' expecting a different type: '" + type + "'.");
            }
        }

        public void visitCode(Code code) {
            Object object;
            Node node;
            Object object2;
            Object object3;
            int n2;
            this.checkIndex(code, code.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(code.getNameIndex())).getBytes();
            if (!string.equals("Code")) {
                throw new ClassConstraintException("The Code attribute '" + Pass2Verifier.access$100(code) + "' is not correctly named 'Code' but '" + string + "'.");
            }
            Method method = null;
            if (!(this.carrier.predecessor() instanceof Method)) {
                this.this$0.addMessage("Code attribute '" + Pass2Verifier.access$100(code) + "' is not declared in a method_info structure but in '" + this.carrier.predecessor() + "'. Ignored.");
                return;
            }
            method = (Method)this.carrier.predecessor();
            if (code.getCode().length == 0) {
                throw new ClassConstraintException("Code array of Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + method + "') must not be empty.");
            }
            CodeException[] codeExceptionArray = code.getExceptionTable();
            int n3 = 0;
            while (n3 < codeExceptionArray.length) {
                n2 = codeExceptionArray[n3].getCatchType();
                if (n2 != 0) {
                    this.checkIndex(code, n2, this.CONST_Class);
                    object3 = (ConstantClass)this.cp.getConstant(n2);
                    this.checkIndex((Node)object3, ((ConstantClass)object3).getNameIndex(), this.CONST_Utf8);
                    String string2 = ((ConstantUtf8)this.cp.getConstant(((ConstantClass)object3).getNameIndex())).getBytes().replace('/', '.');
                    Verifier verifier = VerifierFactory.getVerifier(string2);
                    object2 = verifier.doPass1();
                    if (object2 != VerificationResult.VR_OK) {
                        throw new ClassConstraintException("Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.access$100(codeExceptionArray[n3]) + "' that references '" + string2 + "' as an Exception but it does not pass verification pass 1: " + object2);
                    }
                    JavaClass javaClass = Repository.lookupClass(string2);
                    node = Repository.lookupClass(Type.THROWABLE.getClassName());
                    object = Repository.lookupClass(Type.OBJECT.getClassName());
                    while (javaClass != object) {
                        if (javaClass == node) break;
                        verifier = VerifierFactory.getVerifier(javaClass.getSuperclassName());
                        object2 = verifier.doPass1();
                        if (object2 != VerificationResult.VR_OK) {
                            throw new ClassConstraintException("Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.access$100(codeExceptionArray[n3]) + "' that references '" + string2 + "' as an Exception but '" + javaClass.getSuperclassName() + "' in the ancestor hierachy does not pass verification pass 1: " + object2);
                        }
                        javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                    }
                    if (javaClass != node) {
                        throw new ClassConstraintException("Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.access$100(codeExceptionArray[n3]) + "' that references '" + string2 + "' as an Exception but it is not a subclass of '" + ((JavaClass)node).getClassName() + "'.");
                    }
                }
                ++n3;
            }
            n2 = -1;
            object3 = Repository.lookupClass(Pass2Verifier.access$400(this.this$0).getClassName()).getMethods();
            int n4 = 0;
            while (n4 < ((Method[])object3).length) {
                if (method == object3[n4]) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            if (n2 < 0) {
                throw new AssertionViolatedException("Could not find a known BCEL Method object in the corresponding BCEL JavaClass object.");
            }
            Pass2Verifier.access$500((Pass2Verifier)this.this$0)[n2] = new LocalVariablesInfo(code.getMaxLocals());
            int n5 = 0;
            object2 = code.getAttributes();
            int n6 = 0;
            while (n6 < ((Attribute[])object2).length) {
                if (!(object2[n6] instanceof LineNumberTable) && !(object2[n6] instanceof LocalVariableTable)) {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(object2[n6]) + "' as an attribute of Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + method + "') is unknown and will therefore be ignored.");
                } else {
                    this.this$0.addMessage("Attribute '" + Pass2Verifier.access$100(object2[n6]) + "' as an attribute of Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + method + "') will effectively be ignored and is only useful for debuggers and such.");
                }
                if (object2[n6] instanceof LocalVariableTable) {
                    node = (LocalVariableTable)object2[n6];
                    this.checkIndex(node, ((Attribute)node).getNameIndex(), this.CONST_Utf8);
                    object = ((ConstantUtf8)this.cp.getConstant(((Attribute)node).getNameIndex())).getBytes();
                    if (!((String)object).equals("LocalVariableTable")) {
                        throw new ClassConstraintException("The LocalVariableTable attribute '" + Pass2Verifier.access$100(node) + "' is not correctly named 'LocalVariableTable' but '" + (String)object + "'.");
                    }
                    Code code2 = code;
                    int n7 = code2.getMaxLocals();
                    LocalVariable[] localVariableArray = ((LocalVariableTable)node).getLocalVariableTable();
                    int n8 = 0;
                    while (n8 < localVariableArray.length) {
                        Type type;
                        this.checkIndex(node, localVariableArray[n8].getNameIndex(), this.CONST_Utf8);
                        String string3 = ((ConstantUtf8)this.cp.getConstant(localVariableArray[n8].getNameIndex())).getBytes();
                        if (!Pass2Verifier.access$600(string3)) {
                            throw new ClassConstraintException("LocalVariableTable '" + Pass2Verifier.access$100(node) + "' references a local variable by the name '" + string3 + "' which is not a legal Java simple name.");
                        }
                        this.checkIndex(node, localVariableArray[n8].getSignatureIndex(), this.CONST_Utf8);
                        String string4 = ((ConstantUtf8)this.cp.getConstant(localVariableArray[n8].getSignatureIndex())).getBytes();
                        try {
                            type = Type.getType(string4);
                        }
                        catch (ClassFormatError classFormatError) {
                            throw new ClassConstraintException("Illegal descriptor (==signature) '" + string4 + "' used by LocalVariable '" + Pass2Verifier.access$100(localVariableArray[n8]) + "' referenced by '" + Pass2Verifier.access$100(node) + "'.");
                        }
                        int n9 = localVariableArray[n8].getIndex();
                        if ((type == Type.LONG || type == Type.DOUBLE ? n9 + 1 : n9) >= code2.getMaxLocals()) {
                            throw new ClassConstraintException("LocalVariableTable attribute '" + Pass2Verifier.access$100(node) + "' references a LocalVariable '" + Pass2Verifier.access$100(localVariableArray[n8]) + "' with an index that exceeds the surrounding Code attribute's max_locals value of '" + code2.getMaxLocals() + "'.");
                        }
                        try {
                            Pass2Verifier.access$500(this.this$0)[n2].add(n9, string3, localVariableArray[n8].getStartPC(), localVariableArray[n8].getLength(), type);
                        }
                        catch (LocalVariableInfoInconsistentException localVariableInfoInconsistentException) {
                            throw new ClassConstraintException("Conflicting information in LocalVariableTable '" + Pass2Verifier.access$100(node) + "' found in Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + Pass2Verifier.access$100(method) + "'). " + localVariableInfoInconsistentException.getMessage());
                        }
                        ++n8;
                    }
                    if (++n5 > code.getMaxLocals()) {
                        throw new ClassConstraintException("Number of LocalVariableTable attributes of Code attribute '" + Pass2Verifier.access$100(code) + "' (method '" + Pass2Verifier.access$100(method) + "') exceeds number of local variable slots '" + code.getMaxLocals() + "' ('There may be no more than one LocalVariableTable attribute per local variable in the Code attribute.').");
                    }
                }
                ++n6;
            }
        }

        public void visitExceptionTable(ExceptionTable exceptionTable) {
            this.checkIndex(exceptionTable, exceptionTable.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(exceptionTable.getNameIndex())).getBytes();
            if (!string.equals("Exceptions")) {
                throw new ClassConstraintException("The Exceptions attribute '" + Pass2Verifier.access$100(exceptionTable) + "' is not correctly named 'Exceptions' but '" + string + "'.");
            }
            int[] nArray = exceptionTable.getExceptionIndexTable();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.checkIndex(exceptionTable, nArray[n2], this.CONST_Class);
                ConstantClass constantClass = (ConstantClass)this.cp.getConstant(nArray[n2]);
                this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
                String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes().replace('/', '.');
                Verifier verifier = VerifierFactory.getVerifier(string2);
                VerificationResult verificationResult = verifier.doPass1();
                if (verificationResult != VerificationResult.VR_OK) {
                    throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.access$100(exceptionTable) + "' references '" + string2 + "' as an Exception but it does not pass verification pass 1: " + verificationResult);
                }
                JavaClass javaClass = Repository.lookupClass(string2);
                JavaClass javaClass2 = Repository.lookupClass(Type.THROWABLE.getClassName());
                JavaClass javaClass3 = Repository.lookupClass(Type.OBJECT.getClassName());
                while (javaClass != javaClass3) {
                    if (javaClass == javaClass2) break;
                    verifier = VerifierFactory.getVerifier(javaClass.getSuperclassName());
                    verificationResult = verifier.doPass1();
                    if (verificationResult != VerificationResult.VR_OK) {
                        throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.access$100(exceptionTable) + "' references '" + string2 + "' as an Exception but '" + javaClass.getSuperclassName() + "' in the ancestor hierachy does not pass verification pass 1: " + verificationResult);
                    }
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                }
                if (javaClass != javaClass2) {
                    throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.access$100(exceptionTable) + "' references '" + string2 + "' as an Exception but it is not a subclass of '" + javaClass2.getClassName() + "'.");
                }
                ++n2;
            }
        }

        public void visitLineNumberTable(LineNumberTable lineNumberTable) {
            this.checkIndex(lineNumberTable, lineNumberTable.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(lineNumberTable.getNameIndex())).getBytes();
            if (!string.equals("LineNumberTable")) {
                throw new ClassConstraintException("The LineNumberTable attribute '" + Pass2Verifier.access$100(lineNumberTable) + "' is not correctly named 'LineNumberTable' but '" + string + "'.");
            }
        }

        public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        }

        public void visitUnknown(Unknown unknown) {
            this.checkIndex(unknown, unknown.getNameIndex(), this.CONST_Utf8);
            this.this$0.addMessage("Unknown attribute '" + Pass2Verifier.access$100(unknown) + "'. This attribute is not known in any context!");
        }

        public void visitLocalVariable(LocalVariable localVariable) {
        }

        public void visitCodeException(CodeException codeException) {
        }

        public void visitConstantPool(ConstantPool constantPool) {
        }

        public void visitInnerClass(InnerClass innerClass) {
        }

        public void visitLineNumber(LineNumber lineNumber) {
        }

        CPESSC_Visitor(Pass2Verifier pass2Verifier, JavaClass javaClass, 1 var3_3) {
            this(pass2Verifier, javaClass);
        }

        static Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

