/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.statics.DOUBLE_Upper;
import org.apache.bcel.verifier.statics.IntList;
import org.apache.bcel.verifier.statics.LONG_Upper;
import org.apache.bcel.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private LocalVariableInfo[] localVariableInfos;
    private IntList instruction_offsets = new IntList();

    LocalVariablesInfo(int n2) {
        this.localVariableInfos = new LocalVariableInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.localVariableInfos[n3] = new LocalVariableInfo();
            ++n3;
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int n2) {
        if (n2 < 0 || n2 >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[n2];
    }

    public void add(int n2, String string, int n3, int n4, Type type) {
        if (n2 < 0 || n2 >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[n2].add(string, n3, n4, type);
        if (type == Type.LONG) {
            this.localVariableInfos[n2 + 1].add(string, n3, n4, LONG_Upper.theInstance());
        }
        if (type == Type.DOUBLE) {
            this.localVariableInfos[n2 + 1].add(string, n3, n4, DOUBLE_Upper.theInstance());
        }
    }
}

