/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactoryObserver;

public class VerifierFactory {
    private static HashMap hashMap = new HashMap();
    private static Vector observers = new Vector();

    private VerifierFactory() {
    }

    public static Verifier getVerifier(String string) {
        Verifier verifier = (Verifier)hashMap.get(string);
        if (verifier == null) {
            verifier = new Verifier(string);
            hashMap.put(string, verifier);
            VerifierFactory.notify(string);
        }
        return verifier;
    }

    private static void notify(String string) {
        Iterator iterator = ((AbstractList)observers).iterator();
        while (iterator.hasNext()) {
            VerifierFactoryObserver verifierFactoryObserver = (VerifierFactoryObserver)iterator.next();
            verifierFactoryObserver.update(string);
        }
    }

    public static Verifier[] getVerifiers() {
        Verifier[] verifierArray = new Verifier[hashMap.values().size()];
        return hashMap.values().toArray(verifierArray);
    }

    public static void attach(VerifierFactoryObserver verifierFactoryObserver) {
        observers.addElement(verifierFactoryObserver);
    }

    public static void detach(VerifierFactoryObserver verifierFactoryObserver) {
        observers.removeElement(verifierFactoryObserver);
    }
}

