/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.bcel.Repository;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.statics.Pass1Verifier;
import org.apache.bcel.verifier.statics.Pass2Verifier;
import org.apache.bcel.verifier.statics.Pass3aVerifier;
import org.apache.bcel.verifier.structurals.Pass3bVerifier;

public class Verifier {
    private final String classname;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private HashMap p3avs = new HashMap();
    private HashMap p3bvs = new HashMap();

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int n2) {
        String string = Integer.toString(n2);
        Pass3aVerifier pass3aVerifier = (Pass3aVerifier)this.p3avs.get(string);
        if (this.p3avs.get(string) == null) {
            pass3aVerifier = new Pass3aVerifier(this, n2);
            this.p3avs.put(string, pass3aVerifier);
        }
        return pass3aVerifier.verify();
    }

    public VerificationResult doPass3b(int n2) {
        String string = Integer.toString(n2);
        Pass3bVerifier pass3bVerifier = (Pass3bVerifier)this.p3bvs.get(string);
        if (this.p3bvs.get(string) == null) {
            pass3bVerifier = new Pass3bVerifier(this, n2);
            this.p3bvs.put(string, pass3bVerifier);
        }
        return pass3bVerifier.verify();
    }

    private Verifier() {
        this.classname = "";
    }

    Verifier(String string) {
        this.classname = string;
        this.flush();
    }

    public final String getClassName() {
        return this.classname;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() {
        int n2;
        int n3;
        Object object;
        int n4;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.p1v != null) {
            object2 = this.p1v.getMessages();
            n4 = 0;
            while (n4 < ((String[])object2).length) {
                arrayList.add("Pass 1: " + (String)object2[n4]);
                ++n4;
            }
        }
        if (this.p2v != null) {
            object2 = this.p2v.getMessages();
            n4 = 0;
            while (n4 < ((Object)object2).length) {
                arrayList.add("Pass 2: " + (String)object2[n4]);
                ++n4;
            }
        }
        object2 = this.p3avs.values().iterator();
        while (object2.hasNext()) {
            Pass3aVerifier pass3aVerifier = (Pass3aVerifier)object2.next();
            object = pass3aVerifier.getMessages();
            n3 = pass3aVerifier.getMethodNo();
            n2 = 0;
            while (n2 < ((Object)object).length) {
                arrayList.add("Pass 3a, method " + n3 + " ('" + Repository.lookupClass(this.classname).getMethods()[n3] + "'): " + (String)object[n2]);
                ++n2;
            }
        }
        Iterator iterator = this.p3bvs.values().iterator();
        while (iterator.hasNext()) {
            object = (Pass3bVerifier)iterator.next();
            String[] stringArray = ((PassVerifier)object).getMessages();
            n2 = ((Pass3bVerifier)object).getMethodNo();
            int n5 = 0;
            while (n5 < stringArray.length) {
                arrayList.add("Pass 3b, method " + n2 + " ('" + Repository.lookupClass(this.classname).getMethods()[n2] + "'): " + stringArray[n5]);
                ++n5;
            }
        }
        object = new String[arrayList.size()];
        n3 = 0;
        while (n3 < arrayList.size()) {
            object[n3] = (String)arrayList.get(n3);
            ++n3;
        }
        return object;
    }

    public static void main(String[] stringArray) {
        System.out.println("JustIce by Enver Haase, (C) 2001. http://bcel.sourceforge.net\n");
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            String[] stringArray2;
            int n4;
            if (stringArray[n2].endsWith(".class") && (n4 = stringArray[n2].lastIndexOf(".class")) != -1) {
                stringArray[n2] = stringArray[n2].substring(0, n4);
            }
            stringArray[n2] = stringArray[n2].replace('/', '.');
            System.out.println("Now verifiying: " + stringArray[n2] + "\n");
            Verifier verifier = VerifierFactory.getVerifier(stringArray[n2]);
            VerificationResult verificationResult = verifier.doPass1();
            System.out.println("Pass 1:\n" + verificationResult);
            verificationResult = verifier.doPass2();
            System.out.println("Pass 2:\n" + verificationResult);
            if (verificationResult == VerificationResult.VR_OK) {
                stringArray2 = Repository.lookupClass(stringArray[n2]);
                n3 = 0;
                while (n3 < stringArray2.getMethods().length) {
                    verificationResult = verifier.doPass3a(n3);
                    System.out.println("Pass 3a, method " + n3 + " ['" + stringArray2.getMethods()[n3] + "']:\n" + verificationResult);
                    verificationResult = verifier.doPass3b(n3);
                    System.out.println("Pass 3b, method number " + n3 + " ['" + stringArray2.getMethods()[n3] + "']:\n" + verificationResult);
                    ++n3;
                }
            }
            System.out.println("Warnings:");
            stringArray2 = verifier.getMessages();
            if (stringArray2.length == 0) {
                System.out.println("<none>");
            }
            n3 = 0;
            while (n3 < stringArray2.length) {
                System.out.println(stringArray2[n3]);
                ++n3;
            }
            System.out.println("\n");
            verifier.flush();
            Repository.clearCache();
            System.gc();
            ++n2;
        }
    }
}

