/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.AttributeHTML;
import org.apache.bcel.util.Class2HTML;
import org.apache.bcel.util.ConstantHTML;

final class MethodHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private ConstantHTML constant_html;
    private AttributeHTML attribute_html;

    MethodHTML(String string, String string2, Method[] methodArray, Field[] fieldArray, ConstantHTML constantHTML, AttributeHTML attributeHTML) {
        this.class_name = string2;
        this.attribute_html = attributeHTML;
        this.constant_html = constantHTML;
        this.file = new PrintWriter(new FileOutputStream(string + string2 + "_methods.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        this.file.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
        int n2 = 0;
        while (n2 < fieldArray.length) {
            this.writeField(fieldArray[n2]);
            ++n2;
        }
        this.file.println("</TABLE>");
        this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
        int n3 = 0;
        while (n3 < methodArray.length) {
            this.writeMethod(methodArray[n3], n3);
            ++n3;
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    private void writeField(Field field) {
        String string = Utility.signatureToString(field.getSignature());
        String string2 = field.getName();
        String string3 = Utility.accessToString(field.getAccessFlags());
        string3 = Utility.replace(string3, " ", "&nbsp;");
        this.file.print("<TR><TD><FONT COLOR=\"#FF0000\">" + string3 + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(string) + "</TD><TD><A NAME=\"field" + string2 + "\">" + string2 + "</A></TD>");
        Attribute[] attributeArray = field.getAttributes();
        int n2 = 0;
        while (n2 < attributeArray.length) {
            this.attribute_html.writeAttribute(attributeArray[n2], string2 + "@" + n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < attributeArray.length) {
            if (attributeArray[n3].getTag() == 1) {
                String string4 = ((ConstantValue)attributeArray[n3]).toString();
                this.file.print("<TD>= <A HREF=\"" + this.class_name + "_attributes.html#" + string2 + "@" + n3 + "\" TARGET=\"Attributes\">" + string4 + "</TD>\n");
                break;
            }
            ++n3;
        }
        this.file.println("</TR>");
    }

    private final void writeMethod(Method method, int n2) {
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributeArray = method.getAttributes();
        string4 = Utility.replace(string4, " ", "&nbsp;");
        String string5 = Class2HTML.toHTML(string3);
        this.file.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + n2 + ">" + string4 + "</A></FONT></TD>");
        this.file.print("<TD>" + Class2HTML.referenceType(string2) + "</TD><TD>" + "<A HREF=" + this.class_name + "_code.html#method" + n2 + " TARGET=Code>" + string5 + "</A></TD>\n<TD>(");
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.file.print(Class2HTML.referenceType(stringArray[n3]));
            if (n3 < stringArray.length - 1) {
                this.file.print(", ");
            }
            ++n3;
        }
        this.file.print(")</TD></TR>");
        int n4 = 0;
        while (n4 < attributeArray.length) {
            int n5;
            Object[] objectArray;
            this.attribute_html.writeAttribute(attributeArray[n4], "method" + n2 + "@" + n4, n2);
            byte by2 = attributeArray[n4].getTag();
            if (by2 == 3) {
                this.file.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                objectArray = ((ExceptionTable)attributeArray[n4]).getExceptionIndexTable();
                n5 = 0;
                while (n5 < objectArray.length) {
                    this.file.print(this.constant_html.referenceConstant((int)objectArray[n5]));
                    if (n5 < objectArray.length - 1) {
                        this.file.print(", ");
                    }
                    ++n5;
                }
                this.file.println("</TD></TR>");
            } else if (by2 == 2) {
                objectArray = ((Code)attributeArray[n4]).getAttributes();
                n5 = 0;
                while (n5 < objectArray.length) {
                    this.attribute_html.writeAttribute(objectArray[n5], "method" + n2 + "@" + n4 + "@" + n5, n2);
                    ++n5;
                }
            }
            ++n4;
        }
    }
}

